<?php

/**
 * Part of the Joomla Framework Database Package
 *
 * @copyright  Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

namespace Joomla\Database\Query;

use Joomla\Database\QueryInterface;

// phpcs:disable PSR1.Files.SideEffects
trigger_deprecation(
    'joomla/database',
    '2.0.0',
    '%s() is deprecated and will be removed in 3.0, all query objects should implement %s instead.',
    LimitableInterface::class,
    QueryInterface::class
);
// phpcs:enable PSR1.Files.SideEffects

/**
 * Joomla Database Query LimitableInterface.
 *
 * @since       1.0
 * @deprecated  3.0  Capabilities will be required in Joomla\Database\QueryInterface
 */
interface LimitableInterface
{
    /**
     * Method to modify a query already in string format with the needed additions to make the query limited to a particular number of
     * results, or start at a particular offset.
     *
     * @param   string   $query   The query in string format
     * @param   integer  $limit   The limit for the result set
     * @param   integer  $offset  The offset for the result set
     *
     * @return  string
     *
     * @since   1.0
     */
    public function processLimit($query, $limit, $offset = 0);

    /**
     * Sets the offset and limit for the result set, if the database driver supports it.
     *
     * Usage:
     * $query->setLimit(100, 0); (retrieve 100 rows, starting at first record)
     * $query->setLimit(50, 50); (retrieve 50 rows, starting at 50th record)
     *
     * @param   integer  $limit   The limit for the result set
     * @param   integer  $offset  The offset for the result set
     *
     * @return  $this
     *
     * @since   1.0
     */
    public function setLimit($limit = 0, $offset = 0);
}
