<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewRentHistory{

  static function showUsersRentHistory($option, & $rows_item, & $return_item, &$history_item, & $userlist, $type, $show_fields,$usermenu, $sort_arr, $entity_list,$request_prices){
    global $user, $db, $entityFieldLists;
//    var_dump($rows_item);
    // Load mooTools
    //JHtml::_('behavior.framework', true);
    $doc = JFactory::getDocument();
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_RENT_HISTORY_SHOW') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/jquerOs-ui.min.css");
    $doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/admin_style.css");
    
    $doc->addScript(JURI::root() . "components/com_os_cck/assets/js/jquerOs-ui.min.js");
        //timepicker
    $doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/jquery.cck_timepicker.css");
    $doc->addScript(JURI::root() . "components/com_os_cck/assets/js/jquery.cck_timepicker.js");

    $table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php?option=com_os_cck&task=users_rent_history', 'users_rent_history');
   
    $table->create_filters('<div>'.$userlist.'</div>');
    $table->create_filters('<div>'.$entity_list.'</div>');
    

    $table->create_first_row_collumn(JHtml::_('grid.checkall'), '', 'admin-order-title-checkbox'); 
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_ID'), 'inst_id', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-id'); 
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_ENTITY'), 'inst_entity', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_RENT_FROM'), 'rent_from', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_RENT_UNTIL'), 'rent_until', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_RENT_RETURN'), 'rent_return', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_SHOW_REQUEST'), '', 'admin-order-title-date'); 

    for($i = 0; $i < count($rows_item); $i++) { 
        // var_dump($rows_item[$i]);
        $parentInstance = new os_cckEntityInstance($db->_db);
        $parentInstance->load($rows_item[$i]->eiid);
        
        $show_in_orders_fields = array();
                
        if(isset($entityFieldLists[$parentInstance->fk_eid])){
            $fields = $entityFieldLists[$parentInstance->fk_eid];
        }else{
            $fields = array();
        }
        foreach($fields as $field){
            $params = new JRegistry;
            $params->loadString($field->params);
            if($params->get('show_in_rent_requests', '') == 'yes'){
                $show_in_orders_fields[] = $field;
            }
        }

        $table->create_second_row_collumn('Title');
        $table->create_second_row_collumn('Price');
        
        foreach($show_in_orders_fields as $order_fields){
            $table->create_second_row_collumn($order_fields->field_name);
        }
    }

    for($i = 0; $i < count($rows_item); $i++) { 

        $request_data = array();
        $data_second_row = array();
        $row = $rows_item[$i];

        $request_data[] = JHTML::_('grid.id',$i, $rows_item[$i]->eiid, ($rows_item[$i]->checked_out && $rows_item[$i]->checked_out != $my->id), 'eiid');
        $request_data[] = $rows_item[$i]->eiid;
        $request_data[] = $rows_item[$i]->entity;
        $request_data[] = $rows_item[$i]->rent_from;
        $request_data[] = $rows_item[$i]->rent_until;
        $request_data[] = ($rows_item[$i]->rent_return)?$rows_item[$i]->rent_return : '<b>In Rent</b>';
        $request_data[] = ($rows_item[$i]->request_id) ? '<a href="index.php?option=com_os_cck&task=edit_rent_request_instance&eiid=' . $rows_item[$i]->request_id . '">'.cck_lang_text("COM_OS_CCK_ORDERS_DETAILS").'</a>' : '';
        
        $class = $rows_item[$i]->notreaded?'admin-order-not-readed':'';
        $table->create_first_row_data($request_data, $class);


        $parentInstance = new os_cckEntityInstance($db->_db);
        $parentInstance->load($rows_item[$i]->eiid);

        $show_in_orders_fields = array();
                
        $fields = $entityFieldLists[$parentInstance->fk_eid];
        foreach($fields as $field){
            $params = new JRegistry;
            $params->loadString($field->params);
            if($params->get('show_in_rent', '') == 'yes'){
                $show_in_orders_fields[] = $field;
            }
        }
        
        $calculated_price = 0;
        $quantity = 1;
        $not_calc_price = '';
        $coupon = false;
            //  var_dump($order_prices);
        foreach ($request_prices[$rows_item[$i]->eiid] as $key => $single_field){
//                            var_dump($single_field);
            if($single_field->price_ordering == -1){
                $field = new os_cckEntityField($db->_db);
                $field->load($single_field->fk_fid);

                unset($request_prices[$rows_item[$i]->eiid][$key]);
            }
        }
        
        
        foreach ($request_prices[$rows_item[$i]->eiid] as $single_field){
            // if($single_field->сart_item == $cart_item){
                $field = new os_cckEntityField($db->_db);
                $field->load($single_field->fk_fid); 

                if($single_field->price_type == 'base_price'){
                        if($single_field->quantity == 0) $single_field->quantity =1;
                        if($single_field->quantity>1) {$quantity = $single_field->quantity;}
                        $calculated_price = $calculated_price + ($single_field->price_value * $single_field->quantity);
                }elseif($single_field->price_type == 'val+' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price + ($single_field->price_value * $quantity);
                    }else if($single_field->price_type == 'val-' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price - ($single_field->price_value * $quantity);
                    }else if($single_field->price_type == 'percent+' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price + (round($calculated_price/100 * $single_field->price_value, 2));
                    }else if($single_field->price_type == 'percent-' && $single_field->price_value != '0.00'){
                        $calculated_price = $calculated_price - (round($calculated_price/100 * $single_field->price_value, 2));
                    }
            // }

            //var_dump($single_field);
        }
        
        $calculated_price = calculatedCurrency($parentInstance, $calculated_price)[0];

        $data_second_row[] = $parentInstance->title; 
        $data_second_row[] = $calculated_price;
        
        foreach ($show_in_orders_fields as $field){
            $value = $parentInstance->getFieldValue($field);
            if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                $data_second_row[] = '';
                continue;
            }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                $data_second_row[] = '';
                continue;
            }
            $print_value = '';
            if($field->field_type == 'text_select_list'){
                $value = (isset($value[0]->data))?$value[0]->data : '';
                $value = json_decode($value);
                $params = new JRegistry;
                $params->loadString($field->params);
                $allowed_values = $params->get("allowed_value");
                $allowed_values = explode('\sprt', $allowed_values);
                $tmp_val = array();

                if(is_array($value)){

                    foreach($value as $val){

                        if(isset($allowed_values[$val])){
                            $tmp_val[] = cck_lang_text($allowed_values[$val]);
                        }
                    }
                }

                $print_value = implode(', ', $tmp_val);
                
//                                $temp_val = json_decode($value[0]->data);
//                                if(is_array($temp_val)){
//                                    $temp_val = implode(', ', $temp_val);
//                                    $print_value = $temp_val;
//                                }
//                                var_dump(json_decode($value[0]->data));
            }elseif(stripos($field->field_type, 'pricefield') !== false){
                $data_second_row[] = '';
                continue;
            }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                $print_value = $value[0]->data;
            }
            $data_second_row[] = $print_value;
            // echo '<div><div>'.$field->field_name.'</div><div>'.$print_value.'</div></div>';
//                            var_dump($value);
        }
        $table->create_second_row_data(array($data_second_row));
    }
    echo $table->viewTable();
    
  }

}
