<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/


class AdminViewReview{
  static function showReviews($option, & $rows_item, & $clist,
                                & $publist, & $search, & $pageNav, & $sort_arr, $show_fields,$entity_list){
    global $doc, $user, $app, $session, $db, $entityFieldLists;
    $db = new os_cckDb();
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_COM_TITLE_REVIEWS') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $onclick = (version_compare(JVERSION, "1.6.0", "lt")) ? "checkAll(" . count($rows_item) . ");" : "Joomla.checkAll(this);";


    $table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php?option=com_os_cck&task=manage_review', 'manage_review');
    
    $table->create_button('Publish', 'publish_reviews', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-check');
    $table->create_button('Unpublish', 'unpublish_reviews', JURI::root() . 'components/com_os_cck/images/btn_d.png', 'fa-close');
    $table->create_button('Delete', 'delete_review', JURI::root() . 'components/com_os_cck/images/btn_d.png', 'fa-close');
    $table->create_button('Mark as viewed', 'is_readed', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-check');
    
    $table->create_filters('<div class="search_block"><input type="text" placeholder="'.cck_lang_text('COM_OS_CCK_SHOW_SEARCH').'" name="search" value="'.$search.'" class="inputbox" onChange="document.adminForm.submit();"/><button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button></div>');
    $table->create_filters('<div>'.$publist.'</div>');
    $table->create_filters('<div>'.$clist.'</div>');
    $table->create_filters('<div>'.$entity_list.'</div>');
    
    $table->title_class = 'admin-request-title';
    $table->first_row_custom_class = 'admin-request-standart-fields';
    $table->limitbox = '<div class="btn-group pull-right hidden-phone">
        <label for="limit" class="element-invisible">'. cck_lang_text('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC') .'</label>'. $pageNav->getLimitBox() .'</div>';

    $table->create_first_row_collumn(JHtml::_('grid.checkall'), '', 'admin-order-title-checkbox');  
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_ID'), 'inst_id', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-id');   
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_ENTITY'), 'inst_entity', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-email');   
    $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_REVIEW_DATE'), 'created', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date');   
    $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_PUBLIC'), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_APPROVED'), '', 'admin-order-title-date'); 
    $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_CONTROL'), '', 'admin-order-title-date'); 

    
    $table->create_second_row_collumn('Title');

    for($i = 0; $i < count($rows_item); $i++) { 
      // var_dump($rows_item[$i]);
      $parentInstance = new os_cckEntityInstance($db->_db);
      $parentInstance->load($rows_item[$i]->fid_parent);
      
      $show_in_orders_fields = array();
              
      if(isset($entityFieldLists[$parentInstance->fk_eid])){
        $fields = $entityFieldLists[$parentInstance->fk_eid];
      }else{
        $fields = array();
      }
      foreach($fields as $field){
          $params = new JRegistry;
          $params->loadString($field->params);
          if($params->get('show_in_requests', '') == 'yes'){
              $show_in_orders_fields[] = $field;
          }
      }

      $table->create_second_row_collumn('Title');
      
      foreach($show_fields as $value){
        foreach($value as $field){
          $table->create_second_row_collumn($field->field_name);
        }
      }
    }

    for($i = 0; $i < count($rows_item); $i++) { 
      $request_data = array();
      $data_second_row = array();
      $row = $rows_item[$i];

      if ($row->checked_out && $row->checked_out != $user->id) {
        $request_data[] = '';
      
      } else {
        $request_data[] =  JHTML::_('grid.id',$i, $rows_item[$i]->eiid, ($rows_item[$i]->checked_out && $rows_item[$i]->checked_out != $user->id), 'eiid');
      }
      $request_data[] = '<a href="#edit_review" onClick="return cckSendForm(\'cb'.$i.'\',\'edit_review\', \'\')">'.$row->eiid.'</a>';

      
      $request_data[] = $rows_item[$i]->entity;
      $request_data[] = $rows_item[$i]->created;

      $task = $row->published ? 'unpublish_reviews' : 'publish_reviews';
      $alt = $row->published ? 'Unpublish' : 'Publish';
      $img = $row->published ? 'tick.png' : 'publish_x.png';
      $task1 = $row->approved ? 'unapprove_reviews' : 'approve_reviews';
      $alt1 = $row->approved ? 'Unapproved' : 'Approved';
      $img1 = $row->approved ? 'tick.png' : 'publish_x.png';
      $img = "components/com_os_cck/images/{$img}";
      $img1 = "components/com_os_cck/images/{$img1}";

      $temp_row_data = '';

      if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){
        $temp_row_data .= '<a href="javascript: void(0);" onClick="return cckSendForm(\'cb'.$i.'\',\''.$task.'\',\'adminForm\')">';
      }
      
      $temp_row_data .= '<img src="'.$img.'" width="12" height="12" border="0" alt="'.$alt.'"/>';
      if (JFactory::getUser()->authorise('publish_reviews', 'com_os_cck')){
        $temp_row_data .= '</a>';
      }
      $request_data[] = $temp_row_data;

      $temp_row_data = '';
      if (JFactory::getUser()->authorise('publish_instances', 'com_os_cck')){
        $temp_row_data .= '<a href="javascript: void(0);" onClick="return cckSendForm(\'cb'.$i.'\',\''.$task1.'\',\'adminForm\')">';
      }
      
      $temp_row_data .= '<img src="'.$img1.'" width="12" height="12" border="0" alt="'.$alt.'"/>';
      if (JFactory::getUser()->authorise('publish_instances', 'com_os_cck')){
        $temp_row_data .= '</a>';
      }
      $request_data[] = $temp_row_data;

      if ($row->checked_out) {
        $request_data[] = $row->editor;
      }else{
        $request_data[] = '';
      }


      $class = 'row' . ($i % 2) . ' ';
      if($rows_item[$i]->notreaded === 1){
          $class .= ' admin-order-not-readed';
      }
      
      $table->create_first_row_data($request_data, $class);

      
      $parentInstance = new os_cckEntityInstance($db->_db);
      $parentInstance->load($rows_item[$i]->fid_parent);
      
      $show_in_orders_fields = array();
              
      if(isset($entityFieldLists[$parentInstance->fk_eid])){
        $fields = $entityFieldLists[$parentInstance->fk_eid];
      }else{
        $fields = array();
      }
      foreach($fields as $field){
          $params = new JRegistry;
          $params->loadString($field->params);
          if($params->get('show_in_requests', '') == 'yes'){
              $show_in_orders_fields[] = $field;
          }
      }

      
      $data_second_row[] = $parentInstance->title;
      // var_dump($show_in_orders_fields);
      foreach($show_fields as $key => $value){
        foreach($value as $field){
          // var_dump($field);
          $html = '';
          if($rows_item[$i]->fk_eid != $key){
            $data_second_row[] = '<div class="admin-order-standart-fields-email"></div>';
            continue;
          }
          if($field->field_type == 'categoryfield'){
            $data_second_row[] = "<div class='admin-order-standart-fields-email'>$rows_item[$i]->category</div>";
            continue;
          }
          
            $entityInstance = new os_cckEntityInstance($db->_db);
            $entityInstance->load($rows_item[$i]->eiid);
            $value = $entityInstance->getFieldValue($field);
            
            $temp_html = '';
            if(property_exists($field, 'options') && $field->field_type=='imagefield'  && isset($field->options['width']) && isset($field->options['height'])){
              $temp_html = 'width:'.$field->options['width'].'px; height:'.$field->options['height'].'px;';
            }
            $html .= '<div><span class="col_box" style="display:block;'.$temp_html.'">';
                
            ob_start();
              require getSiteShowFiledViewPath('com_os_cck', $field->field_type);
              $html .= ob_get_contents();
            ob_end_clean();
            $html .= '</span></div>';
            $data_second_row[] = $html;
                    
        }
      }
      foreach ($show_in_orders_fields as $field){
        // var_dump($field);
          $value = $parentInstance->getFieldValue($field);
          if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
              continue;
          }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
              continue;
          }
          $print_value = '';
          if($field->field_type == 'text_select_list'){
              $value = (isset($value[0]->data))?$value[0]->data : '';
              $value = json_decode($value);
              $params = new JRegistry;
              $params->loadString($field->params);
              $allowed_values = $params->get("allowed_value");
              $allowed_values = explode('\sprt', $allowed_values);
              $tmp_val = array();

              if(is_array($value)){

                  foreach($value as $val){

                      if(isset($allowed_values[$val])){
                          $tmp_val[] = cck_lang_text($allowed_values[$val]);
                      }
                  }
              }

              $print_value = implode(', ', $tmp_val);

          }elseif(stripos($field->field_type, 'pricepfield') !== false){
              
              continue;
          }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
              $print_value = $value[0]->data;
          }

      }
      $table->create_second_row_data(array($data_second_row));
      

        }

        $table->paginator = $pageNav->getListFooter();

      // $buttons = new adminHeaderButton();
      
      echo $table->viewTable();

  }

  static function editReview($option, $entityInstance, $layout, $layout_params){
    global $session, $os_cck_configuration, $app, $doc;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_COM_TITLE_REVIEWS') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    $doc->addStyleSheet(JUri::root() . "/components/com_os_cck/assets/css/fine-uploader-new.css");
//    JUri::root() . "/components/com_os_cck/assets/js/fine-uploader.js" 
            
    require getLayoutPathCCK::getAdminLayoutViewPath('com_os_cck','edit_review');
  }

  static function showParentInstance($option, $entityInstance, $layout, $layout_params){
    global $session, $os_cck_configuration, $app, $doc;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_COM_TITLE_REVIEWS') . "</div>";
    $app = JFactory::getApplication();
    $app->JComponentTitle = $html;
    require getLayoutPathCCK::getAdminLayoutViewPath('com_os_cck','parent_instance');
  }

}
