<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminRent_history{

  static function users_rent_history($option, $eiid){
    global $db, $user,$app, $entityFieldLists;
    $db = new os_cckDb();
      if(!JFactory::getUser()->authorise('access_to_user_rent_history', 'com_os_cck')){
          $app->enqueueMessage("Access denied", 'error');
          return;
      }
    $session = JFactory::getSession();
    // $owner = JRequest::getVar("owner_id",'-1'); //add nik
    $entity_id = $app->getUserStateFromRequest("entity_id{$option}", 'entity_id', '');
    $entities = array();
    $entities[] = array('value' => '', 'text' => cck_lang_text('COM_OS_CCK_OPTION_ALL_ENTITIES'));
    // $query = "SELECT ent.eid AS value, ent.name AS text FROM #__os_cck_entity as ent"
    //           ."\n LEFT JOIN #__os_cck_layout as lay ON lay.fk_eid = ent.eid WHERE lay.type = 'add_instance' GROUP BY ent.eid";
    $query = "SELECT eid AS value, name AS text FROM #__os_cck_entity ORDER BY name ";

    $db->setQuery($query);
    $ent = $db->loadObjectList("value");


    $entities = (count($ent) > 1) ? array_merge($entities, (array)$ent) : $entities;
    $entety_result = false;
    foreach($entities as $temp_ent){
        if(is_object($temp_ent) && property_exists($temp_ent, 'value') && $temp_ent->value == $entity_id) $entety_result = true;
    }
    if(!$entety_result) $entity_id = '';
    $entity_list = JHTML::_('select.genericlist',$entities, 'entity_id', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $entity_id);

    $item_sort_param = mosGetParam($_GET, 'sort', 'l.fk_eiid');
    if (is_array($sort_arr = $session->get('eq_itemsort', ''))) {
      if(protectInjectionWithoutQuote('sorting_direction','')){
        if(protectInjectionWithoutQuote('sorting_direction')=="ASC"){
          $sort_arr['sorting_direction'] = "DESC";
        }else{
          $sort_arr['sorting_direction'] = "ASC";
        }
      }elseif($session->get('sorting_direction','')){ 
        $sort_arr['sorting_direction'] = $session->get('sorting_direction');
      }else{
        $sort_arr['sorting_direction']="ASC";
      }
      if ($item_sort_param == $sort_arr['field']) {
      } else {
        $sort_arr['field'] = $item_sort_param;
      }

      if($item_sort_param == 'inst_entity'){
        $sort_string = 'ce.name' . " " . $sort_arr['sorting_direction'];
      }else if($item_sort_param == 'inst_id'){
        $sort_string = 'l.fk_eiid' . " " . $sort_arr['sorting_direction'];
//////////////////
      }else if($item_sort_param == 'rent_from'){
        $sort_string = 'l.rent_from' . " " . $sort_arr['sorting_direction'];

      }else if($item_sort_param == 'rent_until'){
        $sort_string = 'l.rent_until' . " " . $sort_arr['sorting_direction'];

      }else if($item_sort_param == 'rent_return'){
        $sort_string = 'l.rent_return' . " " . $sort_arr['sorting_direction'];
///////////////
      }else if($item_sort_param == "l.fk_eiid"){
        $sort_string = $item_sort_param . " " . $sort_arr['sorting_direction'];
      }
    } else { 
      $sort_arr = array();
      if(protectInjectionWithoutQuote('sorting_direction','')){
        $sort_arr['sorting_direction'] = protectInjectionWithoutQuote('sorting_direction');
      }elseif($session->get('sorting_direction','')){ 
        $sort_arr['sorting_direction'] = $session->get('sorting_direction');
      }else{
        $sort_arr['sorting_direction']="ASC";
      }

      if($item_sort_param == 'inst_entity'){
        $sort_string = 'ce.name'. " " . $sort_arr['sorting_direction'];
      }else if($item_sort_param == 'inst_id'. " " . $sort_arr['sorting_direction']){
        $sort_string = 'l.fk_eiid'. " " . $sort_arr['sorting_direction'];
////////////////////////
      }else if($item_sort_param == 'rent_from'){
        $sort_string = 'l.rent_from' . " " . $sort_arr['sorting_direction'];
        
      }else if($item_sort_param == 'rent_until'){
        $sort_string = 'l.rent_until' . " " . $sort_arr['sorting_direction'];

      }else if($item_sort_param == 'rent_return'){
        $sort_string = 'l.rent_return' . " " . $sort_arr['sorting_direction'];
/////////////
      }else if($item_sort_param == "l.fk_eiid"){
        $sort_string = $item_sort_param. " " . $sort_arr['sorting_direction'];
      }
      $sort_arr['field'] = $item_sort_param;
    }
    
    $where = '';
    
    if ($entity_id != '' && isset($ent[$entity_id])) {
        $where = "AND a.fk_eid ='{$entity_id}'";
    }

    $session->set('eq_itemsort', $sort_arr);

    $owner = $app->getUserStateFromRequest("owner_id", 'owner_id', '');

    $rows = $show_fields = array();
    if($owner !=-1){
      $select="SELECT a.*, cc.name AS category, l.id as rent_id, cl.params as lay_params,ce.name AS entity, l.rent_from as rent_from, " .
          "\n l.rent_return as rent_return, l.rent_until as rent_until, " .
          "\n l.user_name as user_name, l.user_email as user_email, " .
          "\n cc.rent_request AS for_rent, l.request_id as request_id" .
          "\n FROM #__os_cck_entity_instance AS a" .
          "\n LEFT JOIN #__os_cck_categories_connect AS CC_rel ON CC_rel.fk_eiid = a.eiid" .
          "\n LEFT JOIN #__os_cck_categories AS cc ON cc.cid = CC_rel.fk_cid" .
          "\n LEFT JOIN #__os_cck_layout AS cl ON cl.lid = a.fk_lid ".
          "\n LEFT JOIN #__os_cck_entity AS ce ON ce.eid = a.fk_eid ".
          "\n LEFT JOIN #__os_cck_rent AS l ON l.fk_eiid = a.eiid" .
          "\n WHERE (l.fk_userid=".$db->Quote($owner).
          "\n OR l.user_name=".$db->Quote($owner).")" . $where . " ORDER BY $sort_string";
      $db->setQuery($select);
      try {
          $db->execute();
      } catch (RuntimeException $e) {
          echo "<script> alert('" . addslashes($e->getMessage()) . "'); window.history.go(-1); </script>\n";
          exit ();
      }
//      if (!$db->execute()) {
//        echo "<script> alert('" . addslashes($db->getErrorMsg()) . "'); window.history.go(-1); </script>\n";
//        exit ();
//      }
      $rows = $db->loadObjectList();
      
      // print_r($rows);
      /////

      //id = l.fk_eiid

      $show_fields = $entityEaaray = array();
      if(count($rows)>0){
        foreach ($rows as $row) {
          $lay_params = unserialize($row->lay_params);
          $entityEaaray[] = $row->fk_eid;
          $layoutArray[] = $row->fk_lid;
        }
        foreach(array_unique($entityEaaray) as $key => $value){

          $layout = new os_cckLayout($db->_db);
          $layout->load($layoutArray[$key]);
          $bootstrap_version = $session->get( 'bootstrap','2');
          $layout_html = urldecode($layout->getLayoutHtml($bootstrap_version));
          $layout_params = unserialize($layout->params);
          $extra_fields_list = $entityFieldLists[$value];;
          foreach($extra_fields_list as $Fieldvalue){
            $params = new JRegistry;
            $params->loadString($Fieldvalue->params);
            if($params->get('show_in_rent', '') == 'yes' && strpos($layout_html,"{|f-".$Fieldvalue->fid."|}")){
              $fieldNames[$key]['ent_name'] = $Fieldvalue->fk_eid;
              $fieldNames[$key]['field_type'] = $Fieldvalue->field_type;
              $fieldNames[$key]['fields'][] = $Fieldvalue->db_field_name;//need for use in search // [][table_name][column_mname]
              $show_fields[$value][]= $Fieldvalue;
            }
          }
        }
        ksort($show_fields);
      }
    }

    


    $userlist[] = JHTML::_('select.option','-1', cck_lang_text('COM_OS_CCK_OPTION_ALL_USERS'));
    $db->setQuery("SELECT DISTINCT fk_userid AS value, user_name AS text from #__os_cck_rent ORDER BY user_name");
    $users = $db->loadObjectList();
    // var_dump($users);
    $userlist = array_merge($userlist, $users);

    foreach ($userlist as $value) {
        if(!$value->value)
            $value->value = $value->text;
        if(!$value->text){
          $value->text = '';
        }
    }
    

    // var_dump($userlist);
    $usermenu = JHTML::_('select.genericlist',$userlist, 'owner_id', 'class="inputbox input-medium" size="1" 
        onchange="document.adminForm.submit();"', 'value', 'text', $owner);

    $request_prices = array();
    foreach($rows as $request){
        $query = "SELECT op.*, o.fk_request_id FROM #__os_cck_orders_price as op "
                . "LEFT JOIN #__os_cck_orders as o ON o.id=op.fk_order_id "
                . " WHERE o.fk_request_id = ".$request->request_id." ";
        $db->setQuery($query);
        $request_price = $db->loadObjectList();
        
        $request_prices[$request->eiid] = $request_price;
        
    }

    // var_dump($request_prices); exit;
    
    AdminViewRentHistory:: showUsersRentHistory($option, $rows,$return_item,$history_item, $usermenu, "rent",$show_fields,$usermenu, $sort_arr, $entity_list, $request_prices);
  }

}
