<?php

if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );

if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */

class com_MediaLibraryInstallerScript{
    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent){
        // $parent is the class calling this method
    }
 
    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent){
        // $parent is the class calling this method
        if(file_exists(JPATH_ROOT."/administrator/components/com_medialibrary/uninstall.medialibrary.php"))        
            require_once(JPATH_ROOT."/administrator/components/com_medialibrary/uninstall.medialibrary.php");
    }
 
    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent){
        // $parent is the class calling this method
    }

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent){
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Save admin settings before updete
        if ( $type == 'update' ) {
            // $medialibrary_configuration:
            if(is_file(JPATH_ROOT . '/administrator/components/com_medialibrary/admin.medialibrary.class.conf.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_medialibrary/admin.medialibrary.class.conf.php');
                if(isset($medialibrary_configuration) )
                    $GLOBALS['medialibrary_configuration_old'] = $medialibrary_configuration;
            }
        }


        $db = JFactory::getDBO();
        $db->setQuery("DELETE FROM #__update_sites WHERE name = 'Medialibrary`s Update'");
        $db->query();
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent){
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)


        // Marge old admin settings and new configuration after update
        global $medialibrary_configuration_old;

        if ( $type == 'update' ) {
            // $medialibrary_configuration new from update files
            if(is_file(JPATH_ROOT . '/administrator/components/com_medialibrary/admin.medialibrary.class.conf_new.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_medialibrary/admin.medialibrary.class.conf_new.php');
                if(isset($medialibrary_configuration) && isset($medialibrary_configuration_old)  )
                    $medialibrary_configuration = array_replace_recursive($medialibrary_configuration, $medialibrary_configuration_old);
            }
        }


        if(file_exists(JPATH_ROOT."/administrator/components/com_medialibrary/install.medialibrary.php")){
            require_once(JPATH_ROOT."/administrator/components/com_medialibrary/install.medialibrary.php");
            com_install2();
        }        

      // if(version_compare(JVERSION,"1.6.0","ge")) unlink(JPATH_ROOT."/components/com_medialibrary/metadata.xml");
    }
}
