<?php
/**
 *
 * @package  MediaLibrary
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Rob de Cleen(rob@decleen.com);
 * Homepage: https://ordasoft.com
 * @version: 4.6 Free
 * @license GNU General Public license version 2 or later; see LICENSE.txt
 *
 */
defined('JPATH_BASE') or die;

/**
 * Supports a modal article picker.
 *
 * @since  1.6
 */
class JFormFieldModal_Article_ML extends JFormFieldModal_Article
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $type = 'Modal_Article_ML';

	/**
	 * Method to get the field input markup.
	 
	 * @return  string  The field input markup.
	 *
	 * @since   1.6

	 */
	public function __construct() {
		
		$this->name = 'OnlineArticle';
		
		$allowNew    = $this->element['new'] = 'true';
		$allowEdit   = $this->element['edit'] = 'true';
		$allowClear  = $this->element['clear'] = 'true';
		$allowSelect = $this->element['select'] = 'true';

	}


	public function getInput()
	{
	
		$this->name = 'OnlineArticle';										
		
		return parent::getInput();
	}

	/**
	 * Method to get the field label markup.
	 *
	 * @return  string  The field label markup.
	 *
	 * @since   3.4
	 */
	public function getLabel()
	{
		return str_replace($this->id, $this->id . '_id', parent::getLabel());
	}
}
