<?php
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

/**
 * @version 4.0
 * @package MortgagePaymentCalculator FREE
 * @copyright 2017 OrdaSoft
 * @author 2017 Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru),Sergey Buchastiy (buchastiy1989@gmail.com)
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @description Mortgage Payment Calculator FREE
 * Homepage: http://www.ordasoft.com
*/
?>


<script>


function calculated(firstInit){

  jQuerMG(container+'input.mortgage-downpayment').focusout(function(event) {

      var value = ((jQuerMG(this).val()/jQuerMG(container+'.mortgage-price').val())*100).toFixed(4);
      jQuerMG(container+'input.mortgage-downpayment-percent').val(value); //change downpayment($)
      calculate_output(false)
  });

  jQuerMG(container+'input.mortgage-downpayment-percent').focusout(function(event) {

      var value = Math.ceil(jQuerMG(container+'.mortgage-price').val()*(jQuerMG(this).val()/100));
      jQuerMG(container+'input.mortgage-downpayment').val(value); //change downpayment(%)
      calculate_output(false)
  });

  jQuerMG(container+'input.mortgage-taxes').focusout(function(event) {

      var value = ((jQuerMG(this).val()/jQuerMG(container+'.mortgage-price').val())*100).toFixed(4)
      jQuerMG(container+'input.mortgage-tax-percent').val(value); //change taxes($)
      calculate_output(false)
  });

  jQuerMG(container+'input.mortgage-tax-percent').focusout(function(event) {

      var value = Math.ceil(jQuerMG(container+'.mortgage-price').val()*(jQuerMG(this).val()/100));
      jQuerMG(container+'input.mortgage-taxes').val(value); //change taxes(%)
      calculate_output(false)
  });

  calculate_output(firstInit); // initcalculate_output
}


function calculate_output(firstInit){

  var homePrice =  jQuerMG(container+'.mortgage-price').val();
  var downPayment =  jQuerMG(container+'.mortgage-downpayment').val();
  var downPaymentPercent = jQuerMG(container+'.mortgage-downpayment-percent').val();
  var amortization =  jQuerMG(container+'.mortgage-amortization').val();
  var interestPercent =  jQuerMG(container+'.mortgage-interest-percent').val(); 

  //var payment  (weekly, mounthly);2 button 

  ////////////////////////////The inputs below are simply added to the total amount/////////////////////////

  var maintenance =  jQuerMG(container+'.mortgage-maintenance').val(); 
  var rentalIncome =  jQuerMG(container+'.mortgage-rental-income').val(); 

  // var taxesInsurance    Add Taxes + Insurance checkbox + make visible html block
   
  var propertyTaxes =  jQuerMG(container+'.mortgage-taxes').val(); //($ /year)
  var propertyTaxesPercent =  jQuerMG(container+'.mortgage-tax-percent').val(); //(%)

  var homeInsurance =  jQuerMG(container+'.mortgage-home-insurance').val(); //($ /year)
  var mortgageInsurance =  jQuerMG(container+'.mortgage-insurance').val(); //($ /year)



  ///////////////////////////////Calculated/////////////////////////

  var value_downpayment = Math.ceil(homePrice*(downPaymentPercent/100))
  var value_taxes = Math.ceil(homePrice*(propertyTaxesPercent/100))
  //////Overview

  allPrincipal = Math.ceil(homePrice-value_downpayment); //Principal

  var selectedPayPeriod = jQuerMG(container+'.payment-option.active').text();


  if(!jQuerMG(container+'.mortgage-include-taxes-insurance').is(":checked"))
  {
    var propertyTaxes =  0
    var propertyTaxesPercent =  0
    var homeInsurance =  0
    var mortgageInsurance =  0
  }

  switch(selectedPayPeriod){

    case "<?php echo _MOD_CALC_MOR_WEEKLY;?>":
      inYear = 52;
      lessMonth = 4.36;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_WEEKLY_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_WEEKLY;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_FORTNIGHTLY;?>":
      inYear = 26;
      lessMonth = 2.18;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_FORTNIGHTLY_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_FORTNIGHTLY;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_MONTHLY;?>":
      inYear = 12;
      lessMonth = 1;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_MONTHLY_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_MONTHLY;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_TWO_MONTH;?>":
      inYear = 6;
      lessMonth = 0.5;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_TWO_MONTH_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_TWO_MONTH;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_QUARTERLY;?>":
      inYear = 4;
      lessMonth = 0.25;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_QUARTERLY_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_QUARTERLY;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_SEMI_ANNUAL;?>":
      inYear = 2;
      lessMonth = 0.1666;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_SEMI_ANNUAL_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_SEMI_ANNUAL;?>";
    break;

    case "<?php echo _MOD_CALC_MOR_ANNUAL;?>":
      inYear = 1;
      lessMonth = 0.08333;
      paymentPeriod = "<?php echo _MOD_CALC_MOR_ANNUAL_LABEL;?>";
      period = "/ <?php echo _MOD_CALC_MOR_ANNUAL;?>";
    break;

    default:
    inYear = 12;
    lessMonth = 1;
    paymentPeriod = "<?php echo _MOD_CALC_MOR_MONTHLY_LABEL;?>";
    period = "/ <?php echo _MOD_CALC_MOR_MONTHLY;?>";
    break;

  }

       allInterest = allPrincipal*Math.pow((1+((interestPercent/100)/inYear)),inYear*amortization)*(((interestPercent/100)/inYear)/(Math.pow(1+((interestPercent/100)/inYear),inYear*amortization)-1))

       allInterest = allInterest*inYear*amortization
       allInterest = Math.ceil(allInterest-allPrincipal)
       allTotal = Math.ceil(allPrincipal+allInterest)

       Count = Math.ceil(amortization*inYear); 
       Principal = Math.ceil(allPrincipal/Count);
       Interest = Math.ceil(allInterest/Count);
       Maintenance = Math.ceil(maintenance / lessMonth);
       PropertyTaxes = Math.ceil(propertyTaxes/(12*lessMonth));
       HomeInsurance = Math.ceil((Number(homeInsurance)+Number(mortgageInsurance))/(12*lessMonth));
       RentalIncome = Math.ceil(rentalIncome / lessMonth);

       Summ = Principal+Interest+Maintenance+PropertyTaxes+HomeInsurance-RentalIncome;

        

      jQuerMG(container+'input.mortgage-downpayment').val(value_downpayment); 
      jQuerMG(container+'input.mortgage-taxes').val(value_taxes);

      //////Overview
      jQuerMG(container+'.overview-principal .summary-value').text(allPrincipal+' <?php echo $currency;?>');
      jQuerMG(container+'.overview-interest .summary-value').text(allInterest+' <?php echo $currency;?>');
      jQuerMG(container+'.overview-total .summary-value').text(allTotal+' <?php echo $currency;?>');

      //////Monthly BIweekly

      jQuerMG(container+'.mortgage-payment-period').text(paymentPeriod);
      jQuerMG(container+'.payment-principal .summary-value').text(Principal+' <?php echo $currency;?>');
      jQuerMG(container+'.payment-interest .summary-value').text('+ '+Interest+' <?php echo $currency;?>');
      jQuerMG(container+'.payment-maintenance .summary-value').text('+ '+Maintenance+' <?php echo $currency;?>');

      if(!firstInit && jQuerMG(container+'.mortgage-include-taxes-insurance').is(":checked")){
        jQuerMG(container+'.payment-taxes .summary-value').text('+ '+PropertyTaxes+' <?php echo $currency;?>');
        jQuerMG(container+'.payment-insurance .summary-value').text('+ '+HomeInsurance+' <?php echo $currency;?>');
      }

      jQuerMG(container+'.payment-rental .summary-value').text('- '+RentalIncome+' <?php echo $currency;?>');

      jQuerMG(container+'.payment-total .summary-value').text(Summ+" <?php echo $currency;?>");
      jQuerMG(container+'.payment-total .summary-name').text(period);

}

jQuerMG(container+'.mortgage-include-taxes-insurance').attr('checked', false);

calculated(true); //start init


//input focusout
jQuerMG(container).find('.mortgage-price,.mortgage-amortization,.mortgage-interest-percent,.mortgage-maintenance,.mortgage-rental-income,.mortgage-home-insurance,.mortgage-insurance').focusout(function(event) { 


  if(jQuerMG(this).val()>100000000){
    jQuerMG(this).val(100000000);
  }

  if(jQuerMG(this).val()<1){
    jQuerMG(this).val(1);
  }

   if(jQuerMG(container+'.mortgage-price').val() < 1){
      jQuerMG(container+'.mortgage-price').val(1)
  }
  
  if(isNaN(jQuerMG(this).val())){
    jQuerMG(this).val(1);
  }

    calculated(false);

});

//button mounth/biweek
jQuerMG(container+'.payment-option').click(function(event) {
    event.preventDefault()
    jQuerMG(container+'.payment-switch button').removeClass('active');
    jQuerMG(this).addClass('active');
    calculated(false);
});


//calculated button
jQuerMG(container+'.mortgage-refresh-payment').click(function(event) {
    event.preventDefault()
    // calculated()
});


jQuerMG(container+'.mortgage-include-taxes-insurance').click(function(event) {

      calculated(false);
      if(jQuerMG(this).prop("checked")){
        jQuerMG(container+'.forhide').slideDown('400');
      }else{
        jQuerMG(container+'.forhide').slideUp('400');

        jQuerMG(container+'.payment-taxes .summary-value').html('<div class="addtaxes"><?php echo _MOD_CALC_MOR_ADD;?></div>');
        jQuerMG(container+'.payment-insurance .summary-value').html('<div class="addtaxes"><?php echo _MOD_CALC_MOR_ADD;?></div>');

        jQuerMG(container+'.addtaxes').click(function(event) {
            jQuerMG(container+'.mortgage-include-taxes-insurance').prop('checked', 'checked');
            calculated(false);
            
            jQuerMG(container+'.forhide').slideDown('400');
        });
      }

});

jQuerMG(container+'.addtaxes').click(function(event) {
            jQuerMG(container+'.mortgage-include-taxes-insurance').prop('checked', 'checked');
            calculated(false);
            
            jQuerMG(container+'.forhide').slideDown('400');
  });

jQuerMG('.calc-input-group input').keyup(function(event){
    if(event.keyCode==13)
       {
          calculated(false);
       }
   });
  

</script>