<?php 
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

defined('_JEXEC') or die;
$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/jquerOs-ui.min.css");
$doc->addScript(JURI::root() . 'components/com_os_cck/assets/js/jquery.raty.js');

$doc->addScript(JURI::root() . "components/com_os_cck/assets/js/jquerOs-ui.min.js");

$key = 'key='.$os_cck_configuration->get("google_map_key",'');
$doc->addScript('//maps.googleapis.com/maps/api/js?'.$key);
$doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/jquery.cck_timepicker.css");
$doc->addScript(JURI::root() . "components/com_os_cck/assets/js/jquery.cck_timepicker.js");
$doc->addStyleSheet(JUri::root() . "/components/com_os_cck/assets/css/fine-uploader-new.css");
$doc->addScript(JURI::root() . "/components/com_os_cck/assets/js/fine-uploader.js");
JHtml::_('jquery.framework');
$hidden = '';

$gtree = get_group_children_tree_cck();
$access = ($entityInstance->access != '') ? explode(',', $entityInstance->access) : '1';

$robots_option[]  = JHTML::_('select.option','0','Use Global');
$robots_option[]  = JHTML::_('select.option','1','Index, Follow');
$robots_option[]  = JHTML::_('select.option','2','No index, follow');
$robots_option[]  = JHTML::_('select.option','3','Index, No follow');
$robots_option[]  = JHTML::_('select.option','4','No index, no follow');

if (version_compare(JVERSION, "3.7.0", "ge")) {
    $install_lang = JLanguageHelper::getKnownLanguages();
}else{
    $install_lang = JLanguage::getKnownLanguages();
}
    
$lang_list = array();
$instanse_lang_list = array();
$lang_list[] = JHTML::_('select.option','*','All');
foreach($install_lang as $key => $item){
    $lang_list[] = JHTML::_('select.option',$key,$item['name']);
    $lang_instancies = $entityInstance->getInstanciesListLang($key);
    
    if(!empty($lang_instancies)){
        $instanse_lang_list[$key] = array();
        $instanse_lang_list[$key][] = JHTML::_('select.option','',cck_lang_text('COM_OS_CCK_ADMIN_PLEASE_SEL'));
        foreach($lang_instancies as $inst){
            if($inst->title == ''){
                $temp_inst = new os_cckEntityInstance($db->_db);
                $temp_inst->load($inst->eiid);
                $inst->title = getInstanceTitle($temp_inst);
            }
            $instanse_lang_list[$key][] = JHTML::_('select.option',$inst->eiid,$inst->title);
        }
    }
}

if($entityInstance->associate_instances){
    $assoc_list = unserialize($entityInstance->associate_instances);
}else{
    $assoc_list = array();
}


if(!$entityInstance->language){
    $lang_select = $layout->language;
}else{
    $lang_select = $entityInstance->language;
}
$lang_list = JHTML::_('select.genericlist',$lang_list, 'language', 'size="1" class="inputbox"', 'value', 'text', $lang_select);


?>
<script>
    var checkExpr = [];
</script>
<?php

$table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php?option=com_os_cck&task=show_instance', 'show_instance');
$table->create_button('Save & Close', 'save_instance', '', 'fa-save', '', false);
$table->create_button('Apply', 'apply_instance', '', 'fa-save', '', false);
$table->create_button('Cancel', 'cancel_instance', '', 'fa-close', '', false);

?>
<!-- tabs -->
<?php
    $layout_html = '';
    ob_start();
    $layout->getEditInstanceLayoutViews($layout, $layout_params, $entityInstance, $option, $robots_option, 'adminForm','', $lang_list, $instanse_lang_list, $assoc_list);
    $layout_html = ob_get_contents();
    ob_clean();
  
  $table->set_custom_html($layout_html);
  echo $table->viewTable();
  if(false){
?>
<form action="index.php?option=com_os_cck&task=show_instance" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
  <?php
    $options = Array('active'    => 'panel_1_id');
    
    echo JHtml::_('bootstrap.startTabSet', 'instance-tab', $options);
    //echo JHtml::_('tabs.start', 'instance-tab', $options);
    //echo JHtml::_('tabs.panel', cck_lang_text('COM_OS_CCK_ADMIN_INSTANCE_MAIN'), 'panel_1_id');
    echo JHtml::_('bootstrap.addTab', 'instance-tab', 'panel_1_id', cck_lang_text('COM_OS_CCK_ADMIN_INSTANCE_MAIN'));
  ?>
    <div class="edit_instance cck-body">
      <div class="row content-row">
        <span>
        <strong><?php echo cck_lang_text('COM_OS_CCK_LABLE_SELECT_TYPE') ?>:</strong></span>
        <span align="left">
          <?php echo $layout_params['layout_type']; ?>
        </span>
      </div>


  <?php
  $layout_html = urldecode($layout->layout_html);
  $layout_html = str_replace('data-label-styling', 'style',  $layout_html);
  $layout_params['custom_fields'] = unserialize($layout->custom_fields);
  $field_from_params = $layout_params["fields"];
  $fields_list = $layout_params['extra_fields_list'];
  $layout_type = $layout->type;
  $child_entities = (isset($layout_params['child_entities'])) ? $layout_params['child_entities'] : '';
  //var_dump($layout);
  //add child selects to layout
  $addChildSelectToLayout = addChildSelectToLayout($fields_list, $entityInstance, $layout_params, $layout_html, $layout);
  $layout_html = $addChildSelectToLayout['layout_html'];
  $layout_params = $addChildSelectToLayout['layout_params'];
  $parent = $addChildSelectToLayout['select_parent'];
  $layout->params = serialize($layout_params);
  //add child selects to layout
// var_dump($entityInstance);

  require getSiteUniqueFiledViewPath('com_os_cck', 'custom_code');
  // $layout_html = replace_custom_code_field($layout_html, $layout, $layout_params);
  //start render custom code
    // if(count($layout_params['custom_fields'])){
    //   foreach ($layout_params['custom_fields'] as $cust_key => $custom_field) {
    //     if(strpos($layout_html,"{|f-custom_code_field_".$cust_key."|}")){
    //       //check access
    //       if(isset($custom_field['custom_code_field_'.$cust_key.'_access'])
    //           && $custom_field['custom_code_field_'.$cust_key.'_access'] != '1'){
    //         $user = JFactory::getUser();
    //         if(!checkAccess_cck($custom_field['custom_code_field_'.$cust_key.'_access'], $user->groups, $entityInstance->fk_eid, 'fields')){
    //           $layout_html = str_replace("{|f-custom_code_field_".$cust_key."|}", '', $layout_html);
    //           continue;
    //         }
    //       }
    //       // $dispatcher = JDispatcher::getInstance();
    //       // JPluginHelper::importPlugin('content');
    //       // $plug_row = new stdClass();
    //       // $plug_row->text = $custom_field['custom_code_field_'.$cust_key.'_custom_code'];
    //       // $dispatcher->trigger('onContentPrepare', array('com_os_cck', &$plug_row, &$plug_params, 0));
    //       // $custom_field['custom_code_field_'.$cust_key.'_custom_code'] = $plug_row->text;
    //       //if below fn works , that this is add_instance view
    //       $code_type = $custom_field['custom_code_field_'.$cust_key.'_custom_code_type'];
    //       if($code_type == 'SCRIPT'){
    //         $custom_code = '<script type="text/javascript">';
    //         $custom_code .= $custom_field['custom_code_field_'.$cust_key.'_custom_code'];
    //         $custom_code .= '</script>';
    //         $layout_html = str_replace("{|f-custom_code_field_".$cust_key."|}", $custom_code, $layout_html);
    //       }elseif($code_type == 'PHP'){
    //         ob_start();
    //         $custom_code = eval($custom_field['custom_code_field_'.$cust_key.'_custom_code']);
    //         $layout_html = str_replace("{|f-custom_code_field_".$cust_key."|}", ob_get_contents(), $layout_html);
    //         ob_end_clean();
    //       }elseif($code_type == 'CSS'){
    //         $custom_css = '<style>'.$custom_field['custom_code_field_'.$cust_key.'_custom_code'].'</style>';
    //         $layout_html = str_replace("{|f-custom_code_field_".$cust_key."|}", $custom_css, $layout_html);
    //       }else{

    //         $custom_code = $custom_field['custom_code_field_'.$cust_key.'_custom_code'];
    //         $layout_html = str_replace("{|f-custom_code_field_".$cust_key."|}", $custom_code, $layout_html);
    //       }
    //     }
    //   }
    // }
    //end render custom code

  foreach ($fields_list as $i => $f){
//  for ($i = 0; $i < count($fields_list); $i++){

    $html = '';
    $value = '';
    $field = $fields_list[$i];
    
    

    $field_styling = get_field_styles($field, $layout);
    $custom_class = get_field_custom_class($field, $layout);
    $layout_params['field_styling'] = $field_styling;
    $layout_params['custom_class'] = $custom_class;

    

    //delete inappropriate short cods
    if(strpos($layout_html,"{|f-cck_mail|}")){
      $layout_html = str_replace("{|f-cck_mail|}",'', $layout_html);
    }
    if(strpos($layout_html,"{|f-cck_send_button|}")){
      $layout_html = str_replace("{|f-cck_send_button|}",'', $layout_html);
    }
    if(isset($layout_params['action_button_fields']) && count($layout_params['action_button_fields'])){
      foreach($layout_params['action_button_fields'] as $act_butt_key => $act_butt_val){
        if(strpos($layout_html,"{|f-cck_action_button_$act_butt_key|}")){
          $layout_html = str_replace("{|f-cck_action_button_$act_butt_key|}",'', $layout_html);
        }
      }
      // var_dump($layout_params['action_button_fields']);
    }
    
    if($field->field_type == "captcha_field"){
      $layout_html = str_replace("{|f-".$field->fid."|}",'', $layout_html);
      continue;
    }
    //delete inappropriate short cods


    if(strpos($layout_html,"{|f-".$field->fid."|}")){
      $php_if = isset($layout_params['fields'][$field->db_field_name.'_php_show']) ? $layout_params['fields'][$field->db_field_name.'_php_show'] : '';
       $php_result = true;

       if($php_if != ''){
            $php_result = processing_php_show($php_if, $entityInstance, $layout_params, $layout_html, $layout);
       }

      if($php_result){
      //get field value
          $value = $entityInstance->getFieldValue($field);

          //get field value for checkbox
          if($field->field_type == 'text_single_checkbox_onoff'){
              $checkbox_value = $entityInstance->getFieldValue($field);
              
              $checkbox_value = isset($checkbox_value[0]->data) ? $checkbox_value[0]->data : '';

          }

          //get field value if this rating field
          if($field->field_type == 'rating_field' 
            && isset($layout_params['fields'][$field->db_field_name.'_average'])
            && $layout_params['fields'][$field->db_field_name.'_average'] == 'on'){

            $value = get_average_rating($field, $layout, $entityInstance);
          }
          //get field value if this rating field

          //publish\unpublish check
          if((!isset($field_from_params[$field->db_field_name.'_published']) 
              || $field_from_params[$field->db_field_name.'_published'] != 'on')){
            $layout_html = str_replace("{|f-".$field->fid."|}", '', $layout_html);
            continue;
          }
          //publish\unpublish check

          //check access
            if(isset($field_from_params['access_'.$field->db_field_name])
                && $field_from_params['access_'.$field->db_field_name] != '1'){
              $user = JFactory::getUser();
              if(!checkAccess_cck($field_from_params['access_'.$field->db_field_name], $user->groups, $entityInstance->fk_eid, 'fields')){
                $layout_html = str_replace("{|f-".$field->fid."|}", $html, $layout_html);
                continue;
              }
            }
          //check access

          //regular expression
          if(isset($field_from_params[$field->db_field_name.'_check_expression'])){
              $checkExpr = ($field_from_params[$field->db_field_name.'_check_expression'] != 'custom') ? $field_from_params[$field->db_field_name.'_check_expression'] : $field_from_params[$field->db_field_name.'_check_expression_custom'];
            ?>
            <script>
              checkExpr[checkExpr.length] = ["<?php echo $field->db_field_name;?>",
                                             encodeURI(<?php echo $checkExpr?>),
                                             "<?php echo $field_from_params[$field->db_field_name.'_error_text'];?>"];
            </script>
            <?php
          }
          //regular expression

          //add prefix_
          if(!empty($field_from_params[$field->db_field_name.'_prefix'])){
            $html .= '<span class="'.$field->db_field_name.'_prefix'.'">'.$field_from_params[$field->db_field_name.'_prefix'].'</span>';
          }
          //add prefix_

          if($field->field_type == 'categoryfield'){
            $cats = $value;
            $value = array();
            if(is_array($cats)){
              foreach ($cats as $id){
                if(isset($id->catid)){
                  $value[] = $id->catid;
                }
              }
            }  
          }else if($field->field_type == 'locationfield'){
            $value = isset($value[0]) ? $value = $value[0] : '';
          }elseif($field->field_type == 'pricefield_number'){
              $value = (isset($value[0])) ? $value[0] : '';
          }elseif($field->field_type == 'pricefield_select_list' || $field->field_type == 'pricefield_radio_buttons'){
              
          }else{
            $value = (isset($value[0]->data)) ? $value[0]->data : '';
          }
          //check from search or not
//var_dump($value);
          $fromSearch = 0;
          $field_from_params['ceid'] = $layout->fk_eid;
          $field_from_params['lay_type'] = $layout_type;
          $field_from_params['field_styling']= $field_styling;
          $field_from_params['custom_class']= $custom_class;
          $field_from_params['form_id'] = "adminForm";
          $offset_animation = get_field_offset_animation($field, $layout);
          //attach field
          ob_start();
            require getSiteAddFiledViewPath('com_os_cck', $field->field_type);
          $html .= ob_get_contents();
          ob_end_clean();
          //attach field

          //add _suffix  
          if(!empty($field_from_params[$field->db_field_name.'_suffix'])){
            $html.= '<span class="'.$field->db_field_name.'_suffix'.'">'.$field_from_params[$field->db_field_name.'_suffix'].'</span>';
          }

          //add _suffix
      }
      //add field to layout / replace shortcode
      $layout_html = str_replace("{|f-".$field->fid."|}", $html, $layout_html);
    }
    
  }
  // var_dump($child_entities);
  if(is_array($child_entities) && count($child_entities) > 0){
      
      foreach($child_entities as $child_entity){
          
          $child_enteties_html = '';
          if(strpos($layout_html,"{|".$child_entity->data_field_name."|}")){
              $php_if = isset($layout_params['fields'][$child_entity->data_field_name.'_php_show']) ? $layout_params['fields'][$child_entity->data_field_name.'_php_show'] : '';
               $php_result = true;

               if($php_if != ''){
                    $php_result = processing_php_show($php_if, $entityInstance, $layout_params, $layout_html, $layout);
               }
               if(!$php_result){
                   $layout_html = str_replace("{|".$child_entity->data_field_name."|}", '', $layout_html);
                    continue;
               }

              //publish\unpublish check


              if((!isset($field_from_params[$child_entity->data_field_name.'_published']) 
                  || $field_from_params[$child_entity->data_field_name.'_published'] != 'on')){
                $layout_html = str_replace("{|".$child_entity->data_field_name."|}", '', $layout_html);
                continue;
              }

              //publish\unpublish check

              //check access
                if(isset($field_from_params['access_'.$child_entity->data_field_name])
                    && $field_from_params['access_'.$child_entity->data_field_name] != '1'){
                  $user = JFactory::getUser();
                  if(!checkAccess_cck($field_from_params['access_'.$child_entity->data_field_name], $user->groups, $child_entity->childEntityId, 'fields')){
                    $layout_html = str_replace("{|".$child_entity->data_field_name."|}", $child_enteties_html, $layout_html);
                    continue;
                  }
                }
              //check access
                
                if(!empty($field_from_params[$child_entity->data_field_name.'_prefix'])){
                    $child_enteties_html .= '<span class="'.$child_entity->data_field_name.'_prefix'.'">'.$field_from_params[$child_entity->data_field_name . '_prefix'].'</span>';
                  }
              ob_start();
                require getSiteAddFiledViewPath('com_os_cck', 'child_select');
              $child_enteties_html .= ob_get_contents();
              ob_end_clean();

              //add _suffix  
              if(!empty($field_from_params[$child_entity->data_field_name.'_suffix'])){
                $child_enteties_html.= '<span class="'.$child_entity->data_field_name.'_suffix'.'">'.$field_from_params[$child_entity->data_field_name.'_suffix'].'</span>';
              }
              
              $layout_html = str_replace("{|".$child_entity->data_field_name."|}", $child_enteties_html, $layout_html);
              //var_dump($child_entity);
          }
          
      }
  }
 
    //render layout    
//    echo $layout_html;
    
    
    
    
    //var_dump($new_class);
  ?>


    <input type="hidden" name="id" value="<?php echo $entityInstance->eiid; ?>"/>
    <input type="hidden" name="option" value="<?php echo $option; ?>"/>
    <input type="hidden" name="boxchecked" value="0"/>
    <?php if($entityInstance->eiid && trim($entityInstance->eiid) != ''):?>
      <input id="inst_id" type="hidden" name="eiid[]" value="<?php echo $entityInstance->eiid;?>"/>
    <?php endif;?>
    <input id="inst_task" type="hidden" name="task" value="apply_instance"/>
  </div>

  <script type="text/javascript">
      window.addEventListener('load', function() {
        jQuerOs("*[class*='hide-field-name-'] , .delete-field, .delete-row, .delete-layout").remove();
        jQuerOs("div[class *='cck-row-'], div[id *='cck_col-']").each(function(index, el) {
          jQuerOs(el).attr("style",jQuerOs(el).data("block-styling"));
        });
      })
  </script>

  <?php
  echo JHtml::_('bootstrap.endTab');
  echo JHtml::_('bootstrap.addTab', 'instance-tab', 'panel_2_id', cck_lang_text('COM_OS_CCK_ADMIN_INSTANCE_SETTINGS'));
  //echo JHtml::_('tabs.panel', cck_lang_text('COM_OS_CCK_ADMIN_INSTANCE_SETTINGS'), 'panel_2_id');
  ?>

  <div class="instance-settings-block">
    <div class="settings-block">
      <div class="settings-header">
        <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_ADVERTISMENT')?>:</label>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_FEATURED_CLICKS')?>:</span>
        <span class="col-2">
          <input type="number" name="featured_clicks" value="<?php echo ($entityInstance->featured_clicks <= -1)?'':$entityInstance->featured_clicks?>" min="0" step="1" max="2147483647">
        </span>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_FEATURED_SHOWS')?>:</span>
        <span class="col-2">
          <input type="number" name="featured_shows" value="<?php echo ($entityInstance->featured_shows <= -1)?'':$entityInstance->featured_shows?>" min="0" step="1" max="2147483647">
        </span>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_FEATURED_OWNER_ID')?>:</span>
        <span class="col-2">
            <?php 
            $get_user_modal = new os_cckFieldUser();
            $owner_id = (!$entityInstance->fk_userid) ? JFactory::getUser()->id : $entityInstance->fk_userid;
            if(!checkingUser($owner_id)) $owner_id = JFactory::getUser()->id;
            echo $get_user_modal->getHtmlInput($owner_id); ?>
        </span>
      </div>
        
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_TITLE')?>:</span>
        <span class="col-2">
          <input type="text" name="meta_title" value="<?php echo $entityInstance->meta_title; ?>" maxlength="250">
        </span>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_DESCRIPTION')?>:</span>
        <span class="col-2">
          <textarea name="meta_description"><?php echo $entityInstance->meta_description; ?></textarea>
        </span>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_KEYWORDS')?>:</span>
        <span class="col-2">
          <textarea name="meta_keywords"><?php echo $entityInstance->meta_keywords; ?></textarea>
        </span>
      </div>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_ROBOTS')?>:</span>
        <span class="col-2">
          <?php echo JHTML::_('select.genericlist', $robots_option, 'meta_robots', '','value', 'text',$entityInstance->meta_robots)?>
        </span>
      </div>
      <?php if(JLanguageMultilang::isEnabled()){ ?>
      <div class="settings-content">
        <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_LANGUAGE')?>:</span>
        <span class="col-2">
            <?php echo $lang_list; ?>
        </span>
      </div>
        <?php

        foreach ($instanse_lang_list as $key => $list){ ?>
            <div class="settings-content <?php echo $key; ?> assoc_instancce">
                <span class="col-1"><?php echo cck_lang_text('COM_OS_CCK_LABEL_ASSOCIATED_INSTANCE') . ' ' . $key; ?>:</span>
                <span class="col-2">
                    <?php  echo JHTML::_('select.genericlist',$list, 'instanse_assoc_'.$key, 'size="1" class="inputbox"', 'value', 'text', (isset($assoc_list[$key])) ? $assoc_list[$key] : '');?>
                </span>
            </div>
        <?php } 
      }else{ ?>
          <input type="hidden" name="language" value="*">
      <?php }?>
        
        <?php if($cck_entity_configuration[$entityInstance->fk_eid]['check_access_instances'] == '1') { 
            $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
            ?>
          <div class="settings-content">
            <span class="col-1"><?php echo cck_lang_text("COM_OS_CCK_LABEL_FIELD_ACCESS")?></span>
            <span class="col-2">
              <?php //echo JHTML::_('select.genericlist', $gtree, 'access[]', 'multiple="true"','value', 'text',$access)
            echo JHTML::_('select.groupedlist',$gtree,'access[]', $attr);?>
            </span>
          </div>
        <?php } ?>
        
        

    </div>  
  </div>

  <?php
    echo JHtml::_('bootstrap.endTab');
    echo JHtml::_('bootstrap.endTabSet');
    //echo JHtml::_('tabs.end');
  ?>
</form>
<?php
  }
  ?>
<script language="javascript" type="text/javascript">
  window.addEventListener('load', function() {
      jQuerOs(document).ready(function() {
        jQuerOs("[make='disabled']").attr('disabled','disabled');
        jQuerOs(['id^=cck_col']).removeClass('resizable');
        jQuerOs('.ui-resizable-handle').remove();
      });

      function findPosY(obj) {
        var curtop = 0;
        if (obj.offsetParent) {
          while (1) {
            curtop+=obj.offsetTop;
            if (!obj.offsetParent) {
              break;
            }
            obj=obj.offsetParent;
          }
        } else if (obj.y) {
          curtop+=obj.y;
        }
        return curtop-20;
      }

      function trim(string) {
        return string.replace(/(^\s+)|(\s+$)/g, "");
      }

      function add_new_files(show_new_file, hide_button) {
        document.getElementById(show_new_file).style.display = '';
        document.getElementById(hide_button).style.display = 'none';
      }

      

      Joomla.submitbutton = function submitForm (task){
        jQuerOs('textarea[id*=fi_text_textarea_].joomla-editor-tinymce').each(function(index, el) {
          if(jQuerOs(el).css('display') != 'none'){
            jQuerOs(el).parent().find('.js-tiny-toggler-button').trigger('click')    
          }
          
        })
        
        // return
        // jQuerOs('.js-tiny-toggler-button').trigger('click')
        // console.log('44444444444444444', jQuerOs('.js-tiny-toggler-button')); return;
        var add = document.getElementById("categories");
        var form = document.adminForm;
        var required_fields = form.getElementsByClassName("required");

        var post_max_size = <?php echo return_bytes(ini_get('post_max_size')) ?>;
        var upl_max_fsize = <?php echo return_bytes(ini_get('upload_max_filesize')) ?>;
        var file_upl = <?php echo ini_get('file_uploads') ?>;
        var total_file_size = 0;

        if(task == 'cancel_instance'){
          swich_task(task);
          form.submit();
          return;
        }
        
        if(typeof sceditor != 'undefined'){
          for(var i=0; i < text_area_arr.length; i++){
            var editor = window[text_area_arr[i]]
            var value = editor.instance(textarea).val()

            var textarea_field = jQuerOs('[name=fi_'+text_area_arr[i]+']')
            if(textarea_field.length >0){
              jQuerOs(textarea_field[0]).val(value)
            }

            
          }

        }
        

        for (i = 1;document.getElementById('new_upload_video'+i); i++){
          if(document.getElementById('new_upload_video'+i).files.length){
            total_file_size += document.getElementById('new_upload_video'+i).files[0].size;
            if(document.getElementById('new_upload_video'+i).value != ''){
              if(!file_upl){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_UPLOAD_OFF'); ?>";
                document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                document.getElementById('error_video').style.color = "#FF0000";
                return;
              }
              if(document.getElementById('new_upload_video'+i).files[0].size >= post_max_size){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_POST_MAX_SIZE'); ?>";
                document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                document.getElementById('error_video').style.color = "#FF0000";
                return;
              }
              if(document.getElementById('new_upload_video'+i).files[0].size >= upl_max_fsize){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_video'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_UPLOAD_MAX_SIZE'); ?>";
                document.getElementById('new_upload_video'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_video'+i).style.color = "#FF0000";
                document.getElementById('error_video').style.color = "#FF0000";
                return;
              }
            }
          }
        }

        for (i = 1;document.getElementById('new_upload_audio'+i); i++){
          if(document.getElementById('new_upload_audio'+i).files.length){
            if(document.getElementById('new_upload_audio'+i).value != ''){
              total_file_size += document.getElementById('new_upload_audio'+i).files[0].size;
              if(!file_upl){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_audio'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_UPLOAD_OFF'); ?>";
                document.getElementById('new_upload_audio'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_audio'+i).style.color = "#FF0000";
                document.getElementById('error_audio').style.color = "#FF0000";
                return;
              }
              if(document.getElementById('new_upload_audio'+i).files[0].size >= post_max_size){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_audio'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_POST_MAX_SIZE'); ?>";
                document.getElementById('new_upload_audio'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_audio'+i).style.color = "#FF0000";
                document.getElementById('error_audio').style.color = "#FF0000";
                return;
              }
              if(document.getElementById('new_upload_audio'+i).files[0].size >= upl_max_fsize){
                window.scrollTo(0,findPosY(document.getElementById('new_upload_audio'+i))-100);
                document.getElementById('error_video').innerHTML = "<?php
                 echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_UPLOAD_MAX_SIZE'); ?>";
                document.getElementById('new_upload_audio'+i).style.borderColor = "#FF0000";
                document.getElementById('new_upload_audio'+i).style.color = "#FF0000";
                document.getElementById('error_audio').style.color = "#FF0000";
                return;
              }
            }
          }
        }

        if(total_file_size >= post_max_size){
          if(document.getElementById('error_video')){
            window.scrollTo(0,findPosY(document.getElementById('error_video'))-100);
            document.getElementById('error_video').innerHTML = "<?php
             echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_POST_MAX_SIZE'); ?>";
            document.getElementById('error_video').style.borderColor = "#FF0000";
            document.getElementById('error_video').style.color = "#FF0000";
            document.getElementById('error_video').style.color = "#FF0000";
            return;
          }
          if(document.getElementById('error_audio')){
            window.scrollTo(0,findPosY(document.getElementById('error_audio'))-100);
            document.getElementById('error_audio').innerHTML = "<?php
             echo cck_lang_text('COM_OS_CCK_SETTINGS_VIDEO_ERROR_POST_MAX_SIZE'); ?>";
            document.getElementById('error_audio').style.borderColor = "#FF0000";
            document.getElementById('error_audio').style.color = "#FF0000";
            document.getElementById('error_audio').style.color = "#FF0000";
            return;
          }
        }

        if(form.new_upload_track_url1){
          for (i = 1;document.getElementById('new_upload_track_url'+i); i++) {
            if(document.getElementById('new_upload_track'+i).value != '' 
              || document.getElementById('new_upload_track_url'+i).value != ''){
                if(document.getElementById('new_upload_track_kind'+i).value == ''){
                  window.scrollTo(0,findPosY(document.getElementById('new_upload_track_kind'+i))-100);
                  document.getElementById('new_upload_track_kind'+i).placeholder = "<?php
                   echo cck_lang_text('COM_OS_CCK_ADMIN_INFOTEXT_JS_TRACK_KIND'); ?>";
                  document.getElementById('new_upload_track_kind'+i).style.borderColor = "#FF0000";
                  document.getElementById('new_upload_track_kind'+i).style.color = "#FF0000";
                  return;
                }else if(document.getElementById('new_upload_track_scrlang'+i).value == ''){
                  window.scrollTo(0,findPosY(document.getElementById('new_upload_track_scrlang'+i))-100);
                  document.getElementById('new_upload_track_scrlang'+i).placeholder = "<?php
                   echo cck_lang_text('COM_OS_CCK_ADMIN_INFOTEXT_JS_TRACK_LANGUAGE'); ?>";
                  document.getElementById('new_upload_track_scrlang'+i).style.borderColor = "#FF0000";
                  document.getElementById('new_upload_track_scrlang'+i).style.color = "#FF0000";
                  return;
                }else if(document.getElementById('new_upload_track_label'+i).value == ''){
                  window.scrollTo(0,findPosY(document.getElementById('new_upload_track_label'+i))-100);
                  document.getElementById('new_upload_track_label'+i).placeholder = "<?php
                   echo cck_lang_text('COM_OS_CCK_ADMIN_INFOTEXT_JS_TRACK_TITLE'); ?>";
                  document.getElementById('new_upload_track_label'+i).style.borderColor = "#FF0000";
                  document.getElementById('new_upload_track_label'+i).style.color = "#FF0000";
                  return;
                }
            }
          }
        }

        ret = false;

        checkRequireFields(required_fields);

        if(jQuerOs("[name*='fi_decimal_textfield_']").length){
          jQuerOs("[name*='fi_decimal_textfield_']").each(function(index, el) {
            if(jQuerOs(this).val()){
              step = jQuerOs(this).attr("step");

              if(step.indexOf(".") >= 0){
                point = step.length - 1 - step.indexOf(".");
                //numb = step.length-1-point;
                numb = jQuerOs(this).attr("max").length;
              }else{
                numb = jQuerOs(this).attr("max");
                point = 0;
              }

              if(step.indexOf(".") >= 0){
                vallen = jQuerOs(this).val().length;

                if(numb < vallen-1-jQuerOs(this).val().indexOf(".")){
                  window.scrollTo(0,findPosY(el)-100);
                  jQuerOs(el).css("borderColor", "#FF0000");
                  jQuerOs(el).css("color", "#FF0000");
                  alert("Format: "+step);
                  ret = true;
                  return false;
                }

                if(jQuerOs(this).val().indexOf(".") >= 0){
                    var new_point = jQuerOs(this).val().indexOf(".");
                }else{
                    var new_point = 1;
                }

                if(point < vallen - 1 - new_point || jQuerOs(this).val().indexOf(".") == -1){
                  window.scrollTo(0,findPosY(el)-100);
                  jQuerOs(el).css("borderColor", "#FF0000");
                  jQuerOs(el).css("color", "#FF0000");
                  alert("Format: "+step);
                  ret = true;
                  return false;
                }
              }else{
                if(numb < parseInt(jQuerOs(this).val())){
                  window.scrollTo(0,findPosY(el)-100);
                  jQuerOs(el).css("borderColor", "#FF0000");
                  jQuerOs(el).css("color", "#FF0000");
                  alert("Max: "+numb);
                  ret = true;
                  return false;
                }
              }
            }
          });
        }

        if(ret){
          return;
        }

        var error = false;
          //check for regular exp // set array of field=>exp in fields above(checkExpr)
        jQuerOs(checkExpr).each(function(index, el) {
            if(typeof el == "object"){
              regEx = eval(decodeURI(el[1]));
              if(regEx){
                str = jQuerOs("[name='fi_"+el[0]+"']").val();
                if(!regEx.test(str)){
                  if(el[2]){
                    errorText = el[2];
                  }else{
                    errorText = '';
                  }
                  window.scrollTo(0,findPosY(jQuerOs("[name='fi_"+el[0]+"']"))-100);
                  jQuerOs("[name='fi_"+el[0]+"']").attr("placeholder", errorText);
                  jQuerOs("[name='fi_"+el[0]+"']").css("borderColor", "#FF0000");
                  jQuerOs("[name='fi_"+el[0]+"']").css("color","#FF0000");
                  error = true;
                };
              }
            }
          });
          if(error){return;}
          swich_task(task);
          form.submit();
        }
        
        showHideAssocInstance();
        jQuerOs('#language').on('change', showHideAssocInstance);
    })
    
    function swich_task(task){
        if(task == 'save_instance' || task == 'send_request'){
          document.getElementById('inst_task').value = 'save_instance';
        }
        if(task == 'edit_instance'){
          document.getElementById('inst_task').value = 'edit_instance';
        }
        if(task == 'cancel_instance'){
          document.getElementById('inst_task').value = 'cancel_instance';
        }
      }
      
      function lay_type_select() {
        document.forms["adminForm"].submit();;
        return;
      }
      
      function showHideAssocInstance(){
        var val = jQuerOs('#language').val();
        if(val == '*'){
            jQuerOs('.assoc_instancce').hide();
        }else{
            jQuerOs('.assoc_instancce').each(function (index, value){
                if(jQuerOs(value).hasClass(val)){
                    jQuerOs(value).hide();
                }else{
                    jQuerOs(value).show();
                }
                
            })

        }

      jQuerOs('input[name=featured_clicks], input[name=featured_shows]').on('input',function(){
        var value = jQuerOs(this).val()
        if(value > 2147483647){
          jQuerOs(this).val(2147483647)
        }
        
      })
    }
    

</script>
<!--************************   end change review ***********************-->
