<?php
/**
* @version 8.2
* @package OS CCK
* @copyright 2025 OrdaSoft
* @author 2025 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev(akoevroman@gmail.com)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later; 
*/

defined('_JEXEC') or die;

jimport( 'joomla.plugin.plugin' );

class plgSystemCck_system extends \Joomla\CMS\Plugin\CMSPlugin{
  protected static $modules = array();

  protected static $mods = array();
  
/**
* Constructor.
* @access protected
* @param object $subject The object to observe
* @param array   $config  An array that holds the plugin configuration
* @since 1.0
*/

  public function __construct( &$subject, $config ){
    parent::__construct( $subject, $config );

    if(!class_exists('JFactory')){
        $this->old_classes_declarated();
    }
  }
  
  function onBeforeCompileHead(){
    global $bootstrap;
    
    $doc = JFactory::getDocument();
    $session = JFactory::getSession();
    $app = JFactory::getApplication();
    $input = $app->input;
    $matches  = preg_grep ('/bootstrap.css/i', array_keys($doc->_styleSheets));
    if(!$matches){
      $matches  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap/i', array_keys($doc->_styleSheets));
    }
    $plugin = JPluginHelper::getPlugin('system', 'cck_system');
    $params = new JRegistry;
    $params->loadString($plugin->params);
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
    if ($check) {
//      switch($params->get('bootstrap_version','0')){
//        case "1":
//          //dont include bootstrap
//        break;
//        case "2":
//          //include bootstrap 2
//          $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap2.css");
//          $session->set('bootstrap', '2');
//        break;
//        case "3":
//          //include bootstrap 3
//          $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//          $session->set('bootstrap', '3');
//        break;
//        default:
//          //try detect version of bootstrap
//          if(isset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js'])){
//            $file = file_get_contents(JPATH_BASE.'/media/jui/js/bootstrap.min.js');
//            $match  = preg_match_all ('/Custom version for Joomla!/i', $file);
//            if($match){
//              $session->set('bootstrap', '2');
//            }else{
//              $session->set('bootstrap', '3');
//              $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//            }
//          }else if(count($matches)){
//            foreach ($matches as $value) {
//              //need test if we have bootstrap
//              $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/2/i', $value);
//              if($match){
//                $session->set('bootstrap', '2');
//              }else{
//                $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/3/i', $value);
//                if($match){
//                  $session->set('bootstrap', '3');
//                }
//              }
//            }
//          }else{
//            $session->set('bootstrap', '3');
//            $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//          }
//      }
    }

    //backend
    if($input->get('option','') == 'com_os_cck' && ($input->get('task','') == 'edit_layout' 
      || ($input->get('task','') == 'new_layout' && $input->get('layout_type','')))){
      $doc = JFactory::getDocument();
//      var_dump($doc->_scripts); exit;
      // Remove default bootstrap
      
      unset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js']);
      foreach ($doc->_styleSheets as $key => $value) {
        if(substr_count($key,'templates')){
          unset($doc->_styleSheets [$key]);
        }
      }
      
      $doc->addScript(JURI::root() . "/components/com_os_cck/assets/bootstrap/js/bootstrapCCK.js");
      $doc->addScript(JURI::root() . "/components/com_os_cck/assets/js/jquery.minicolors.js");
      $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
      $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/css/jquery.minicolors.css");
      //style for codemirror

      $doc->addScript(JURI::root() . "/media/system/js/html5fallback.js");
      JHtml::_('behavior.formvalidator');
      JHtml::_('behavior.keepalive');
      //JHtml::_('behavior.modal');
      // $doc->addScript("https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.6.7/jquery.tinymce.min.js");
      //end
      foreach ($doc->_scripts as $script => $type) {
        if(strpos($script, 'isis/js/template.js')){
          unset($doc->_scripts[$script]);
        }
        if(strpos($script, 'html5fallback.js')){
          unset($doc->_scripts[$script]);
        }
      }
    }
  }

  public function onContentPrepare($context, &$article, &$params){
    $app = JFactory::getApplication();
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site')){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite()){
        $check = true;
      }else{
        $check = false;
      }
    }
    if($check ){
      require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
    }
    $cck_option = 'com_os_cck';
    $db = JFactory::getDBO();
    if(isset($article->introtext)){
      $article_content = $article->introtext;
      $language = JFactory::getLanguage();
      $language->load('com_os_cck');
      //get mask
      preg_match_all('[{CCKLayout\|[a-z]-[0-9]{1,}\|}|'.
              '{CCKLayout\|[a-z]-[0-9]{1,}:CCK[a-zA-Z]{1,10}\|[a-z]-[0-9]{1,}\|}]',$article_content,$matches);
      
      //var_dump($matches);
      if(isset($matches[0])){
        foreach ($matches[0] as $key => $match) {
          $eiid = '';
          $lid = '';
          $cat_id = '';
          if(strpos($match, '{CCKLayout|') == 0){
            //if instance or category layout
            if(strpos($match, ':')){
              $match = explode(':', $match);
              $lid = str_replace("{CCKLayout|l-", '', $match[0]);
              if(strpos($match[1], 'CCKInstance|i-') === 0){
                $eiid = str_replace("CCKInstance|i-", '', $match[1]);
                $eiid = str_replace("|}", '', $eiid);
              }else{
                $cat_id = str_replace("CCKCategory|c-", '', $match[1]);
                $cat_id = str_replace("|}", '', $cat_id);
              }
            }else{
              //others layout
              $lid = str_replace("{CCKLayout|l-", '', $match);
              $lid = str_replace("|}", '', $lid);
            }
          }
          
          //replase content
          if($lid && $eiid){
            //  var_dump(stripos($article_content, "{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}"));
            //instance layout
            ob_start();
            Instance::showItem($cck_option,$eiid, 0, $lid);
            //var_dump($article_content);
            $article_content = str_replace("{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}", ob_get_contents(), $article_content);
            //echo $article_content;exit;
            ob_end_clean();
            
          }else if($lid && $cat_id){
            //category layout
            ob_start();
            Category::showCategory($cck_option,$cat_id,$lid);
            $article_content = str_replace("{CCKLayout|l-".$lid.":CCKCategory|c-".$cat_id."|}", ob_get_contents(), $article_content);
            ob_end_clean();
          }else{
            //other layout
              
            
            ob_start();
            $layout = new os_cckLayout($db);
            $layout->load($lid);
            
            switch($layout->type){
              case "add_instance":
              case "request_instance":
                Instance::editInstance($cck_option, 0, $lid);
//                Instance::show_request_layout($cck_option ,$lid,0);
                break;

              case "all_categories":
                Category::listCategories($cck_option, $lid);
                break;

              case "all_instance":
                Instance::show_all_instance($cck_option,$lid);
                break;

              case "search":
                Category::showSearch($cck_option,0,$lid);
                break;
            }
            $article_content = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $article_content);
            ob_end_clean();
          }

        }
        $article->introtext = $article_content;
      }
      if (version_compare(JVERSION, "4.0.0", "ge")) {
        if ($app->isClient('site')){
          $check = true;
        }else{
          $check = false;
        }
      }else{
        if ($app->isSite()){
          $check = true;
        }else{
          $check = false;
        }
      }
      if($check ){
        require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
      }
  /////copy from plugins/content/loadmodule/loadmodule.php/
      // Expression to search for (positions)
      $regex = '/{loadposition\s(.*?)}/i';
      $style = $this->params->def('style', 'none');

      // Expression to search for(modules)
      $regexmod = '/{loadmodule\s(.*?)}/i';
      $stylemod = $this->params->def('style', 'none');

      // Find all instances of plugin and put in $matches for loadposition
      // $matches[0] is full pattern match, $matches[1] is the position
      preg_match_all($regex, $article->introtext, $matches, PREG_SET_ORDER);

      // No matches, skip this
      
      if ($matches)
      
      {
        foreach ($matches as $match)
        {
          $matcheslist = explode(',', $match[1]);

          // We may not have a module style so fall back to the plugin default.
          if (!array_key_exists(1, $matcheslist))
          {
            $matcheslist[1] = $style;
          }

          $position = trim($matcheslist[0]);
          $style    = trim($matcheslist[1]);

          $output = $this->_load($position, $style);

          // We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
          $article->introtext = preg_replace("|$match[0]|", addcslashes($output, '\\$'), $article->introtext, 1);
          $style = $this->params->def('style', 'none');
        }
      }

      // Find all instances of plugin and put in $matchesmod for loadmodule
      preg_match_all($regexmod, $article->introtext, $matchesmod, PREG_SET_ORDER);
      // If no matches, skip this
      
      if ($matchesmod)
      {
        foreach ($matchesmod as $matchmod)
        {
          $matchesmodlist = explode(',', $matchmod[1]);

          // We may not have a specific module so set to null
          if (!array_key_exists(1, $matchesmodlist))
          {
            $matchesmodlist[1] = null;
          }

          // We may not have a module style so fall back to the plugin default.
          if (!array_key_exists(2, $matchesmodlist))
          {
            $matchesmodlist[2] = $stylemod;
          }

          $module = trim($matchesmodlist[0]);
          $name   = htmlspecialchars_decode(trim($matchesmodlist[1]));
          $stylemod  = trim($matchesmodlist[2]);

          // $match[0] is full pattern match, $match[1] is the module,$match[2] is the title
          $output = $this->_loadmod($module, $name, $stylemod);

          // We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
          $article->introtext = preg_replace("|$matchmod[0]|", addcslashes($output, '\\$'), $article->introtext, 1);
          $stylemod = $this->params->def('style', 'none');
        }
      }

    }
  }

  public function onAfterRender(){
    include_once JPATH_SITE . '/components/com_os_cck/classes/cckDb.class.php';
    $cck_option = 'com_os_cck';
    $doc = JFactory::getDocument();
    $app = JFactory::getApplication();
    $input = $app->input;
    $db = JFactory::getDBO();
    $db = new os_cckDb();
    $html = $app->getBody();
    $format = $input->get('format', '');
    if($format == 'raw' || $format == 'json' || $format == 'xml') return;
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site')){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite()){
        $check = true;
      }else{
        $check = false;
      }
    }
    if($check ){
      require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
    }
    $sitemenu = $app->getMenu();
    $menuitems = $sitemenu->getItems('component', 'com_os_cck');
//    var_dump($menuitems);
    $html = $app->getBody();
//    $html = $app->getBody();
      $pos = strpos($html, '</head>');
      $head = substr($html, 0, $pos);
      
      ini_set('xdebug.var_display_max_depth', -1);
        ini_set('xdebug.var_display_max_children', -1);
        ini_set('xdebug.var_display_max_data', -1);
//        var_dump($head);
      $body = substr($html, $pos);
      if (version_compare(JVERSION, "4.0.0", "ge")) {
          if($input->get('option','') == 'com_os_cck' && ($input->get('task','') == 'edit_layout' 
          || ($input->get('task','') == 'new_layout' && $input->get('layout_type','')))){
              $styless_arr = ['joomla-media-select.min.css', 'template.min.css', 'joomla-alert.min.css', 'fontawesome-free/fontawesome.min.css'];
              foreach($styless_arr as $style){
                  
                  $pos_style = stripos($head, $style);
                  
                  $pos_start = strripos(substr($head, 0, $pos_style), '<link');
                  
                  $pos_end = stripos($head, '/>', $pos_style);
                  if($pos_end === false){
                      $pos_end = stripos($head, '>', $pos_style);
                  }
                  
                  $head = substr_replace($head, '', $pos_start, ($pos_end - $pos_start) + 2);
              }
//              var_dump($head);
              
              
              $app->setBody($head.$body);
          }
          
      }
//      var_dump($head); exit;
    foreach($menuitems as $menu){
      $params = new JRegistry();
      $params->loadString($menu->getParams());
      // var_dump($menu);
        if($menu->query['view'] == 'hover_layout' || $menu->query['view'] == 'popup' || $params->get('show_type', 1) == 4 || $params->get('show_type', 1) == 5){
          
            $language = JFactory::getLanguage();
            $language->load('com_os_cck');
            
           
            $eiid = false;
            $cat_id = false;
            $lid = $params->get('layout', '');
            $layout = new os_cckLayout($db->_db);
            if($lid != ''){
              $layout->load($lid);
            }
            if($params->get('layout_type', '') == 'instance' || $params->get('layout_type', '') == 'parent_child'){
                $eiid = $params->get('instance', '');
            }
            if($params->get('layout_type', '') == 'category'){
                $cat_id = $params->get('instance', '');
            }
            
            $cat_id = $params->get('category');
//            if (version_compare(JVERSION, "4.0.0", "ge")) {
//                $class = 'nav-item item-'.$menu->id . ' ' . $params->get('menu-anchor_css', '');
//            }else{
//                $class = 'item-'.$menu->id . ' ' . $params->get('menu-anchor_css', '');
//            }
            $link_class = $params->get('menu-anchor_css', '');
            if (version_compare(JVERSION, "4.0.0", "ge")) {
                $class = 'nav-item item-'.$menu->id;
            }else{
                $class = 'item-'.$menu->id;
            }
            
//            var_dump($html);
            $pos_start = stripos($html, '<li class="'.$class); 
            
            
            $pos_finish = stripos($html, '</li>', $pos_start) + 5; 
            
            
            $raplaced_text = substr($html, $pos_start, $pos_finish - $pos_start);
            if($menu->level > 1){
              $add_class = ' nav-child ';
              $arrow = "<span class='arrow'></span>";
            }else{
              $add_class = '';
              $arrow = "";
            }
            $hover_center = ($params->get('hover_position', 'left_cck_hover_pos') == 'center_cck_hover_pos') ? 'cck_hover_side' : '';
            $hover_center = 'cck_hover_side';
            if($menu->query['view'] == 'hover_layout' || $params->get('show_type', 1) == 4){
                if($layout->fk_eid){
                  $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
                }
                // $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
                // $new_html = '<li class="item-'.$menu->id.' ' . $hover_center .'"><a href="#">'.$menu->title.$arrow.'</a><ul class="os_cck_menu_child '.$params->get('hover_position', 'left_cck_hover_pos').' '.$add_class.'">';
                $new_html = '<li class="'.$class.' ' . $hover_center .'"><a href="#!" class="'.$link_class.'">'.$menu->title.$arrow.'</a><ul class="os_cck_menu_child '.$params->get('hover_position', 'left_cck_hover_pos').' '.$add_class.'">';
            }
            if($menu->query['view'] == 'popup' || $params->get('show_type', 1) == 5){
              if($layout->fk_eid){
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
                // $head .= '<script src='.JURI::root() .'components/com_os_cck/assets/js/os-cck-modal.js"></script>'."\n";
              }
                $new_html = '<li class="'.$class.'"><a class="'.$link_class.'" href="#" data-toggle="os_cck_modal" data-target="#os_cck_popup_'.$menu->id.'">'.$menu->title.'</a></li>';
                $new_html .= '<div class="fade os_cck_modal" id="os_cck_popup_'.$menu->id.'"  tabindex="-1" role="dialog" aria-hidden="true">'
                                .'<div class="os_cck_modal-dialog os_cck_modal-dialog-scrollable" role="document">'
                                    .'<div class="os_cck_modal-content">'
                                    .'<div class="os_cck_modal-header">'
                                        .'<button type="button" class="close" data-dismiss="os_cck_modal" aria-label="Close">'
                                            .'<span aria-hidden="true">&times;</span>'
                                        .'</button>'
                                    .'</div>'
                                    .'<div class="os_cck_modal-body">';
            }

            
              include_once JPATH_SITE . '/components/com_os_cck/os_cck.php';
              ob_start();
//              $layout = new os_cckLayout($db);
//              $layout->load($lid);
              switch($params->get('layout_type', '')){
                case "instance":
                    Instance::showItem($cck_option,$eiid, 0, $lid, 0, 10, $menu->id);
                    break;
                case "category":
                    Category::showCategory($cck_option,$cat_id,$lid, 0 ,0, false, $menu->id);
                    break;
                case "add_instance":
                    Instance::editInstance($cck_option, 0, $lid);
                    break;
                case "request_instance":
//                  Instance::editInstance($cck_option, 0, $lid);
                  Instance::show_request_layout($cck_option ,$lid,0);
                  break;

                case "all_categories":
                  Category::listCategories($cck_option, $lid, $menu->id);
                  break;

                case "all_instance":
                  Instance::show_all_instance($cck_option,$lid, 0, $menu->id);
                  break;

                case "search":
                  Category::showSearch($cck_option,0,$lid, $menu->id);
                  break;
              
                case "cart":
                  Instance::showCartLayout($cck_option,$lid, 0, 'default', $menu->id);
                  break;
              
                case "calendar":
                  Instance::show_calendar($cck_option,$lid, '', $menu->id);
                  break;
                case "parent_child":
                  Instance::showParentChildLayout($cck_option,$lid, 0, '', $eiid, $menu->id);
                  break;
              case "user_instances":
                  Instance::showUserInstances($cck_option,$lid, 0, '', $params->get('user', ''), $menu->id);
                  break;
              }
//              $body = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $body);
              $new_html .= ob_get_contents();
              ob_end_clean();
              if($menu->query['view'] == 'hover_layout' || $params->get('show_type', 1) == 4){
                $new_html .= '</ul></li>';
              }
              if($menu->query['view'] == 'popup' || $params->get('show_type', 1) == 5){
                  $new_html .= '</div>
                                  
                                </div>
                              </div>
                            </div>';
              }
              
              $body = str_replace($raplaced_text, $new_html, $body);
//              $result = $this->addStyle($head, $body);
            }
            
        }
//    }
//    var_dump($params); exit;
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
//    var_dump($check);
    if ($check && $doc->getType() == 'html') {
      
      if(isset($body)){
        $language = JFactory::getLanguage();
        $language->load('com_os_cck');
        //get mask
        preg_match_all('[{CCKLayout\|[a-z]-[0-9]{1,}\|}|'.
                '{CCKLayout\|[a-z]-[0-9]{1,}:CCK[a-zA-Z]{1,10}\|[a-z]-[0-9]{1,}\|}]',$body,$matches);
        
        if(isset($matches[0]) && !empty($matches[0])){
          require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
          foreach ($matches[0] as $key => $match) {
            $eiid = '';
            $lid = '';
            $cat_id = '';
            if(strpos($match, '{CCKLayout|') == 0){
              //if instance or category layout
              if(strpos($match, ':')){
                $match = explode(':', $match);
                $lid = str_replace("{CCKLayout|l-", '', $match[0]);
                if(strpos($match[1], 'CCKInstance|i-') === 0){
                  $eiid = str_replace("CCKInstance|i-", '', $match[1]);
                  $eiid = str_replace("|}", '', $eiid);
                }else{
                  $cat_id = str_replace("CCKCategory|c-", '', $match[1]);
                  $cat_id = str_replace("|}", '', $cat_id);
                }
              }else{
                //others layout
                $lid = str_replace("{CCKLayout|l-", '', $match);
                $lid = str_replace("|}", '', $lid);
              }
            }
            //replase content
            // var_dump($lid);
            if($lid && $eiid){
                $layout = new os_cckLayout($db->_db);
                $layout->load($lid);
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              //instance layout
              ob_start();
              Instance::showItem($cck_option,$eiid, 0, $lid);
              $body = str_replace("{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}", ob_get_contents(), $body);
              ob_end_clean();
            }else if($lid && $cat_id){
                $layout = new os_cckLayout($db->_db);
                $layout->load($lid);
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              //category layout
              ob_start();
              Category::showCategory($cck_option,$cat_id,$lid);
              $body = str_replace("{CCKLayout|l-".$lid.":CCKCategory|c-".$cat_id."|}", ob_get_contents(), $body);
              ob_end_clean();
            }else{
                $layout = new os_cckLayout($db->_db);
                $layout->load($lid);
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              //other layout
              ob_start();
              $layout = new os_cckLayout($db->_db);
              $layout->load($lid);
              switch($layout->type){
                case "add_instance":
                case "request_instance":
                  Instance::show_request_layout($cck_option ,$lid,0);
                  break;

                case "all_categories":
                  Category::listCategories($cck_option, $lid);
                  break;

                case "all_instance":
                  Instance::show_all_instance($cck_option,$lid);
                  break;

                case "search":
                  Category::showSearch($cck_option,0,$lid);
                  break;

                case "calendar":
                  Instance::show_calendar($cck_option,$lid);
                  break;  
              }
              $body = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $body);
              ob_end_clean();
            }

          }//end matches

          
          
        }
        
        
      }
    }
    $result = $this->addStyle($head, $body);
    $app->setBody($result['head'].$result['body']);
    
  }

  protected function _load($position, $style = 'none')
  {
    self::$modules[$position] = '';
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('module');
    $modules  = JModuleHelper::getModules($position);
    $params   = array('style' => $style);
    ob_start();

    foreach ($modules as $module)
    {
      echo $renderer->render($module, $params);
    }

    self::$modules[$position] = ob_get_clean();

    return self::$modules[$position];
  }

  protected function _loadmod($module, $title, $style = 'none')
  {
    self::$mods[$module] = '';
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('module');
    $mod      = JModuleHelper::getModule($module, $title);

    // If the module without the mod_ isn't found, try it with mod_.
    // This allows people to enter it either way in the content
    if (!isset($mod))
    {
      $name = 'mod_' . $module;
      $mod  = JModuleHelper::getModule($name, $title);
    }

    $params = array('style' => $style);
    ob_start();

    echo $renderer->render($mod, $params);

    self::$mods[$module] = ob_get_clean();

    return self::$mods[$module];
  }

  public function addStyle($head, $body){
    $session = JFactory::getSession();
    $doc = JFactory::getDocument();
    $app = JFactory::getApplication();
    
//    var_dump($doc);
    $matches  = preg_grep ('/bootstrap.css/i', array_keys($doc->_styleSheets));
    if(!$matches){
      $matches  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap/i', array_keys($doc->_styleSheets));
    }
    $plugin = JPluginHelper::getPlugin('system', 'cck_system');
    $params = new JRegistry;
    $params->loadString($plugin->params);
    
    $input = $input = $app->input;
    $format = $input->get('format', '');
    if($format == 'raw' || $format == 'json' || $format == 'xml'){
        $result = array('head' => $head, 'body' => $body);
        return $result;
    }
    $link = '';
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
//    var_dump($check);
    if($check){
      switch($params->get('bootstrap_version','0')){
        case "1":
          //dont include bootstrap
        break;
        case "2":
          //include bootstrap 2
          $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap2.css";
          $session->set('bootstrap', '2');
        break;
        case "3":
          //include bootstrap 3
          $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
          $session->set('bootstrap', '3');
        break;
        default:
          //try detect version of bootstrap
          if(isset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js'])){
              
            $file = file_get_contents(JPATH_BASE.'/media/jui/js/bootstrap.min.js');
            $match  = preg_match_all ('/Custom version for Joomla!/i', $file);
            if($match){
              $session->set('bootstrap', '2');
            }else{
              $session->set('bootstrap', '3');
              $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
            }
          }else if(count($matches)){
            foreach ($matches as $value) {
              //need test if we have bootstrap
              $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/2/i', $value);
              if($match){
                $session->set('bootstrap', '2');
              }else{
                $match  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap\/3/i', array_keys($doc->_styleSheets));
                if($match){
                  $session->set('bootstrap', '3');
                }
              }
            }
          }else{
            $session->set('bootstrap', '3');
            $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
          }
      }
      if($link)
        $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }

    $link = JUri::root() . "components/com_os_cck/assets/css/front_end_style.css";
    
    if($check && !preg_match_all('|front_end_style.css|',$head,$matches)){
      $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }

    $link = JURI::root() . '/components/com_os_cck/assets/css/jquerOs-ui.min.css';
    if(!preg_match_all('|jquerOs-ui.min.css|',$head,$matches)){
      $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }
    if(stripos($body, '{|style-cck-swiper|}') !== false){
    
        $link = JURI::root() . '/components/com_os_cck/assets/css/swiper.css';
        if(!preg_match_all('|swiper.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-swiper|}', '', $body);
    
        
        }
    if(stripos($body, '{|style-cck-lightbox|}') !== false){
        $link = JURI::root() . '/components/com_os_cck/assets/lightbox/css/lightbox.css';
        if(!preg_match_all('|lightbox.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-lightbox|}', '', $body);
    }
    
    if(stripos($body, '{|style-cck-timepicker|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/css/jquery.cck_timepicker.css";
        if(!preg_match_all('|jquery.cck_timepicker.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-timepicker|}', '', $body);
    }
    
    if(stripos($body, '{|style-cck-fine-uploader|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/css/fine-uploader-new.css";
        if(!preg_match_all('|jquery.cck_timepicker.js|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-fine-uploader|}', '', $body);
    }
    
    

    

    $link = JUri::root() . "/components/com_os_cck/assets/js/jQuerOs-2.2.4.min.js";
    if(!preg_match_all('|jQuerOs-2.2.4.min.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
      $head .= '<script type="text/javascript">jQuerOs=jQuerOs.noConflict();</script>'."\n";
    }

    $link = JUri::root() . "/components/com_os_cck/assets/js/jquerOs-ui.min.js";
    if(!preg_match_all('|jquerOs-ui.min.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }
    $link = JUri::root() . "/components/com_os_cck/assets/js/os-cck-modal.js";
    if(!preg_match_all('|os-cck-modal.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }
    
    
    if(stripos($body, '{|script-cck-timepicker|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/jquery.cck_timepicker.js";
        if(!preg_match_all('|jquery.cck_timepicker.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-timepicker|}', '', $body);
    }
    if(stripos($body, '{|script-cck-swiper|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/swiper-os.js";
        if(!preg_match_all('|swiper-os.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-swiper|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-raty|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/jquery.raty.js";
        if(!preg_match_all('|jquery.raty.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-raty|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-lightbox|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/lightbox/js/lightbox-2.6.min.js";
        if(!preg_match_all('|lightbox-2.6.min.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-lightbox|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-fine-uploader|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/fine-uploader.js";
        if(!preg_match_all('|fine-uploader.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-fine-uploader|}', '', $body);
    }
 
    
    if(stripos($body, '{|script-cck-gmap|}') !== false){
        $os_cck_configuration = JComponentHelper::getParams('com_os_cck');
        $key = 'key='.$os_cck_configuration->get("google_map_key",'');
        $link = "//maps.googleapis.com/maps/api/js?".$key;
        if(!preg_match_all('|maps.googleapis.com|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-gmap|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-markerclusterer|}') !== false){
        
        $link = "//developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js";
        if(!preg_match_all('|markerclusterer.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-markerclusterer|}', '', $body);
    }
    
    
    
    
    $link = "//cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.js";
    if(!preg_match_all('|wow.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }
    
    $link = JUri::root() . "/components/com_os_cck/assets/js/functions.js";
    if(!preg_match_all('|functions.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }

    $result = array('head' => $head, 'body' => $body);
    
    return $result;
  }

  public function old_classes_declarated(){
      JLoader::registerAlias('ActionLogPlugin', '\\Joomla\\Component\\Actionlogs\\Administrator\\Plugin\\ActionLogPlugin', '5.0');

      JLoader::registerAlias('FieldsPlugin', '\\Joomla\\Component\\Fields\\Administrator\\Plugin\\FieldsPlugin', '5.0');
      JLoader::registerAlias('FieldsListPlugin', '\\Joomla\\Component\\Fields\\Administrator\\Plugin\\FieldsListPlugin', '5.0');

      JLoader::registerAlias('PrivacyExportDomain', '\\Joomla\\Component\\Privacy\\Administrator\\Export\\Domain', '5.0');
      JLoader::registerAlias('PrivacyExportField', '\\Joomla\\Component\\Privacy\\Administrator\\Export\\Field', '5.0');
      JLoader::registerAlias('PrivacyExportItem', '\\Joomla\\Component\\Privacy\\Administrator\\Export\\Item', '5.0');
      JLoader::registerAlias('PrivacyPlugin', '\\Joomla\\Component\\Privacy\\Administrator\\Plugin\\PrivacyPlugin', '5.0');
      JLoader::registerAlias('PrivacyRemovalStatus', '\\Joomla\\Component\\Privacy\\Administrator\\Removal\\Status', '5.0');
      JLoader::registerAlias('PrivacyTableRequest', '\\Joomla\\Component\\Privacy\\Administrator\\Table\\RequestTable', '5.0');

      JLoader::registerAlias('TagsTableTag', '\\Joomla\\Component\\Tags\\Administrator\\Table\\TagTable', '5.0');

      JLoader::registerAlias('ContentHelperRoute', '\\Joomla\\Component\\Content\\Site\\Helper\\RouteHelper', '5.0');

      JLoader::registerAlias('FinderIndexerAdapter', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Adapter', '5.0');
      JLoader::registerAlias('FinderIndexerHelper', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Helper', '5.0');
      JLoader::registerAlias('FinderIndexer', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Indexer', '5.0');
      JLoader::registerAlias('FinderIndexerParser', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Parser', '5.0');
      JLoader::registerAlias('FinderIndexerQuery', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Query', '5.0');
      JLoader::registerAlias('FinderIndexerResult', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Result', '5.0');
      JLoader::registerAlias('FinderIndexerTaxonomy', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Taxonomy', '5.0');
      JLoader::registerAlias('FinderIndexerToken', '\\Joomla\\Component\\Finder\\Administrator\\Indexer\\Token', '5.0');


      JLoader::registerAlias('JRegistry', '\\Joomla\\Registry\\Registry', '6.0');
      JLoader::registerAlias('JRegistryFormatIni', '\\Joomla\\Registry\\Format\\Ini', '6.0');
      JLoader::registerAlias('JRegistryFormatJson', '\\Joomla\\Registry\\Format\\Json', '6.0');
      JLoader::registerAlias('JRegistryFormatPhp', '\\Joomla\\Registry\\Format\\Php', '6.0');
      JLoader::registerAlias('JRegistryFormatXml', '\\Joomla\\Registry\\Format\\Xml', '6.0');
      JLoader::registerAlias('JStringInflector', '\\Joomla\\String\\Inflector', '6.0');
      JLoader::registerAlias('JStringNormalise', '\\Joomla\\String\\Normalise', '6.0');
      JLoader::registerAlias('JData', '\\Joomla\\Data\\DataObject', '6.0');
      JLoader::registerAlias('JDataSet', '\\Joomla\\Data\\DataSet', '6.0');
      JLoader::registerAlias('JDataDumpable', '\\Joomla\\Data\\DumpableInterface', '6.0');

      JLoader::registerAlias('JApplicationAdministrator', '\\Joomla\\CMS\\Application\\AdministratorApplication', '6.0');
      JLoader::registerAlias('JApplicationHelper', '\\Joomla\\CMS\\Application\\ApplicationHelper', '6.0');
      JLoader::registerAlias('JApplicationBase', '\\Joomla\\CMS\\Application\\BaseApplication', '6.0');
      JLoader::registerAlias('JApplicationCli', '\\Joomla\\CMS\\Application\\CliApplication', '6.0');
      JLoader::registerAlias('JApplicationCms', '\\Joomla\\CMS\\Application\\CMSApplication', '6.0');
      JLoader::registerAlias('JApplicationDaemon', '\\Joomla\\CMS\\Application\\DaemonApplication', '6.0');
      JLoader::registerAlias('JApplicationSite', '\\Joomla\\CMS\\Application\\SiteApplication', '6.0');
      JLoader::registerAlias('JApplicationWeb', '\\Joomla\\CMS\\Application\\WebApplication', '6.0');
      JLoader::registerAlias('JApplicationWebClient', '\\Joomla\\Application\\Web\\WebClient', '6.0');
      JLoader::registerAlias('JDaemon', '\\Joomla\\CMS\\Application\\DaemonApplication', '6.0');
      JLoader::registerAlias('JCli', '\\Joomla\\CMS\\Application\\CliApplication', '6.0');
      JLoader::registerAlias('JWeb', '\\Joomla\\CMS\\Application\\WebApplication', '4.0');
      JLoader::registerAlias('JWebClient', '\\Joomla\\Application\\Web\\WebClient', '4.0');

      JLoader::registerAlias('JModelAdmin', '\\Joomla\\CMS\\MVC\\Model\\AdminModel', '6.0');
      JLoader::registerAlias('JModelForm', '\\Joomla\\CMS\\MVC\\Model\\FormModel', '6.0');
      JLoader::registerAlias('JModelItem', '\\Joomla\\CMS\\MVC\\Model\\ItemModel', '6.0');
      JLoader::registerAlias('JModelList', '\\Joomla\\CMS\\MVC\\Model\\ListModel', '6.0');
      JLoader::registerAlias('JModelLegacy', '\\Joomla\\CMS\\MVC\\Model\\BaseDatabaseModel', '6.0');
      JLoader::registerAlias('JViewCategories', '\\Joomla\\CMS\\MVC\\View\\CategoriesView', '6.0');
      JLoader::registerAlias('JViewCategory', '\\Joomla\\CMS\\MVC\\View\\CategoryView', '6.0');
      JLoader::registerAlias('JViewCategoryfeed', '\\Joomla\\CMS\\MVC\\View\\CategoryFeedView', '6.0');
      JLoader::registerAlias('JViewLegacy', '\\Joomla\\CMS\\MVC\\View\\HtmlView', '6.0');
      JLoader::registerAlias('JControllerAdmin', '\\Joomla\\CMS\\MVC\\Controller\\AdminController', '6.0');
      JLoader::registerAlias('JControllerLegacy', '\\Joomla\\CMS\\MVC\\Controller\\BaseController', '6.0');
      JLoader::registerAlias('JControllerForm', '\\Joomla\\CMS\\MVC\\Controller\\FormController', '6.0');
      JLoader::registerAlias('JTableInterface', '\\Joomla\\CMS\\Table\\TableInterface', '6.0');
      JLoader::registerAlias('JTable', '\\Joomla\\CMS\\Table\\Table', '6.0');
      JLoader::registerAlias('JTableNested', '\\Joomla\\CMS\\Table\\Nested', '6.0');
      JLoader::registerAlias('JTableAsset', '\\Joomla\\CMS\\Table\\Asset', '6.0');
      JLoader::registerAlias('JTableExtension', '\\Joomla\\CMS\\Table\\Extension', '6.0');
      JLoader::registerAlias('JTableLanguage', '\\Joomla\\CMS\\Table\\Language', '6.0');
      JLoader::registerAlias('JTableUpdate', '\\Joomla\\CMS\\Table\\Update', '6.0');
      JLoader::registerAlias('JTableUpdatesite', '\\Joomla\\CMS\\Table\\UpdateSite', '6.0');
      JLoader::registerAlias('JTableUser', '\\Joomla\\CMS\\Table\\User', '6.0');
      JLoader::registerAlias('JTableUsergroup', '\\Joomla\\CMS\\Table\\Usergroup', '6.0');
      JLoader::registerAlias('JTableViewlevel', '\\Joomla\\CMS\\Table\\ViewLevel', '6.0');
      JLoader::registerAlias('JTableContenthistory', '\\Joomla\\CMS\\Table\\ContentHistory', '6.0');
      JLoader::registerAlias('JTableContenttype', '\\Joomla\\CMS\\Table\\ContentType', '6.0');
      JLoader::registerAlias('JTableCorecontent', '\\Joomla\\CMS\\Table\\CoreContent', '6.0');
      JLoader::registerAlias('JTableUcm', '\\Joomla\\CMS\\Table\\Ucm', '6.0');
      JLoader::registerAlias('JTableCategory', '\\Joomla\\CMS\\Table\\Category', '6.0');
      JLoader::registerAlias('JTableContent', '\\Joomla\\CMS\\Table\\Content', '6.0');
      JLoader::registerAlias('JTableMenu', '\\Joomla\\CMS\\Table\\Menu', '6.0');
      JLoader::registerAlias('JTableMenuType', '\\Joomla\\CMS\\Table\\MenuType', '6.0');
      JLoader::registerAlias('JTableModule', '\\Joomla\\CMS\\Table\\Module', '6.0');

      JLoader::registerAlias('JAccess', '\\Joomla\\CMS\\Access\\Access', '6.0');
      JLoader::registerAlias('JAccessRule', '\\Joomla\\CMS\\Access\\Rule', '6.0');
      JLoader::registerAlias('JAccessRules', '\\Joomla\\CMS\\Access\\Rules', '6.0');
      JLoader::registerAlias('JAccessExceptionNotallowed', '\\Joomla\\CMS\\Access\\Exception\\NotAllowed', '6.0');
      JLoader::registerAlias('JRule', '\\Joomla\\CMS\\Access\\Rule', '6.0');
      JLoader::registerAlias('JRules', '\\Joomla\\CMS\\Access\\Rules', '6.0');

      JLoader::registerAlias('JHelp', '\\Joomla\\CMS\\Help\\Help', '6.0');
      JLoader::registerAlias('JCaptcha', '\\Joomla\\CMS\\Captcha\\Captcha', '6.0');

      JLoader::registerAlias('JLanguageAssociations', '\\Joomla\\CMS\\Language\\Associations', '6.0');
      JLoader::registerAlias('JLanguage', '\\Joomla\\CMS\\Language\\Language', '6.0');
      JLoader::registerAlias('JLanguageHelper', '\\Joomla\\CMS\\Language\\LanguageHelper', '6.0');
      JLoader::registerAlias('JLanguageMultilang', '\\Joomla\\CMS\\Language\\Multilanguage', '6.0');
      JLoader::registerAlias('JText', '\\Joomla\\CMS\\Language\\Text', '6.0');
      JLoader::registerAlias('JLanguageTransliterate', '\\Joomla\\CMS\\Language\\Transliterate', '6.0');

      JLoader::registerAlias('JComponentHelper', '\\Joomla\\CMS\\Component\\ComponentHelper', '6.0');
      JLoader::registerAlias('JComponentRecord', '\\Joomla\\CMS\\Component\\ComponentRecord', '6.0');
      JLoader::registerAlias('JComponentExceptionMissing', '\\Joomla\\CMS\\Component\\Exception\\MissingComponentException', '6.0');
      JLoader::registerAlias('JComponentRouterBase', '\\Joomla\\CMS\\Component\\Router\\RouterBase', '6.0');
      JLoader::registerAlias('JComponentRouterInterface', '\\Joomla\\CMS\\Component\\Router\\RouterInterface', '6.0');
      JLoader::registerAlias('JComponentRouterLegacy', '\\Joomla\\CMS\\Component\\Router\\RouterLegacy', '6.0');
      JLoader::registerAlias('JComponentRouterView', '\\Joomla\\CMS\\Component\\Router\\RouterView', '6.0');
      JLoader::registerAlias('JComponentRouterViewconfiguration', '\\Joomla\\CMS\\Component\\Router\\RouterViewConfiguration', '6.0');
      JLoader::registerAlias('JComponentRouterRulesMenu', '\\Joomla\\CMS\\Component\\Router\\Rules\\MenuRules', '6.0');
      JLoader::registerAlias('JComponentRouterRulesNomenu', '\\Joomla\\CMS\\Component\\Router\\Rules\\NomenuRules', '6.0');
      JLoader::registerAlias('JComponentRouterRulesInterface', '\\Joomla\\CMS\\Component\\Router\\Rules\\RulesInterface', '6.0');
      JLoader::registerAlias('JComponentRouterRulesStandard', '\\Joomla\\CMS\\Component\\Router\\Rules\\StandardRules', '6.0');

      JLoader::registerAlias('JEditor', '\\Joomla\\CMS\\Editor\\Editor', '6.0');

      JLoader::registerAlias('JErrorPage', '\\Joomla\\CMS\\Exception\\ExceptionHandler', '6.0');

      JLoader::registerAlias('JAuthenticationHelper', '\\Joomla\\CMS\\Helper\\AuthenticationHelper', '6.0');
      JLoader::registerAlias('JHelper', '\\Joomla\\CMS\\Helper\\CMSHelper', '6.0');
      JLoader::registerAlias('JHelperContent', '\\Joomla\\CMS\\Helper\\ContentHelper', '6.0');
      JLoader::registerAlias('JLibraryHelper', '\\Joomla\\CMS\\Helper\\LibraryHelper', '6.0');
      JLoader::registerAlias('JHelperMedia', '\\Joomla\\CMS\\Helper\\MediaHelper', '6.0');
      JLoader::registerAlias('JModuleHelper', '\\Joomla\\CMS\\Helper\\ModuleHelper', '6.0');
      JLoader::registerAlias('JHelperRoute', '\\Joomla\\CMS\\Helper\\RouteHelper', '6.0');
      JLoader::registerAlias('JHelperTags', '\\Joomla\\CMS\\Helper\\TagsHelper', '6.0');
      JLoader::registerAlias('JHelperUsergroups', '\\Joomla\\CMS\\Helper\\UserGroupsHelper', '6.0');

      JLoader::registerAlias('JLayoutBase', '\\Joomla\\CMS\\Layout\\BaseLayout', '6.0');
      JLoader::registerAlias('JLayoutFile', '\\Joomla\\CMS\\Layout\\FileLayout', '6.0');
      JLoader::registerAlias('JLayoutHelper', '\\Joomla\\CMS\\Layout\\LayoutHelper', '6.0');
      JLoader::registerAlias('JLayout', '\\Joomla\\CMS\\Layout\\LayoutInterface', '6.0');

      JLoader::registerAlias('JResponseJson', '\\Joomla\\CMS\\Response\\JsonResponse', '6.0');

      JLoader::registerAlias('JPlugin', '\\Joomla\\CMS\\Plugin\\CMSPlugin', '6.0');
      JLoader::registerAlias('JPluginHelper', '\\Joomla\\CMS\\Plugin\\PluginHelper', '6.0');

      JLoader::registerAlias('JMenu', '\\Joomla\\CMS\\Menu\\AbstractMenu', '6.0');
      JLoader::registerAlias('JMenuAdministrator', '\\Joomla\\CMS\\Menu\\AdministratorMenu', '6.0');
      JLoader::registerAlias('JMenuItem', '\\Joomla\\CMS\\Menu\\MenuItem', '6.0');
      JLoader::registerAlias('JMenuSite', '\\Joomla\\CMS\\Menu\\SiteMenu', '6.0');

      JLoader::registerAlias('JPagination', '\\Joomla\\CMS\\Pagination\\Pagination', '6.0');
      JLoader::registerAlias('JPaginationObject', '\\Joomla\\CMS\\Pagination\\PaginationObject', '6.0');

      JLoader::registerAlias('JPathway', '\\Joomla\\CMS\\Pathway\\Pathway', '6.0');
      JLoader::registerAlias('JPathwaySite', '\\Joomla\\CMS\\Pathway\\SitePathway', '6.0');

      JLoader::registerAlias('JSchemaChangeitem', '\\Joomla\\CMS\\Schema\\ChangeItem', '6.0');
      JLoader::registerAlias('JSchemaChangeset', '\\Joomla\\CMS\\Schema\\ChangeSet', '6.0');
      JLoader::registerAlias('JSchemaChangeitemMysql', '\\Joomla\\CMS\\Schema\\ChangeItem\\MysqlChangeItem', '6.0');
      JLoader::registerAlias('JSchemaChangeitemPostgresql', '\\Joomla\\CMS\\Schema\\ChangeItem\\PostgresqlChangeItem', '6.0');

      JLoader::registerAlias('JUcm', '\\Joomla\\CMS\\UCM\\UCM', '6.0');
      JLoader::registerAlias('JUcmBase', '\\Joomla\\CMS\\UCM\\UCMBase', '6.0');
      JLoader::registerAlias('JUcmContent', '\\Joomla\\CMS\\UCM\\UCMContent', '6.0');
      JLoader::registerAlias('JUcmType', '\\Joomla\\CMS\\UCM\\UCMType', '6.0');

      JLoader::registerAlias('JToolbar', '\\Joomla\\CMS\\Toolbar\\Toolbar', '6.0');
      JLoader::registerAlias('JToolbarButton', '\\Joomla\\CMS\\Toolbar\\ToolbarButton', '6.0');
      JLoader::registerAlias('JToolbarButtonConfirm', '\\Joomla\\CMS\\Toolbar\\Button\\ConfirmButton', '6.0');
      JLoader::registerAlias('JToolbarButtonCustom', '\\Joomla\\CMS\\Toolbar\\Button\\CustomButton', '6.0');
      JLoader::registerAlias('JToolbarButtonHelp', '\\Joomla\\CMS\\Toolbar\\Button\\HelpButton', '6.0');
      JLoader::registerAlias('JToolbarButtonLink', '\\Joomla\\CMS\\Toolbar\\Button\\LinkButton', '6.0');
      JLoader::registerAlias('JToolbarButtonPopup', '\\Joomla\\CMS\\Toolbar\\Button\\PopupButton', '6.0');
      JLoader::registerAlias('JToolbarButtonSeparator', '\\Joomla\\CMS\\Toolbar\\Button\\SeparatorButton', '6.0');
      JLoader::registerAlias('JToolbarButtonStandard', '\\Joomla\\CMS\\Toolbar\\Button\\StandardButton', '6.0');
      JLoader::registerAlias('JToolbarHelper', '\\Joomla\\CMS\\Toolbar\\ToolbarHelper', '6.0');
      JLoader::registerAlias('JButton', '\\Joomla\\CMS\\Toolbar\\ToolbarButton', '6.0');

      JLoader::registerAlias('JVersion', '\\Joomla\\CMS\\Version', '6.0');

      JLoader::registerAlias('JAuthentication', '\\Joomla\\CMS\\Authentication\\Authentication', '6.0');
      JLoader::registerAlias('JAuthenticationResponse', '\\Joomla\\CMS\\Authentication\\AuthenticationResponse', '6.0');

      JLoader::registerAlias('JBrowser', '\\Joomla\\CMS\\Environment\\Browser', '6.0');

      JLoader::registerAlias('JAssociationExtensionInterface', '\\Joomla\\CMS\\Association\\AssociationExtensionInterface', '6.0');
      JLoader::registerAlias('JAssociationExtensionHelper', '\\Joomla\\CMS\\Association\\AssociationExtensionHelper', '6.0');

      JLoader::registerAlias('JDocument', '\\Joomla\\CMS\\Document\\Document', '6.0');
      JLoader::registerAlias('JDocumentError', '\\Joomla\\CMS\\Document\\ErrorDocument', '6.0');
      JLoader::registerAlias('JDocumentFeed', '\\Joomla\\CMS\\Document\\FeedDocument', '6.0');
      JLoader::registerAlias('JDocumentHtml', '\\Joomla\\CMS\\Document\\HtmlDocument', '6.0');
      JLoader::registerAlias('JDocumentImage', '\\Joomla\\CMS\\Document\\ImageDocument', '6.0');
      JLoader::registerAlias('JDocumentJson', '\\Joomla\\CMS\\Document\\JsonDocument', '6.0');
      JLoader::registerAlias('JDocumentOpensearch', '\\Joomla\\CMS\\Document\\OpensearchDocument', '6.0');
      JLoader::registerAlias('JDocumentRaw', '\\Joomla\\CMS\\Document\\RawDocument', '6.0');
      JLoader::registerAlias('JDocumentRenderer', '\\Joomla\\CMS\\Document\\DocumentRenderer', '6.0');
      JLoader::registerAlias('JDocumentXml', '\\Joomla\\CMS\\Document\\XmlDocument', '6.0');
      JLoader::registerAlias('JDocumentRendererFeedAtom', '\\Joomla\\CMS\\Document\\Renderer\\Feed\\AtomRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererFeedRss', '\\Joomla\\CMS\\Document\\Renderer\\Feed\\RssRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererHtmlComponent', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ComponentRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererHtmlHead', '\\Joomla\\CMS\\Document\\Renderer\\Html\\HeadRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererHtmlMessage', '\\Joomla\\CMS\\Document\\Renderer\\Html\\MessageRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererHtmlModule', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ModuleRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererHtmlModules', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ModulesRenderer', '6.0');
      JLoader::registerAlias('JDocumentRendererAtom', '\\Joomla\\CMS\\Document\\Renderer\\Feed\\AtomRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererRSS', '\\Joomla\\CMS\\Document\\Renderer\\Feed\\RssRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererComponent', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ComponentRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererHead', '\\Joomla\\CMS\\Document\\Renderer\\Html\\HeadRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererMessage', '\\Joomla\\CMS\\Document\\Renderer\\Html\\MessageRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererModule', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ModuleRenderer', '4.0');
      JLoader::registerAlias('JDocumentRendererModules', '\\Joomla\\CMS\\Document\\Renderer\\Html\\ModulesRenderer', '4.0');
      JLoader::registerAlias('JFeedEnclosure', '\\Joomla\\CMS\\Document\\Feed\\FeedEnclosure', '6.0');
      JLoader::registerAlias('JFeedImage', '\\Joomla\\CMS\\Document\\Feed\\FeedImage', '6.0');
      JLoader::registerAlias('JFeedItem', '\\Joomla\\CMS\\Document\\Feed\\FeedItem', '6.0');
      JLoader::registerAlias('JOpenSearchImage', '\\Joomla\\CMS\\Document\\Opensearch\\OpensearchImage', '6.0');
      JLoader::registerAlias('JOpenSearchUrl', '\\Joomla\\CMS\\Document\\Opensearch\\OpensearchUrl', '6.0');

      JLoader::registerAlias('JFilterInput', '\\Joomla\\CMS\\Filter\\InputFilter', '6.0');
      JLoader::registerAlias('JFilterOutput', '\\Joomla\\CMS\\Filter\\OutputFilter', '6.0');

      JLoader::registerAlias('JHttp', '\\Joomla\\CMS\\Http\\Http', '6.0');
      JLoader::registerAlias('JHttpFactory', '\\Joomla\\CMS\\Http\\HttpFactory', '6.0');
      JLoader::registerAlias('JHttpResponse', '\\Joomla\\CMS\\Http\\Response', '6.0');
      JLoader::registerAlias('JHttpTransport', '\\Joomla\\CMS\\Http\\TransportInterface', '6.0');
      JLoader::registerAlias('JHttpTransportCurl', '\\Joomla\\CMS\\Http\\Transport\\CurlTransport', '6.0');
      JLoader::registerAlias('JHttpTransportSocket', '\\Joomla\\CMS\\Http\\Transport\\SocketTransport', '6.0');
      JLoader::registerAlias('JHttpTransportStream', '\\Joomla\\CMS\\Http\\Transport\\StreamTransport', '6.0');

      JLoader::registerAlias('JInstaller', '\\Joomla\\CMS\\Installer\\Installer', '6.0');
      JLoader::registerAlias('JInstallerAdapter', '\\Joomla\\CMS\\Installer\\InstallerAdapter', '6.0');
      JLoader::registerAlias('JInstallerExtension', '\\Joomla\\CMS\\Installer\\InstallerExtension', '6.0');
      JLoader::registerAlias('JExtension', '\\Joomla\\CMS\\Installer\\InstallerExtension', '6.0');
      JLoader::registerAlias('JInstallerHelper', '\\Joomla\\CMS\\Installer\\InstallerHelper', '6.0');
      JLoader::registerAlias('JInstallerScript', '\\Joomla\\CMS\\Installer\\InstallerScript', '6.0');
      JLoader::registerAlias('JInstallerManifest', '\\Joomla\\CMS\\Installer\\Manifest', '6.0');
      JLoader::registerAlias('JInstallerAdapterComponent', '\\Joomla\\CMS\\Installer\\Adapter\\ComponentAdapter', '6.0');
      JLoader::registerAlias('JInstallerComponent', '\\Joomla\\CMS\\Installer\\Adapter\\ComponentAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterFile', '\\Joomla\\CMS\\Installer\\Adapter\\FileAdapter', '6.0');
      JLoader::registerAlias('JInstallerFile', '\\Joomla\\CMS\\Installer\\Adapter\\FileAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterLanguage', '\\Joomla\\CMS\\Installer\\Adapter\\LanguageAdapter', '6.0');
      JLoader::registerAlias('JInstallerLanguage', '\\Joomla\\CMS\\Installer\\Adapter\\LanguageAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterLibrary', '\\Joomla\\CMS\\Installer\\Adapter\\LibraryAdapter', '6.0');
      JLoader::registerAlias('JInstallerLibrary', '\\Joomla\\CMS\\Installer\\Adapter\\LibraryAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterModule', '\\Joomla\\CMS\\Installer\\Adapter\\ModuleAdapter', '6.0');
      JLoader::registerAlias('JInstallerModule', '\\Joomla\\CMS\\Installer\\Adapter\\ModuleAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterPackage', '\\Joomla\\CMS\\Installer\\Adapter\\PackageAdapter', '6.0');
      JLoader::registerAlias('JInstallerPackage', '\\Joomla\\CMS\\Installer\\Adapter\\PackageAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterPlugin', '\\Joomla\\CMS\\Installer\\Adapter\\PluginAdapter', '6.0');
      JLoader::registerAlias('JInstallerPlugin', '\\Joomla\\CMS\\Installer\\Adapter\\PluginAdapter', '6.0');
      JLoader::registerAlias('JInstallerAdapterTemplate', '\\Joomla\\CMS\\Installer\\Adapter\\TemplateAdapter', '6.0');
      JLoader::registerAlias('JInstallerTemplate', '\\Joomla\\CMS\\Installer\\Adapter\\TemplateAdapter', '6.0');
      JLoader::registerAlias('JInstallerManifestLibrary', '\\Joomla\\CMS\\Installer\\Manifest\\LibraryManifest', '6.0');
      JLoader::registerAlias('JInstallerManifestPackage', '\\Joomla\\CMS\\Installer\\Manifest\\PackageManifest', '6.0');

      JLoader::registerAlias('JRouterAdministrator', '\\Joomla\\CMS\\Router\\AdministratorRouter', '6.0');
      JLoader::registerAlias('JRoute', '\\Joomla\\CMS\\Router\\Route', '6.0');
      JLoader::registerAlias('JRouter', '\\Joomla\\CMS\\Router\\Router', '6.0');
      JLoader::registerAlias('JRouterSite', '\\Joomla\\CMS\\Router\\SiteRouter', '6.0');

      JLoader::registerAlias('JCategories', '\\Joomla\\CMS\\Categories\\Categories', '6.0');
      JLoader::registerAlias('JCategoryNode', '\\Joomla\\CMS\\Categories\\CategoryNode', '6.0');

      JLoader::registerAlias('JDate', '\\Joomla\\CMS\\Date\\Date', '6.0');

      JLoader::registerAlias('JLog', '\\Joomla\\CMS\\Log\\Log', '6.0');
      JLoader::registerAlias('JLogEntry', '\\Joomla\\CMS\\Log\\LogEntry', '6.0');
      JLoader::registerAlias('JLogLogger', '\\Joomla\\CMS\\Log\\Logger', '6.0');
      JLoader::registerAlias('JLogger', '\\Joomla\\CMS\\Log\\Logger', '6.0');
      JLoader::registerAlias('JLogLoggerCallback', '\\Joomla\\CMS\\Log\\Logger\\CallbackLogger', '6.0');
      JLoader::registerAlias('JLogLoggerDatabase', '\\Joomla\\CMS\\Log\\Logger\\DatabaseLogger', '6.0');
      JLoader::registerAlias('JLogLoggerEcho', '\\Joomla\\CMS\\Log\\Logger\\EchoLogger', '6.0');
      JLoader::registerAlias('JLogLoggerFormattedtext', '\\Joomla\\CMS\\Log\\Logger\\FormattedtextLogger', '6.0');
      JLoader::registerAlias('JLogLoggerMessagequeue', '\\Joomla\\CMS\\Log\\Logger\\MessagequeueLogger', '6.0');
      JLoader::registerAlias('JLogLoggerSyslog', '\\Joomla\\CMS\\Log\\Logger\\SyslogLogger', '6.0');
      JLoader::registerAlias('JLogLoggerW3c', '\\Joomla\\CMS\\Log\\Logger\\W3cLogger', '6.0');

      JLoader::registerAlias('JProfiler', '\\Joomla\\CMS\\Profiler\\Profiler', '6.0');

      JLoader::registerAlias('JUri', '\\Joomla\\CMS\\Uri\\Uri', '6.0');

      JLoader::registerAlias('JCache', '\\Joomla\\CMS\\Cache\\Cache', '6.0');
      JLoader::registerAlias('JCacheController', '\\Joomla\\CMS\\Cache\\CacheController', '6.0');
      JLoader::registerAlias('JCacheStorage', '\\Joomla\\CMS\\Cache\\CacheStorage', '6.0');
      JLoader::registerAlias('JCacheControllerCallback', '\\Joomla\\CMS\\Cache\\Controller\\CallbackController', '6.0');
      JLoader::registerAlias('JCacheControllerOutput', '\\Joomla\\CMS\\Cache\\Controller\\OutputController', '6.0');
      JLoader::registerAlias('JCacheControllerPage', '\\Joomla\\CMS\\Cache\\Controller\\PageController', '6.0');
      JLoader::registerAlias('JCacheControllerView', '\\Joomla\\CMS\\Cache\\Controller\\ViewController', '6.0');
      JLoader::registerAlias('JCacheStorageApcu', '\\Joomla\\CMS\\Cache\\Storage\\ApcuStorage', '6.0');
      JLoader::registerAlias('JCacheStorageHelper', '\\Joomla\\CMS\\Cache\\Storage\\CacheStorageHelper', '6.0');
      JLoader::registerAlias('JCacheStorageFile', '\\Joomla\\CMS\\Cache\\Storage\\FileStorage', '6.0');
      JLoader::registerAlias('JCacheStorageMemcached', '\\Joomla\\CMS\\Cache\\Storage\\MemcachedStorage', '6.0');
      JLoader::registerAlias('JCacheStorageRedis', '\\Joomla\\CMS\\Cache\\Storage\\RedisStorage', '6.0');
      JLoader::registerAlias('JCacheException', '\\Joomla\\CMS\\Cache\\Exception\\CacheExceptionInterface', '6.0');
      JLoader::registerAlias('JCacheExceptionConnecting', '\\Joomla\\CMS\\Cache\\Exception\\CacheConnectingException', '6.0');
      JLoader::registerAlias('JCacheExceptionUnsupported', '\\Joomla\\CMS\\Cache\\Exception\\UnsupportedCacheException', '6.0');

      JLoader::registerAlias('JSession', '\\Joomla\\CMS\\Session\\Session', '6.0');

      JLoader::registerAlias('JUser', '\\Joomla\\CMS\\User\\User', '6.0');
      JLoader::registerAlias('JUserHelper', '\\Joomla\\CMS\\User\\UserHelper', '6.0');

      JLoader::registerAlias('JForm', '\\Joomla\\CMS\\Form\\Form', '6.0');
      JLoader::registerAlias('JFormField', '\\Joomla\\CMS\\Form\\FormField', '6.0');
      JLoader::registerAlias('JFormHelper', '\\Joomla\\CMS\\Form\\FormHelper', '6.0');
      JLoader::registerAlias('JFormRule', '\\Joomla\\CMS\\Form\\FormRule', '6.0');

      JLoader::registerAlias('JFormFieldAccessLevel', '\\Joomla\\CMS\\Form\\Field\\AccesslevelField', '6.0');
      JLoader::registerAlias('JFormFieldAliastag', '\\Joomla\\CMS\\Form\\Field\\AliastagField', '6.0');
      JLoader::registerAlias('JFormFieldAuthor', '\\Joomla\\CMS\\Form\\Field\\AuthorField', '6.0');
      JLoader::registerAlias('JFormFieldCacheHandler', '\\Joomla\\CMS\\Form\\Field\\CachehandlerField', '6.0');
      JLoader::registerAlias('JFormFieldCalendar', '\\Joomla\\CMS\\Form\\Field\\CalendarField', '6.0');
      JLoader::registerAlias('JFormFieldCaptcha', '\\Joomla\\CMS\\Form\\Field\\CaptchaField', '6.0');
      JLoader::registerAlias('JFormFieldCategory', '\\Joomla\\CMS\\Form\\Field\\CategoryField', '6.0');
      JLoader::registerAlias('JFormFieldCheckbox', '\\Joomla\\CMS\\Form\\Field\\CheckboxField', '6.0');
      JLoader::registerAlias('JFormFieldCheckboxes', '\\Joomla\\CMS\\Form\\Field\\CheckboxesField', '6.0');
      JLoader::registerAlias('JFormFieldChromeStyle', '\\Joomla\\CMS\\Form\\Field\\ChromestyleField', '6.0');
      JLoader::registerAlias('JFormFieldColor', '\\Joomla\\CMS\\Form\\Field\\ColorField', '6.0');
      JLoader::registerAlias('JFormFieldCombo', '\\Joomla\\CMS\\Form\\Field\\ComboField', '6.0');
      JLoader::registerAlias('JFormFieldComponentlayout', '\\Joomla\\CMS\\Form\\Field\\ComponentlayoutField', '6.0');
      JLoader::registerAlias('JFormFieldComponents', '\\Joomla\\CMS\\Form\\Field\\ComponentsField', '6.0');
      JLoader::registerAlias('JFormFieldContenthistory', '\\Joomla\\CMS\\Form\\Field\\ContenthistoryField', '6.0');
      JLoader::registerAlias('JFormFieldContentlanguage', '\\Joomla\\CMS\\Form\\Field\\ContentlanguageField', '6.0');
      JLoader::registerAlias('JFormFieldContenttype', '\\Joomla\\CMS\\Form\\Field\\ContenttypeField', '6.0');
      JLoader::registerAlias('JFormFieldDatabaseConnection', '\\Joomla\\CMS\\Form\\Field\\DatabaseconnectionField', '6.0');
      JLoader::registerAlias('JFormFieldEditor', '\\Joomla\\CMS\\Form\\Field\\EditorField', '6.0');
      JLoader::registerAlias('JFormFieldEMail', '\\Joomla\\CMS\\Form\\Field\\EmailField', '6.0');
      JLoader::registerAlias('JFormFieldFile', '\\Joomla\\CMS\\Form\\Field\\FileField', '6.0');
      JLoader::registerAlias('JFormFieldFileList', '\\Joomla\\CMS\\Form\\Field\\FilelistField', '6.0');
      JLoader::registerAlias('JFormFieldFolderList', '\\Joomla\\CMS\\Form\\Field\\FolderlistField', '6.0');
      JLoader::registerAlias('JFormFieldFrontend_Language', '\\Joomla\\CMS\\Form\\Field\\FrontendlanguageField', '6.0');
      JLoader::registerAlias('JFormFieldGroupedList', '\\Joomla\\CMS\\Form\\Field\\GroupedlistField', '6.0');
      JLoader::registerAlias('JFormFieldHeadertag', '\\Joomla\\CMS\\Form\\Field\\HeadertagField', '6.0');
      JLoader::registerAlias('JFormFieldHidden', '\\Joomla\\CMS\\Form\\Field\\HiddenField', '6.0');
      JLoader::registerAlias('JFormFieldImageList', '\\Joomla\\CMS\\Form\\Field\\ImagelistField', '6.0');
      JLoader::registerAlias('JFormFieldInteger', '\\Joomla\\CMS\\Form\\Field\\IntegerField', '6.0');
      JLoader::registerAlias('JFormFieldLanguage', '\\Joomla\\CMS\\Form\\Field\\LanguageField', '6.0');
      JLoader::registerAlias('JFormFieldLastvisitDateRange', '\\Joomla\\CMS\\Form\\Field\\LastvisitdaterangeField', '6.0');
      JLoader::registerAlias('JFormFieldLimitbox', '\\Joomla\\CMS\\Form\\Field\\LimitboxField', '6.0');
      JLoader::registerAlias('JFormFieldList', '\\Joomla\\CMS\\Form\\Field\\ListField', '6.0');
      JLoader::registerAlias('JFormFieldMedia', '\\Joomla\\CMS\\Form\\Field\\MediaField', '6.0');
      JLoader::registerAlias('JFormFieldMenu', '\\Joomla\\CMS\\Form\\Field\\MenuField', '6.0');
      JLoader::registerAlias('JFormFieldMenuitem', '\\Joomla\\CMS\\Form\\Field\\MenuitemField', '6.0');
      JLoader::registerAlias('JFormFieldMeter', '\\Joomla\\CMS\\Form\\Field\\MeterField', '6.0');
      JLoader::registerAlias('JFormFieldModulelayout', '\\Joomla\\CMS\\Form\\Field\\ModulelayoutField', '6.0');
      JLoader::registerAlias('JFormFieldModuleOrder', '\\Joomla\\CMS\\Form\\Field\\ModuleorderField', '6.0');
      JLoader::registerAlias('JFormFieldModulePosition', '\\Joomla\\CMS\\Form\\Field\\ModulepositionField', '6.0');
      JLoader::registerAlias('JFormFieldModuletag', '\\Joomla\\CMS\\Form\\Field\\ModuletagField', '6.0');
      JLoader::registerAlias('JFormFieldNote', '\\Joomla\\CMS\\Form\\Field\\NoteField', '6.0');
      JLoader::registerAlias('JFormFieldNumber', '\\Joomla\\CMS\\Form\\Field\\NumberField', '6.0');
      JLoader::registerAlias('JFormFieldOrdering', '\\Joomla\\CMS\\Form\\Field\\OrderingField', '6.0');
      JLoader::registerAlias('JFormFieldPassword', '\\Joomla\\CMS\\Form\\Field\\PasswordField', '6.0');
      JLoader::registerAlias('JFormFieldPlugins', '\\Joomla\\CMS\\Form\\Field\\PluginsField', '6.0');
      JLoader::registerAlias('JFormFieldPlugin_Status', '\\Joomla\\CMS\\Form\\Field\\PluginstatusField', '6.0');
      JLoader::registerAlias('JFormFieldPredefinedList', '\\Joomla\\CMS\\Form\\Field\\PredefinedListField', '6.0');
      JLoader::registerAlias('JFormFieldRadio', '\\Joomla\\CMS\\Form\\Field\\RadioField', '6.0');
      JLoader::registerAlias('JFormFieldRange', '\\Joomla\\CMS\\Form\\Field\\RangeField', '6.0');
      JLoader::registerAlias('JFormFieldRedirect_Status', '\\Joomla\\CMS\\Form\\Field\\RedirectStatusField', '6.0');
      JLoader::registerAlias('JFormFieldRegistrationDateRange', '\\Joomla\\CMS\\Form\\Field\\RegistrationdaterangeField', '6.0');
      JLoader::registerAlias('JFormFieldRules', '\\Joomla\\CMS\\Form\\Field\\RulesField', '6.0');
      JLoader::registerAlias('JFormFieldSessionHandler', '\\Joomla\\CMS\\Form\\Field\\SessionhandlerField', '6.0');
      JLoader::registerAlias('JFormFieldSpacer', '\\Joomla\\CMS\\Form\\Field\\SpacerField', '6.0');
      JLoader::registerAlias('JFormFieldSQL', '\\Joomla\\CMS\\Form\\Field\\SqlField', '6.0');
      JLoader::registerAlias('JFormFieldStatus', '\\Joomla\\CMS\\Form\\Field\\StatusField', '6.0');
      JLoader::registerAlias('JFormFieldSubform', '\\Joomla\\CMS\\Form\\Field\\SubformField', '6.0');
      JLoader::registerAlias('JFormFieldTag', '\\Joomla\\CMS\\Form\\Field\\TagField', '6.0');
      JLoader::registerAlias('JFormFieldTel', '\\Joomla\\CMS\\Form\\Field\\TelephoneField', '6.0');
      JLoader::registerAlias('JFormFieldTemplatestyle', '\\Joomla\\CMS\\Form\\Field\\TemplatestyleField', '6.0');
      JLoader::registerAlias('JFormFieldText', '\\Joomla\\CMS\\Form\\Field\\TextField', '6.0');
      JLoader::registerAlias('JFormFieldTextarea', '\\Joomla\\CMS\\Form\\Field\\TextareaField', '6.0');
      JLoader::registerAlias('JFormFieldTimezone', '\\Joomla\\CMS\\Form\\Field\\TimezoneField', '6.0');
      JLoader::registerAlias('JFormFieldUrl', '\\Joomla\\CMS\\Form\\Field\\UrlField', '6.0');
      JLoader::registerAlias('JFormFieldUserActive', '\\Joomla\\CMS\\Form\\Field\\UseractiveField', '6.0');
      JLoader::registerAlias('JFormFieldUserGroupList', '\\Joomla\\CMS\\Form\\Field\\UsergrouplistField', '6.0');
      JLoader::registerAlias('JFormFieldUserState', '\\Joomla\\CMS\\Form\\Field\\UserstateField', '6.0');
      JLoader::registerAlias('JFormFieldUser', '\\Joomla\\CMS\\Form\\Field\\UserField', '6.0');
      JLoader::registerAlias('JFormRuleBoolean', '\\Joomla\\CMS\\Form\\Rule\\BooleanRule', '6.0');
      JLoader::registerAlias('JFormRuleCalendar', '\\Joomla\\CMS\\Form\\Rule\\CalendarRule', '6.0');
      JLoader::registerAlias('JFormRuleCaptcha', '\\Joomla\\CMS\\Form\\Rule\\CaptchaRule', '6.0');
      JLoader::registerAlias('JFormRuleColor', '\\Joomla\\CMS\\Form\\Rule\\ColorRule', '6.0');
      JLoader::registerAlias('JFormRuleEmail', '\\Joomla\\CMS\\Form\\Rule\\EmailRule', '6.0');
      JLoader::registerAlias('JFormRuleEquals', '\\Joomla\\CMS\\Form\\Rule\\EqualsRule', '6.0');
      JLoader::registerAlias('JFormRuleNotequals', '\\Joomla\\CMS\\Form\\Rule\\NotequalsRule', '6.0');
      JLoader::registerAlias('JFormRuleNumber', '\\Joomla\\CMS\\Form\\Rule\\NumberRule', '6.0');
      JLoader::registerAlias('JFormRuleOptions', '\\Joomla\\CMS\\Form\\Rule\\OptionsRule', '6.0');
      JLoader::registerAlias('JFormRulePassword', '\\Joomla\\CMS\\Form\\Rule\\PasswordRule', '6.0');
      JLoader::registerAlias('JFormRuleRules', '\\Joomla\\CMS\\Form\\Rule\\RulesRule', '6.0');
      JLoader::registerAlias('JFormRuleTel', '\\Joomla\\CMS\\Form\\Rule\\TelRule', '6.0');
      JLoader::registerAlias('JFormRuleUrl', '\\Joomla\\CMS\\Form\\Rule\\UrlRule', '6.0');
      JLoader::registerAlias('JFormRuleUsername', '\\Joomla\\CMS\\Form\\Rule\\UsernameRule', '6.0');

      JLoader::registerAlias('JMicrodata', '\\Joomla\\CMS\\Microdata\\Microdata', '6.0');

      JLoader::registerAlias('JDatabaseDriver', '\\Joomla\\Database\\DatabaseDriver', '6.0');
      JLoader::registerAlias('JDatabaseExporter', '\\Joomla\\Database\\DatabaseExporter', '6.0');
      JLoader::registerAlias('JDatabaseFactory', '\\Joomla\\Database\\DatabaseFactory', '6.0');
      JLoader::registerAlias('JDatabaseImporter', '\\Joomla\\Database\\DatabaseImporter', '6.0');
      JLoader::registerAlias('JDatabaseInterface', '\\Joomla\\Database\\DatabaseInterface', '6.0');
      JLoader::registerAlias('JDatabaseIterator', '\\Joomla\\Database\\DatabaseIterator', '6.0');
      JLoader::registerAlias('JDatabaseQuery', '\\Joomla\\Database\\DatabaseQuery', '6.0');
      JLoader::registerAlias('JDatabaseDriverMysqli', '\\Joomla\\Database\\Mysqli\\MysqliDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverPdo', '\\Joomla\\Database\\Pdo\\PdoDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverPdomysql', '\\Joomla\\Database\\Mysql\\MysqlDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverPgsql', '\\Joomla\\Database\\Pgsql\\PgsqlDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverSqlazure', '\\Joomla\\Database\\Sqlazure\\SqlazureDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverSqlite', '\\Joomla\\Database\\Sqlite\\SqliteDriver', '6.0');
      JLoader::registerAlias('JDatabaseDriverSqlsrv', '\\Joomla\\Database\\Sqlsrv\\SqlsrvDriver', '6.0');
      JLoader::registerAlias('JDatabaseExceptionConnecting', '\\Joomla\\Database\\Exception\\ConnectionFailureException', '6.0');
      JLoader::registerAlias('JDatabaseExceptionExecuting', '\\Joomla\\Database\\Exception\\ExecutionFailureException', '6.0');
      JLoader::registerAlias('JDatabaseExceptionUnsupported', '\\Joomla\\Database\\Exception\\UnsupportedAdapterException', '6.0');
      JLoader::registerAlias('JDatabaseExporterMysqli', '\\Joomla\\Database\\Mysqli\\MysqliExporter', '6.0');
      JLoader::registerAlias('JDatabaseExporterPdomysql', '\\Joomla\\Database\\Mysql\\MysqlExporter', '6.0');
      JLoader::registerAlias('JDatabaseExporterPgsql', '\\Joomla\\Database\\Pgsql\\PgsqlExporter', '6.0');
      JLoader::registerAlias('JDatabaseImporterMysqli', '\\Joomla\\Database\\Mysqli\\MysqliImporter', '6.0');
      JLoader::registerAlias('JDatabaseImporterPdomysql', '\\Joomla\\Database\\Mysql\\MysqlImporter', '6.0');
      JLoader::registerAlias('JDatabaseImporterPgsql', '\\Joomla\\Database\\Pgsql\\PgsqlImporter', '6.0');
      JLoader::registerAlias('JDatabaseQueryElement', '\\Joomla\\Database\\Query\\QueryElement', '6.0');
      JLoader::registerAlias('JDatabaseQueryLimitable', '\\Joomla\\Database\\Query\\LimitableInterface', '6.0');
      JLoader::registerAlias('JDatabaseQueryPreparable', '\\Joomla\\Database\\Query\\PreparableInterface', '6.0');
      JLoader::registerAlias('JDatabaseQueryMysqli', '\\Joomla\\Database\\Mysqli\\MysqliQuery', '6.0');
      JLoader::registerAlias('JDatabaseQueryPdo', '\\Joomla\\Database\\Pdo\\PdoQuery', '6.0');
      JLoader::registerAlias('JDatabaseQueryPdomysql', '\\Joomla\\Database\\Mysql\\MysqlQuery', '6.0');
      JLoader::registerAlias('JDatabaseQueryPgsql', '\\Joomla\\Database\\Pgsql\\PgsqlQuery', '6.0');
      JLoader::registerAlias('JDatabaseQuerySqlazure', '\\Joomla\\Database\\Sqlazure\\SqlazureQuery', '6.0');
      JLoader::registerAlias('JDatabaseQuerySqlite', '\\Joomla\\Database\\Sqlite\\SqliteQuery', '6.0');
      JLoader::registerAlias('JDatabaseQuerySqlsrv', '\\Joomla\\Database\\Sqlsrv\\SqlsrvQuery', '6.0');

      JLoader::registerAlias('JFactory', '\\Joomla\\CMS\\Factory', '6.0');

      JLoader::registerAlias('JMail', '\\Joomla\\CMS\\Mail\\Mail', '6.0');
      JLoader::registerAlias('JMailHelper', '\\Joomla\\CMS\\Mail\\MailHelper', '6.0');

      JLoader::registerAlias('JClientHelper', '\\Joomla\\CMS\\Client\\ClientHelper', '6.0');
      JLoader::registerAlias('JClientFtp', '\\Joomla\\CMS\\Client\\FtpClient', '6.0');
      JLoader::registerAlias('JFTP', '\\Joomla\\CMS\\Client\\FtpClient', '4.0');

      JLoader::registerAlias('JUpdate', '\\Joomla\\CMS\\Updater\\Update', '6.0');
      JLoader::registerAlias('JUpdateAdapter', '\\Joomla\\CMS\\Updater\\UpdateAdapter', '6.0');
      JLoader::registerAlias('JUpdater', '\\Joomla\\CMS\\Updater\\Updater', '6.0');
      JLoader::registerAlias('JUpdaterCollection', '\\Joomla\\CMS\\Updater\\Adapter\\CollectionAdapter', '6.0');
      JLoader::registerAlias('JUpdaterExtension', '\\Joomla\\CMS\\Updater\\Adapter\\ExtensionAdapter', '6.0');

      JLoader::registerAlias('JCrypt', '\\Joomla\\CMS\\Crypt\\Crypt', '6.0');
      JLoader::registerAlias('JCryptCipher', '\\Joomla\\Crypt\\CipherInterface', '6.0');
      JLoader::registerAlias('JCryptKey', '\\Joomla\\Crypt\\Key', '6.0');
      JLoader::registerAlias('\\Joomla\\CMS\\Crypt\\CipherInterface', '\\Joomla\\Crypt\\CipherInterface', '6.0');
      JLoader::registerAlias('\\Joomla\\CMS\\Crypt\\Key', '\\Joomla\\Crypt\\Key', '6.0');
      JLoader::registerAlias('JCryptCipherCrypto', '\\Joomla\\CMS\\Crypt\\Cipher\\CryptoCipher', '6.0');

      JLoader::registerAlias('JStringPunycode', '\\Joomla\\CMS\\String\\PunycodeHelper', '6.0');

      JLoader::registerAlias('JBuffer', '\\Joomla\\CMS\\Utility\\BufferStreamHandler', '6.0');
      JLoader::registerAlias('JUtility', '\\Joomla\\CMS\\Utility\\Utility', '6.0');

      JLoader::registerAlias('JInputCli', '\\Joomla\\CMS\\Input\\Cli', '6.0');
      JLoader::registerAlias('JInputCookie', '\\Joomla\\CMS\\Input\\Cookie', '6.0');
      JLoader::registerAlias('JInputFiles', '\\Joomla\\CMS\\Input\\Files', '6.0');
      JLoader::registerAlias('JInput', '\\Joomla\\CMS\\Input\\Input', '6.0');
      JLoader::registerAlias('JInputJSON', '\\Joomla\\CMS\\Input\\Json', '6.0');

      JLoader::registerAlias('JFeed', '\\Joomla\\CMS\\Feed\\Feed', '6.0');
      JLoader::registerAlias('JFeedEntry', '\\Joomla\\CMS\\Feed\\FeedEntry', '6.0');
      JLoader::registerAlias('JFeedFactory', '\\Joomla\\CMS\\Feed\\FeedFactory', '6.0');
      JLoader::registerAlias('JFeedLink', '\\Joomla\\CMS\\Feed\\FeedLink', '6.0');
      JLoader::registerAlias('JFeedParser', '\\Joomla\\CMS\\Feed\\FeedParser', '6.0');
      JLoader::registerAlias('JFeedPerson', '\\Joomla\\CMS\\Feed\\FeedPerson', '6.0');
      JLoader::registerAlias('JFeedParserAtom', '\\Joomla\\CMS\\Feed\\Parser\\AtomParser', '6.0');
      JLoader::registerAlias('JFeedParserNamespace', '\\Joomla\\CMS\\Feed\\Parser\\NamespaceParserInterface', '6.0');
      JLoader::registerAlias('JFeedParserRss', '\\Joomla\\CMS\\Feed\\Parser\\RssParser', '6.0');
      JLoader::registerAlias('JFeedParserRssItunes', '\\Joomla\\CMS\\Feed\\Parser\\Rss\\ItunesRssParser', '6.0');
      JLoader::registerAlias('JFeedParserRssMedia', '\\Joomla\\CMS\\Feed\\Parser\\Rss\\MediaRssParser', '6.0');

      JLoader::registerAlias('JImage', '\\Joomla\\CMS\\Image\\Image', '6.0');
      JLoader::registerAlias('JImageFilter', '\\Joomla\\CMS\\Image\\ImageFilter', '6.0');
      JLoader::registerAlias('JImageFilterBackgroundfill', '\\Joomla\\CMS\\Image\\Filter\\Backgroundfill', '6.0');
      JLoader::registerAlias('JImageFilterBrightness', '\\Joomla\\CMS\\Image\\Filter\\Brightness', '6.0');
      JLoader::registerAlias('JImageFilterContrast', '\\Joomla\\CMS\\Image\\Filter\\Contrast', '6.0');
      JLoader::registerAlias('JImageFilterEdgedetect', '\\Joomla\\CMS\\Image\\Filter\\Edgedetect', '6.0');
      JLoader::registerAlias('JImageFilterEmboss', '\\Joomla\\CMS\\Image\\Filter\\Emboss', '6.0');
      JLoader::registerAlias('JImageFilterNegate', '\\Joomla\\CMS\\Image\\Filter\\Negate', '6.0');
      JLoader::registerAlias('JImageFilterSmooth', '\\Joomla\\CMS\\Image\\Filter\\Smooth', '6.0');

      JLoader::registerAlias('JObject', '\\Joomla\\CMS\\Object\\CMSObject', '6.0');

      JLoader::registerAlias('JExtensionHelper', '\\Joomla\\CMS\\Extension\\ExtensionHelper', '6.0');

      JLoader::registerAlias('JHtml', '\\Joomla\\CMS\\HTML\\HTMLHelper', '6.0');

      JLoader::registerAlias('\\Joomla\\Application\\Cli\\CliInput', '\\Joomla\\CMS\\Application\\CLI\\CliInput', '6.0');
      JLoader::registerAlias('\\Joomla\\Application\\Cli\\CliOutput', '\\Joomla\\CMS\\Application\\CLI\\CliOutput', '6.0');
      JLoader::registerAlias('\\Joomla\\Application\\Cli\\ColorStyle', '\\Joomla\\CMS\\Application\\CLI\\ColorStyle', '6.0');
      JLoader::registerAlias('\\Joomla\\Application\\Cli\\Output\\Stdout', '\\Joomla\\CMS\\Application\\CLI\\Output\\Stdout', '6.0');
      JLoader::registerAlias('\\Joomla\\Application\\Cli\\Output\\Xml', '\\Joomla\\CMS\\Application\\CLI\\Output\\Xml', '6.0');
      JLoader::registerAlias(
          '\\Joomla\\Application\\Cli\\Output\\Processor\\ColorProcessor',
          '\\Joomla\\CMS\\Application\\CLI\\Output\\Processor\\ColorProcessor',
          '6.0'
      );
      JLoader::registerAlias(
          '\\Joomla\\Application\\Cli\\Output\\Processor\\ProcessorInterface',
          '\\Joomla\\CMS\\Application\\CLI\\Output\\Processor\\ProcessorInterface',
          '6.0'
      );

      JLoader::registerAlias('JFile', '\\Joomla\\CMS\\Filesystem\\File', '6.0');
      JLoader::registerAlias('JFolder', '\\Joomla\\CMS\\Filesystem\\Folder', '6.0');
      JLoader::registerAlias('JFilesystemHelper', '\\Joomla\\CMS\\Filesystem\\FilesystemHelper', '6.0');
      JLoader::registerAlias('JFilesystemPatcher', '\\Joomla\\CMS\\Filesystem\\Patcher', '6.0');
      JLoader::registerAlias('JPath', '\\Joomla\\CMS\\Filesystem\\Path', '6.0');
      JLoader::registerAlias('JStream', '\\Joomla\\CMS\\Filesystem\\Stream', '6.0');
      JLoader::registerAlias('JStreamString', '\\Joomla\\CMS\\Filesystem\\Streams\\StreamString', '6.0');
      JLoader::registerAlias('JStringController', '\\Joomla\\CMS\\Filesystem\\Support\\StringController', '6.0');

      JLoader::registerAlias('JClassLoader', '\\Joomla\\CMS\\Autoload\\ClassLoader', '6.0');

      JLoader::registerAlias('JFormFilterInt_Array', '\\Joomla\\CMS\\Form\\Filter\\IntarrayFilter', '6.0');

      JLoader::registerAlias('JAdapter', '\\Joomla\\CMS\\Adapter\\Adapter', '6.0');
      JLoader::registerAlias('JAdapterInstance', '\\Joomla\\CMS\\Adapter\\AdapterInstance', '6.0');

      JLoader::registerAlias('JHtmlAccess', '\\Joomla\\CMS\\HTML\\Helpers\\Access', '6.0');
      JLoader::registerAlias('JHtmlActionsDropdown', '\\Joomla\\CMS\\HTML\\Helpers\\ActionsDropdown', '6.0');
      JLoader::registerAlias('JHtmlAdminLanguage', '\\Joomla\\CMS\\HTML\\Helpers\\AdminLanguage', '6.0');
      JLoader::registerAlias('JHtmlBehavior', '\\Joomla\\CMS\\HTML\\Helpers\\Behavior', '6.0');
      JLoader::registerAlias('JHtmlBootstrap', '\\Joomla\\CMS\\HTML\\Helpers\\Bootstrap', '6.0');
      JLoader::registerAlias('JHtmlCategory', '\\Joomla\\CMS\\HTML\\Helpers\\Category', '6.0');
      JLoader::registerAlias('JHtmlContent', '\\Joomla\\CMS\\HTML\\Helpers\\Content', '6.0');
      JLoader::registerAlias('JHtmlContentlanguage', '\\Joomla\\CMS\\HTML\\Helpers\\ContentLanguage', '6.0');
      JLoader::registerAlias('JHtmlDate', '\\Joomla\\CMS\\HTML\\Helpers\\Date', '6.0');
      JLoader::registerAlias('JHtmlDebug', '\\Joomla\\CMS\\HTML\\Helpers\\Debug', '6.0');
      JLoader::registerAlias('JHtmlDraggablelist', '\\Joomla\\CMS\\HTML\\Helpers\\DraggableList', '6.0');
      JLoader::registerAlias('JHtmlDropdown', '\\Joomla\\CMS\\HTML\\Helpers\\Dropdown', '6.0');
      JLoader::registerAlias('JHtmlEmail', '\\Joomla\\CMS\\HTML\\Helpers\\Email', '6.0');
      JLoader::registerAlias('JHtmlForm', '\\Joomla\\CMS\\HTML\\Helpers\\Form', '6.0');
      JLoader::registerAlias('JHtmlFormbehavior', '\\Joomla\\CMS\\HTML\\Helpers\\FormBehavior', '6.0');
      JLoader::registerAlias('JHtmlGrid', '\\Joomla\\CMS\\HTML\\Helpers\\Grid', '6.0');
      JLoader::registerAlias('JHtmlIcons', '\\Joomla\\CMS\\HTML\\Helpers\\Icons', '6.0');
      JLoader::registerAlias('JHtmlJGrid', '\\Joomla\\CMS\\HTML\\Helpers\\JGrid', '6.0');
      JLoader::registerAlias('JHtmlJquery', '\\Joomla\\CMS\\HTML\\Helpers\\Jquery', '6.0');
      JLoader::registerAlias('JHtmlLinks', '\\Joomla\\CMS\\HTML\\Helpers\\Links', '6.0');
      JLoader::registerAlias('JHtmlList', '\\Joomla\\CMS\\HTML\\Helpers\\ListHelper', '6.0');
      JLoader::registerAlias('JHtmlMenu', '\\Joomla\\CMS\\HTML\\Helpers\\Menu', '6.0');
      JLoader::registerAlias('JHtmlNumber', '\\Joomla\\CMS\\HTML\\Helpers\\Number', '6.0');
      JLoader::registerAlias('JHtmlSearchtools', '\\Joomla\\CMS\\HTML\\Helpers\\SearchTools', '6.0');
      JLoader::registerAlias('JHtmlSelect', '\\Joomla\\CMS\\HTML\\Helpers\\Select', '6.0');
      JLoader::registerAlias('JHtmlSidebar', '\\Joomla\\CMS\\HTML\\Helpers\\Sidebar', '6.0');
      JLoader::registerAlias('JHtmlSortableList', '\\Joomla\\CMS\\HTML\\Helpers\\SortableList', '6.0');
      JLoader::registerAlias('JHtmlString', '\\Joomla\\CMS\\HTML\\Helpers\\StringHelper', '6.0');
      JLoader::registerAlias('JHtmlTag', '\\Joomla\\CMS\\HTML\\Helpers\\Tag', '6.0');
      JLoader::registerAlias('JHtmlTel', '\\Joomla\\CMS\\HTML\\Helpers\\Telephone', '6.0');
      JLoader::registerAlias('JHtmlUser', '\\Joomla\\CMS\\HTML\\Helpers\\User', '6.0');
  }

}