<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/
$fName = $field->db_field_name;

//$showSearchOptions = array();
$fld_name_show = (isset($layout_params['fields']['showName_'.$fName])) ? 'checked="true"' : "";
$description_show = (isset($layout_params['fields']['description_'.$fName]))? 'checked="true"' : '';
$field_prefix = (isset($layout_params['fields'][$fName.'_prefix']))? $layout_params['fields'][$fName.'_prefix'] : '';
$field_suffix = (isset($layout_params['fields'][$fName.'_suffix']))? $layout_params['fields'][$fName.'_suffix'] : '';
$button_text = (isset($layout_params['fields'][$fName.'_button_text']))? $layout_params['fields'][$fName.'_button_text'] : 'PDF';
$text= (isset($layout_params['fields'][$fName.'_text']))? $layout_params['fields'][$fName.'_text'] : 'PDF';
$fld_alias = (isset($layout_params['fields'][$fName.'_alias']))? $layout_params['fields'][$fName.'_alias'] : 'PDF';
$field_tooltip = (isset($layout_params['fields'][$fName.'_tooltip']))? $layout_params['fields'][$fName.'_tooltip'] : '';
$access_selected = (isset($layout_params['fields']['access_'.$fName]))? $layout_params['fields']['access_'.$fName] : '1';
$gtree = get_group_children_tree_cck();
if(isset($layout_params['fields'][$fName.'_nofirst']) && $layout_params['fields'][$fName.'_nofirst'] == 'nofirst'){
    $fld_published = (isset($layout_params['fields'][$fName.'_published'])) ? 'checked="true"' : '';
}else{
    $fld_published = 'checked="true"';
    $fld_published = (isset($layout_params['fields'][$fName.'_published'])) ? 'checked="true"' : $fld_published;
}

$pdf_layout_options = get_pdf_layout_options($layout->fk_eid, $layout);

$button_type_opt = array();
$button_type_opt[] = JHTML::_('select.option','button','Button');
$button_type_opt[] = JHTML::_('select.option','icon','Font Awesome icon');
$button_type_opt[] = JHTML::_('select.option','text','Text');
//search params
//$showSearchOptions[] = JHTML::_('select.option','1','Show search by range');
//$showSearchOptions[] = JHTML::_('select.option','2','Show search by value');
//$showSearchOptions[] = JHTML::_('select.option','3','Search by value');
//$selectedFieldTitle = (isset($layout_params['fields']['search_'.$fName])) ? $layout_params['fields']['search_'.$fName] : '';
$selectedLayout = (isset($layout_params['fields']['lid_'.$fName])) ? $layout_params['fields']['lid_'.$fName] : '';
$selectedType = (isset($layout_params['fields']['button_type_'.$fName])) ? $layout_params['fields']['button_type_'.$fName] : 'icon';

$icon_alias_prefix = (isset($layout_params['fields'][$fName.'_add_icon_alias_prefix'])) ? $layout_params['fields'][$fName.'_add_icon_alias_prefix'] : '';
$icon_alias_suffix = (isset($layout_params['fields'][$fName.'_add_icon_alias_suffix'])) ? $layout_params['fields'][$fName.'_add_icon_alias_suffix'] : '';
$icon_prefix_prefix = (isset($layout_params['fields'][$fName.'_add_icon_prefix_prefix'])) ? $layout_params['fields'][$fName.'_add_icon_prefix_prefix'] : '';
$icon_prefix_suffix = (isset($layout_params['fields'][$fName.'_add_icon_prefix_suffix'])) ? $layout_params['fields'][$fName.'_add_icon_prefix_suffix'] : '';
$icon_suffix_prefix = (isset($layout_params['fields'][$fName.'_add_icon_suffix_prefix'])) ? $layout_params['fields'][$fName.'_add_icon_suffix_prefix'] : '';
$icon_suffix_suffix = (isset($layout_params['fields'][$fName.'_add_icon_suffix_suffix'])) ? $layout_params['fields'][$fName.'_add_icon_suffix_suffix'] : '';
$add_button_icon = (isset($layout_params['fields'][$fName.'_add_button_icon'])) ? $layout_params['fields'][$fName.'_add_button_icon'] : 'fa-file-pdf-o';

?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_PUBLISHED")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" <?php echo $fld_published?>>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_nofirst" value="nofirst">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_NAME")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" <?php echo $fld_name_show?>>
    </div>
    <div class="label_alias_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_ALIAS")?></label>
        <div class="fa <?php echo $icon_alias_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_prefix" value="<?php echo $icon_alias_prefix; ?>">
        <input type="text" size="4" style="float: right;" name="fi_<?php echo $fName?>_alias"  value="<?php echo $fld_alias?>" >
        <div class="fa <?php echo $icon_alias_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_suffix" value="<?php echo $icon_alias_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_DESCRIPTION")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_description_<?php echo $fName?>" <?php echo $description_show?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TOOLTIP")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_tooltip"  value="<?php echo $field_tooltip?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PDF_BUTTON_TYPE")?></label>
        <?php echo JHTML::_('select.genericlist',$button_type_opt, 'fi_button_type_'.$fName,
                                            'size="1" class="inputbox" ', 'value', 'text',$selectedType)?>
    </div>
    <div class="button_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_BUTTON_TEXT")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_button_text"  value="<?php echo $button_text?>" >
    </div>
    <div class="icon_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LAYOUT_SELECT_ICON")?></label>
        <div class="fa <?php echo $add_button_icon; ?> add_font_awesom" id="<?php echo $fName;?>_add_button_icon" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($add_button_icon == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_button_icon" value="<?php echo $add_button_icon; ?>">
    </div>
    <div class="text_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TEXT")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_text"  value="<?php echo $text?>" >
    </div>
    <div class="prefix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PREFIX")?></label>
        <div class="fa <?php echo $icon_prefix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_prefix" value="<?php echo $icon_prefix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_prefix"  value="<?php echo $field_prefix?>" >
        <div class="fa <?php echo $icon_prefix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_suffix" value="<?php echo $icon_prefix_suffix; ?>">
    </div>
    <div class="suffix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SUFFIX")?></label>
        <div class="fa <?php echo $icon_suffix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_prefix" value="<?php echo $icon_suffix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_suffix"  value="<?php echo $field_suffix?>" >
        <div class="fa <?php echo $icon_suffix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_suffix" value="<?php echo $icon_suffix_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PDF_LAYOUT")?></label>
        <?php echo JHTML::_('select.genericlist',$pdf_layout_options, 'fi_lid_'.$fName,
                                            'size="1" class="inputbox" ', 'value', 'text',$selectedLayout)?>
        <input type="hidden" name="os_cck_pdf_layout_<?php echo $fName?>[fid]" value="pdf_layout">
    </div>
    <?php if(isset($cck_entity_configuration[$layout->fk_eid]['check_access_fields']) && $cck_entity_configuration[$layout->fk_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
</div>

<script>
    window.addEventListener('load', function() {
        jQuerOs('#fi_button_type_cck_pdf_button').on('change', function(){
            show_hide_button_type();
        })
        
        function show_hide_button_type(){
            var value = jQuerOs('#fi_button_type_cck_pdf_button').val();
            
            if(value == 'button'){
                jQuerOs('.button_wrap').show();
                jQuerOs('.icon_wrap').hide();
                jQuerOs('.text_wrap').hide();
            }else if(value == 'icon'){
                jQuerOs('.button_wrap').hide();
                jQuerOs('.icon_wrap').show();
                jQuerOs('.text_wrap').hide();
            }else if(value == 'text'){
                jQuerOs('.button_wrap').hide();
                jQuerOs('.icon_wrap').hide();
                jQuerOs('.text_wrap').show();
            }
        }
        show_hide_button_type();
    })
</script>