<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2020 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit
*/
$doc = JFactory::getDocument();
$doc->addScript(JURI::root() . '/components/com_os_cck/assets/js/functions.js');

//timepicker
$doc->addStyleSheet(JURI::root() . "components/com_os_cck/assets/css/jquery.cck_timepicker.css");
$doc->addScript(JURI::root() . "components/com_os_cck/assets/js/jquery.cck_timepicker.js");

?>
<div class="cck-body">
  <div class="rent-history-top-buttons">
    <?php $link = JRoute::_("index.php?option=" . $input->get('option', 'com_os_cck') . "&amp;task=instance_manager&amp;Itemid=$Itemid") ?>
      <input class="show-instance" type="button"
          value="<?php echo JText::_('COM_OS_CCK_INSTANCE_MANAGER_SHOW_INSTANCE');?>" aria-invalid="false"
          onclick="window.location = '<?php echo $link;?>'">
      <?php
      if(checkAccess_cck($params->get('im_rent_requests_access',''), $user->groups, 0, 'instances')){ ?>
       <?php $link = JRoute::_("index.php?option=" . $input->get('option', 'com_os_cck') . "&amp;task=show_rent_request_instances&amp;Itemid=$Itemid") ?>
        <input class="show-rent-request" type="button"
            value="<?php echo JText::_('COM_OS_CCK_INSTANCE_MANAGER_SHOW_RENT_REQUESTS');?>" aria-invalid="false"
            onclick="window.location = '<?php echo $link;?>'">
      <?php
      }
      if(checkAccess_cck($params->get('im_buy_requests_access',''), $user->groups, 0, 'instances')){ ?>
       <?php $link = JRoute::_("index.php?option=" . $input->get('option', 'com_os_cck') . "&amp;task=show_buy_request_instances&amp;Itemid=$Itemid") ?>
        <input class="show-buy-request" type="button"
            value="<?php echo JText::_('COM_OS_CCK_INSTANCE_MANAGER_SHOW_BUY_REQUESTS');?>" aria-invalid="false"
            onclick="window.location = '<?php echo $link;?>'">
      <?php
      } ?>
        <?php if(checkAccess_cck($params->get('im_requests_access',''), $user->groups, 0, 'instances')){ ?>
       <?php $link = JRoute::_("index.php?option=" . $input->get('option', 'com_os_cck') . "&amp;task=show_request_instances&amp;Itemid=$Itemid") ?>
        <input class="show-request" type="button"
            value="<?php echo JText::_('COM_OS_CCK_INSTANCE_MANAGER_SHOW_REQUESTS');?>" aria-invalid="false"
            onclick="window.location = '<?php echo $link;?>'">
      <?php
      } ?>
      <?php if(checkAccess_cck($params->get('im_rent_history_access',''), $user->groups, 0, 'instances')){ ?>
          <?php $link = JRoute::_("index.php?option=" . $input->get('option', 'com_os_cck') . "&amp;task=show_user_rent_history&amp;Itemid=$Itemid") ?>
          <input class="show-rent-history" type="button"
                 value="<?php echo JText::_('COM_OS_CCK_INSTANCE_MANAGER_SHOW_USER_RENT_HISTORY');?>" aria-invalid="false"
                 onclick="window.location = '<?php echo $link;?>'">
      <?php } ?>
  </div>
  <div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
    <tr>
      <th align="center" class="title" width="5%" nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_INSTANCE_ID');?></th>
      <?php
      foreach($show_fields as $value){
        foreach($value as $field){
          $global_settings = unserialize($field->global_settings);
          ?>
          <th align="center" class="title" width="15%"
            nowrap="nowrap"><?php echo $global_settings['label'];?></th>
          <?php
        }
      }
      ?>
      <th align="center" class="title" width="15%"
          nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_ENTITY');?></th>
      <th align="center" class="title" width="15%"
          nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_RENT_FROM'); ?></th>
      <th align="center" class="title" width="20%"
          nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_RENT_UNTIL'); ?></th>
      <th align="center" class="title" width="20%"
          nowrap="nowrap"><?php echo JText::_('COM_OS_CCK_LABEL_RENT_RETURN'); ?></th>
    </tr>
      <?php
      for ($i = 0, $n = count($instances); $i < $n; $i++) {
        $instance = & $instances[$i];
        ?>
        <tr <?php echo ($instance->rent_return)? 'style="color:#0C6B00";' : 'style="color:#630712"'?> class="row<?php echo $i % 2; ?>">
          <td align="center"><?php echo $instance->eiid; ?></td>
  <!-- **************************************************************** -->
            <?php
            foreach($show_fields as $key => $value){
              foreach($value as $field){
                if($instance->fk_eid != $key){
                  echo'<td></td>';
                  continue;
                }
                if($field->field_type == 'categoryfield'){
                  echo "<td align='center'>$instance->category</td>";
                  continue;
                }
                ?>
                <td align="left">
                  <?php
                  $global_settings = unserialize($field->global_settings);
                  $entityInstance = new os_cckEntityInstance($db);
                  $entityInstance->load($instance->eiid);
                  $value = $entityInstance->getFieldValue($field);

                  if (isset($value['video']) && !empty($value['video'])) {
                  showVideoField($field, $entityInstance, $layout_params);
                  }
                  if(isset($value['audio']) && !empty($value['audio'])){
                    showAudioField($field, $entityInstance, $layout_params);
                  }
                  if ($value[0]->data == '' && $field->field_type != 'locationfield') {
                  continue;
                  }
                  if ($field->field_type == 'datetime_popup' && $value[0]->data == '0000-00-00 00:00:00') {
                    continue;
                  }
                  if ($field->field_type == 'locationfield' && !$value[0]->{$field->field_name . "_adress"}) {
                    continue;
                  }
                  ?>
                  <span class="col_box" style="display:block;
                        <?php echo ($field->field_type=='imagefield'
                        && isset($field->options['width'])
                        && isset($field->options['height']))?
                         'width:'.$field->options['width'].'px; height:'.$field->options['height'].'px;':
                         '';?>">
                    <?php echo prepere_field_for_show($field, $value[0],$instance);?>
                  </span>
                </td>
                <?php
              }
            }
            ?>
  <!-- **************************************************************** -->
          <td align="center"><?php echo $instance->entity; ?></td>
          <td align="center"><?php echo $instance->rent_from ?></td>
          <td align="center"><?php echo $instance->rent_until ?></td>
          <td align="center"><?php echo ($instance->rent_return)?$instance->rent_return : '<b>In Rent</b>'?></td>
      </tr>
  <?php
    }//end for
  ?>
  </table>
</div>
