<?php
/**
 * wp-traveler WordPress Theme, ordasvit.com
 * wp-traveler is distributed under the terms of the GNU GPL
 * Copyright: OrdaSvit, Andrey Kvasnevskiy, ordasvit.com
 */

get_header();

?>

<div id="main" class="site-main">

	<div class="wrapper-header-img">
		<div class="wrapper-inner-header-img">
			<img src="<?php echo esc_url(get_template_directory_uri() . '/images/traveler-img.jpg'); ?>" alt="traveler-img">
			<h2>
				<?php esc_html_e('Hi, I\'m Dexter, and I\'m a traveler.', 'wp-traveler') ?>
			</h2>
			<p>
				<?php esc_html_e('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the
				industry\'s standard dummy text ever since the 1500s', 'wp-traveler') ?>
			</p>
		</div>
	</div>


	<div class="container">
		<div class="row">
			<h3 class="my_widget_title_custom">
				<?php _e('Places I’ve been', 'wp-traveler'); ?>
			</h3>

			<?php
			function display_parent_categories_list()
			{

				$args = array(
					'parent' => 0,
					'hide_empty' => false,
					'number' => 4,
				);

				$categories = get_categories($args);

				if (empty($categories)) {
					return '<p>not found</p>';
				}

				ob_start();
				?>
				<ul class="wrapper-categories-traveler">
					<?php foreach ($categories as $category): ?>
						<li class="cat-item">
							<a href="<?php echo get_category_link($category->term_id); ?>">
								<?php echo esc_html($category->name); ?>
							</a>
						</li>
					<?php endforeach; ?>
				</ul>
				<?php
				return ob_get_clean();
			}

			?>

			<?php echo display_parent_categories_list(); ?>

		</div>
	</div>


	<div class="container">
		<div class="row">
			<h3 class="my_widget_title_custom">
				<?php _e('recent travels', 'wp-traveler'); ?>
			</h3>

			<?php
			function display_latest_posts_with_details($atts)
			{
				$atts = shortcode_atts(
					array(
						'posts_per_page' => 4,
					),
					$atts,
					'latest_posts'
				);

				$args = array(
					'posts_per_page' => intval($atts['posts_per_page']),
					'post_status' => 'publish',
				);

				$query = new WP_Query($args);

				// Starting output buffering
				ob_start();

				if ($query->have_posts()): ?>
					<div class="wrapper-recent-travels-traveler">
						<?php while ($query->have_posts()):
							$query->the_post(); ?>
							<div class="single-recent-travels-traveler">
								<div class="wrapper-img-recent-travels-traveler">
									<?php if (has_post_thumbnail()): ?>
										<a href="<?php the_permalink(); ?>" class="post-thumbnail">
											<?php the_post_thumbnail('big'); ?>
										</a>
									<?php endif; ?>
								</div>

								<div class="wrapper-desc-recent-travels-traveler">

									<div class="post-categories">
										<?php the_category(', '); ?>
									</div>

									<h2 class="post-title">
										<a href="<?php the_permalink(); ?>">
											<?php the_title(); ?>
										</a>
									</h2>

									<div class="post-meta">
										<span class="date">
											<i class="fas fa-calendar"></i>
											<?php echo get_the_date(); ?>
										</span>
									</div>

									<div class="post-excerpt">
										<?php the_excerpt(); ?>
									</div>

									<div class="post-tags">
										<?php the_tags('', ''); ?>
									</div>
								</div>
							</div>
						<?php endwhile; ?>
					</div>
					<?php
				else:
					echo '<p>not found</p>';
				endif;

				wp_reset_postdata();

				return ob_get_clean();
			}

			?>

			<?php echo display_latest_posts_with_details(array('posts_per_page' => 4)); ?>

		</div>
	</div>

	<div class="wrapper-about-me-traveler">
		<div class="container">
			<div class="row">
				<div class="col-lg-7 col-md-12 col-sm-12 xol-xs-12 wrapper-about-left-traveler">
					<h3>
						<?php esc_html_e('About me', 'wp-traveler') ?>
					</h3>
					<div>
						<p>
							<?php esc_html_e('It is a long established fact that a reader will be distracted by the readable content of a
							page when looking at its layout.', 'wp-traveler') ?>
						</p>
						<p style="margin-left: 30px;">
							<?php esc_html_e('1. Contrary to popular belief, Lorem Ipsum is not simply random
							text.', 'wp-traveler') ?>
						</p>
						<p style="margin-left: 30px;">
							<?php esc_html_e('2. It has roots in a piece of classical Latin literature from 45
							BC.', 'wp-traveler') ?>
						</p>
						<p style="margin-left: 30px;">
							<?php esc_html_e('3. Lorem Ipsum comes from sections 1.10.32 and 1.10.33.', 'wp-traveler') ?>
						</p>
						<p style="margin-left: 30px;">
							<?php esc_html_e('4. This book is a treatise on the theory of ethics.', 'wp-traveler') ?>
						</p>
						<p>
							<?php esc_html_e('There are many variations of passages of Lorem Ipsum available, but the majority have
							suffered alteration in some form, by injected humour, or randomised words which don\'t look
							even slightly believable.', 'wp-traveler') ?>
						</p>
					</div>
				</div>

				<div class="col-lg-5 col-md-12 col-sm-12 xol-xs-12 wrapper-about-right-traveler">
					<img src="<?php echo esc_url(get_template_directory_uri() . '/images/about.jpg'); ?>" alt="about-img">
				</div>

			</div>
		</div>
	</div>




	<div class="container">
		<div class="row">
			<h3 class="my_widget_title_custom">
				<?php _e('All posts', 'wp-traveler'); ?>
			</h3>

			<?php
			function display_all_posts_with_details($atts)
			{
				$atts = shortcode_atts(
					array(
						'posts_per_page' => 5,
					),
					$atts,
					'latest_posts'
				);

				$args = array(
					'posts_per_page' => intval($atts['posts_per_page']),
					'post_status' => 'publish',
				);

				$query = new WP_Query($args);

				// Starting output buffering
				ob_start();

				if ($query->have_posts()): ?>
					<div class="wrapper-all-posts-traveler">
						<?php while ($query->have_posts()):
							$query->the_post(); ?>
							<div class="single-all-posts-traveler">
								<div class="wrapper-img-all-posts-traveler">
									<?php if (has_post_thumbnail()): ?>
										<a href="<?php the_permalink(); ?>" class="post-thumbnail">
											<?php the_post_thumbnail('big'); ?>
										</a>
									<?php endif; ?>
								</div>

								<div class="wrapper-desc-all-posts-traveler">

									<div class="post-categories">
										<?php the_category(', '); ?>
									</div>

									<h2 class="post-title">
										<a href="<?php the_permalink(); ?>">
											<?php the_title(); ?>
										</a>
									</h2>

									<div class="post-meta">
										<span class="date">
											<i class="fas fa-calendar"></i>
											<?php echo get_the_date(); ?>
										</span>
									</div>

								</div>
							</div>
						<?php endwhile; ?>
					</div>
					<?php
				else:
					echo '<p>not found</p>';
				endif;

				wp_reset_postdata();

				return ob_get_clean();
			}

			?>

			<?php echo display_all_posts_with_details(array('posts_per_page' => 5)); ?>
		</div>
	</div>


	<?php get_template_part('templates/positions-before-content'); ?>

	<div class="<?php if (wp_traveler_is_active_sidebar("sidebar_right") && wp_traveler_is_active_sidebar("sidebar_left")) {
		echo ('col-lg-6 col-md-12 col-sm-12 col-xs-12');
	} else if (wp_traveler_is_active_sidebar("sidebar_right") || wp_traveler_is_active_sidebar("sidebar_left")) {
		echo ('col-lg-9 col-md-12 col-sm-12 col-xs-12');
	} else {
		echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12');
	} ?>  main_page">

		<?php wp_traveler_show_position_preview("main_content"); ?>


	</div>

	<?php get_template_part('templates/positions-after-content'); ?>

</div><!-- #main -->

<?php
get_footer();
?>