<?php
/**
   * The template for Content Link.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
   */
?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
<div id="post" class="<?php echo esc_attr(get_theme_mod("ospersonality_columns_posts"));?>">
<?php endif; ?>
<article class="content">
    <header class="entry-header">
        <h1 class="entry-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h1>

        <div class="entry-meta">
            <?php ospersonality_entry_date(); ?>
            <?php edit_post_link( __( 'Edit', 'ospersonality' ), '<span class="edit-link">', '</span>' ); ?>
        </div><!-- .entry-meta -->
    </header><!-- .entry-header -->

    <div class="entry-content">
        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'ospersonality' ) ); ?>
        <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'ospersonality' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
    </div><!-- .entry-content -->
    <footer class="entry-meta">
        <?php if ( is_single() ) :
            ospersonality_entry_meta();
        else :
            ospersonality_entry_date();
        endif;
        if ( get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
            <?php get_template_part( 'author-bio' ); ?>
        <?php endif; ?>
    </footer><!-- .entry-meta -->
</article><!-- #post -->
</div>
