<?php
/**
   * The template for Slider.
   *
   *
   * @package   ospersonality WordPress Theme
   * @copyright Copyright (C) 2016, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * ospersonality is distributed under the terms of the GNU GPL
*/
?>
<div id="slider" class="swiper-container">
    <div class="swiper-wrapper">
        <?php $osslider = new WP_Query (array(
            'post_type' => 'post',

            'posts_per_page' => 3,
        )); ?>
        <?php if($osslider -> have_posts() ): ?>
        <?php while($osslider -> have_posts() ) : $osslider -> the_post();
        $image_id = get_post_thumbnail_id();
        $image_url = wp_get_attachment_image_src($image_id,1600,800);
        $image_url = $image_url[0]; ?>
            <div class="swiper-slide" style="background: url(<?php echo "$image_url"; ?>)">
                <div class="slide-content">
                    <h1><?php echo get_the_title() ?></h1>
                    <section class="exerpt">
                    <?php ospersonality_excerpt(17); ?>
                    </section>
                    <section class="more">
                        <a class="more-button" href="<?php the_permalink(); ?>" rel="bookmark">
                            <?php if (get_theme_mod( 'ospersonality_more_button' )) :
                                    echo esc_attr(get_theme_mod( 'ospersonality_more_button' ));
                                else :
                                    _e('Read Now', 'ospersonality');
                                endif; ?></a>
                    </section>
                </div>
            </div>
        <?php wp_reset_query();?>
        <?php endwhile; ?>
        <?php else : ?>
            <h2><?php  _e('NO Slide', 'ospersonality'); ?></h2>
        <?php endif; ?>
        </div>
         <!-- Add Pagination -->
        <div class="swiper-pagination"></div>
        <!-- Add Arrows -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
</div>