<?php
/**
   * The template for Content Quote.
   *
   *
   * @package   serenity WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * serenity is distributed under the terms of the GNU GPL
*/
?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
<div id="post" class="<?php echo esc_attr(get_theme_mod("serenity_columns_posts"));?>">
<?php endif; ?>
<article class="content">
    <div class="entry-content">
        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'serenity' ) ); ?>
        <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'serenity' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
    </div><!-- .entry-content -->
    <footer class="entry-meta">
        <?php if ( is_single() ) :
        serenity_entry_meta();
          else :
          serenity_entry_date();
          endif;

         if ( comments_open() && ! is_single() ) : ?>
        <span class="comments-link">
        <i class="fa fa-commenting-o"></i>
            <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'serenity' ) . '</span>', __( 'One comment so far', 'serenity' ), __( 'View all % comments', 'serenity' ) ); ?>
        </span><!-- .comments-link -->
        <?php endif; // comments_open() ?>
        <?php edit_post_link( __( 'Edit', 'serenity' ), '<span class="edit-link">', '</span>' ); ?>
    </footer><!-- .entry-meta -->
</article><!-- #post -->
</div>