<?php
 /**
   * The Customize  Page.
   *
   *
   * @package   serenity WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license  www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * serenity is distributed under the terms of the GNU GPL
   */



function serenity_customize_register( $wp_customize ) {

//*************************************Customize Control*********************************************************
        class WP_Slider_Customize_Control extends WP_Customize_Control {
        public $type = 'range';

          public function render_content() {
          ?>

        <label>
                    <?php if ( ! empty( $this->label ) ) : ?>
                        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                    <?php endif;
                    if ( ! empty( $this->description ) ) : ?>
                        <span class="description customize-control-description"><?php echo $this->description; ?></span>
                    <?php endif; ?>
                    <form onsubmit="return false" oninput="level.value = flevel.valueAsNumber">
                      <input name="flevel" id="slider-range" type="range" min="0" max="100" step="1" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?> />
                      <output for="slider-range" name="level"><?php echo esc_attr( $this->value() ); ?></output>px
                    </form>
                </label>

          <?php
          }
    };

//************************************************Remove Standart Section****************************************

    $wp_customize->remove_section('colors');
    $wp_customize->remove_section('title_tagline');
    $wp_customize->remove_section('background_image');

//*************************************************General*******************************************************

    $wp_customize->add_section( 'serenity_general_settings' , array(
        'title'      => __( 'General Settings','serenity' ),
        'priority'   => 1,
        'capability'     => 'edit_theme_options',
        'description' => __('General settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
    ) );

//-----------------------------------Site Title------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'blogname',array(
                'label' => __('Yor site title','serenity'),
                'section'=> 'serenity_general_settings',
                'priority' => 1
                )
        ) );

//-----------------------------------Site Tagline------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize, 'blogdescription', array(
                'label' => __('Yor site tagline','serenity'),
                'section' => 'serenity_general_settings',
                'priority' => 2
                )
        ) );

//-----------------------------------Site icon------------------------------------------

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,'site_icon',array(
                'label' => __('Yor site icon','serenity'),
                'section' => 'serenity_general_settings',
                'priority'=>3
                )
        ) );

//-----------------------------------Background Colour------------------------------------------

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'background_color',array(
                'label' => __('Background Color','serenity'),
                'section' => 'serenity_general_settings',
                'priority'=>10
                )
        ) );

//-----------------------------------Background image------------------------------------------

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,'background_image',array(
                'label' => __('Background image','serenity'),
                'section' => 'serenity_general_settings',
                'priority'=>11
                )
        ) );

//-----------------------------------Background repeat------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_repeat',array(
                'label' => __('Background repeat','serenity'),
                'section' => 'serenity_general_settings',
                 'type' => 'radio',
                    'priority' => 12,
                    'choices' => array(
                        'no-repeat' => 'No Repeat',
                        'repeat' => 'Tile',
                        'repeat-x' => 'Tile Horizontally',
                        'repeat-y' => 'Tile Vertically',
                ))
        ) );

//-----------------------------------Background position------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_position_x',array(
                'label' => __('Background position','serenity'),
                'section' => 'serenity_general_settings',
                 'type' => 'radio',
                    'priority' => 13,
                    'choices' => array(
                        'left' => 'Left',
                        'center' => 'Center',
                        'right' => 'Right',
                ))
        ) );

//-----------------------------------Background attachment------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_attachment',array(
                'label'=>__('Background attachment','serenity'),
                'section'=>'serenity_general_settings',
                 'type'=>'radio',
                    'priority'=>14,
                    'choices'=>array(
                        'scroll'=>'Scroll',
                        'fixed'=>'Fixed',
                ))
        ) );

//-----------------------------------Colour Theme------------------------------------------

        $wp_customize->add_setting( 'serenity_theme_color', array(
            'default'=>'#4f4f4f',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
               $wp_customize, 'theme_color',array(
                     'label' => __('Theme Color','serenity'),
                     'section' => 'serenity_general_settings',
                     'settings' => 'serenity_theme_color',
                     'priority'=>20
                     )
             ) );

//---------------------------------Body font-------------------------------------------------

        $wp_customize->add_setting( 'serenity_body_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize, 'body_font',array(
                    'label' => __( 'Body Font','serenity' ),
                    'settings' => 'serenity_body_font',
                    'priority' => 30,
                    'section' =>'serenity_general_settings',
                    'type'=>'select',
                    'choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Dancing Script,cursive"=>"Dancing Script",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                        "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"))
                )
            );

//---------------------------------------Body Font Size-----------------------------------------------

        $wp_customize->add_setting( 'serenity_font_size' , array(
            'default'     => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize, 'font_size',array(
                 'label' => __('Body font size','serenity'),
                 'section' => 'serenity_general_settings',
                 'settings'=> 'serenity_font_size',
                 'priority'=>31
                 )
         ) );

//------------------------------------Body font color-------------------------------------------------

        $wp_customize->add_setting('serenity_font_color',array(
            'default'=>'#444444',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize, 'font_color',array(
                'label'=>__('Body font color','serenity'),
                'section'=>'serenity_general_settings',
                'settings'=>'serenity_font_color',
                'priority'=>32
             )
         ) );

//----------------------------------------Body links font----------------------------------------------

        $wp_customize->add_setting( 'serenity_link_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' =>'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'link_font',array(
                'label'=>__( 'Body links font','serenity' ),
                'settings'=> 'serenity_link_font',
                'priority'=>40,
                'section'=> 'serenity_general_settings',
                'type'=>'select',
                'choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"))
            )
         );
//------------------------------------Read more button text-------------------------------------------------

        $wp_customize->add_setting('serenity_more_button',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'more_button',array(
                'label'=>__('Replace text in button "Read Now"','serenity'),
                'settings' => 'serenity_more_button',
                'section' => 'serenity_general_settings',
                'priority' => 41,
            )
        ) );
//--------------------------------------Favicon-------------------------------------------------------------

        $wp_customize->add_setting('serenity_favicon_img',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize, 'favicon_img',array(
                    'label'=>__('A favicon is a 16x16 pixel icon that represents your site, to a .ico image that you want to use as the image','serenity'),
                    'settings'=> 'serenity_favicon_img',
                    'section'=> 'serenity_general_settings',
                    'priority'=>50
                )
          ) );

//------------------------------------------Custom CSS----------------------------------------------

        $wp_customize->add_setting('serenity_custom_css',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'custom_css',array(
                'label' => __('Want to add any custom CSS code? Put in here, and the rest is taken care of. This overrides any other stylesheets. eg: a.button{color:green}','serenity'),
                'settings' => 'serenity_custom_css',
                'section' => 'serenity_general_settings',
                'type' => 'textarea',
                'priority' => 60,
            )
        ) );

//------------------------------------Googleanalytics-------------------------------------------------

        $wp_customize->add_setting('serenity_add_googleanalytics',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'add_googleanalytics',array(
                'label'=>__('You can paste your Google Analytics or other tracking code in this box. This will be automatically added to the footer.','serenity'),
                'settings' => 'serenity_add_googleanalytics',
                'section' => 'serenity_general_settings',
                'type' => 'textarea',
                'priority' => 70,
            )
        ) );

//*************************************************Header*******************************************************

     $wp_customize->add_panel( 'serenity_header' , array(
        'title'      => __( 'Header','serenity' ),
        'priority'   => 20,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
         'description' => __('Header settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
    ) );

        $wp_customize->add_section( 'serenity_header_settings' , array(
            'title'      => __( 'Header Settings','serenity' ),
            'priority'   => 1,
            'panel' => 'serenity_header',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Header settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
        ) );

        $wp_customize->add_section( 'header_image' , array(
            'title'      => __( 'Header Image','serenity' ),
            'priority'   => 2,
            'panel' => 'serenity_header',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Header Image for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
        ) );

//------------------------------------------------Header Layout------------------------------------

        $wp_customize->add_setting( 'serenity_header_layout_home',array(
            'default'=>'header',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage', ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'header_layout_home',array(
                'label'=>__('Header layout for Home page','serenity'),
                'settings'=>'serenity_header_layout_home',
                'section'=>'serenity_header_settings',
                'type'=>'radio',
                'priority'=>10,
                'choices'=>array(
                    'header'=>'Full Header',
                    'header-main'=>'250px height Header',
                )
            )
        ) );

        $wp_customize->add_setting( 'serenity_header_layout_other',array(
            'default'=>'main',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'header_layout_other',array(
                'label'=>__('Header layout for Other page','serenity'),
                'settings'=>'serenity_header_layout_other',
                'section'=>'serenity_header_settings',
                'type'=>'radio',
                'priority'=>11,
                'choices'=>array(
                    'header'=>'Full Header',
                    'main'=>'250px height Header',
                )
            )
        ) );

//------------------------------------------------Logo------------------------------------

        $wp_customize->add_setting( 'serenity_logo_img',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,'logo_img',array(
                    'label'=>__('Upload logo for your site','serenity'),
                    'settings'=>'serenity_logo_img',
                    'section'=>'serenity_header_settings',
                    'priority'=>20 )
          ) );

//-----------------------------------------Logo Link-------------------------------------

        $wp_customize->add_setting( 'serenity_logo_link',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
                'transport'=>'postMessage',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'logo_link',array(
                'label'=>__('Insert your logo link','serenity'),
                'settings'=>'serenity_logo_link',
                'section'=>'serenity_header_settings',
                'priority'=>30 )
          ) );

//------------------------------------Modal button text-------------------------------------------------

        $wp_customize->add_setting('serenity_button_text',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'button_text',array(
                'label'=>__('Replace text in header button','serenity'),
                'settings' => 'serenity_button_text',
                'section' => 'serenity_header_settings',
                'priority' => 40,
            )
        ) );

//------------------------------------Modal header text-------------------------------------------------

        $wp_customize->add_setting('serenity_modal_text',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'modal_text',array(
                'label'=>__('You can paste your text to modal in header','serenity'),
                'settings' => 'serenity_modal_text',
                'section' => 'serenity_header_settings',
                'type' => 'textarea',
                'priority' => 41,
            )
        ) );


//***********************************HOME PAGE SETTINGS**********************************************

    $wp_customize->add_section( 'serenity_home_settings',array(
        'title'=>__('Home page settings','serenity'),
        'priority'=>21,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Home page settings <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
      ) );

//----------------------------Home page width-------------------------

        $wp_customize->add_setting( 'serenity_home_width' , array(
            'default'     => 'full',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_width',array(
                'label'=>__('Home page width full or fixed (1170px)','serenity'),
                'settings'=> 'serenity_home_width',
                'section'=> 'serenity_home_settings',
                'type'=>'radio',
                'priority'=>1,
                'choices'=>array(
                    'full'=>'full',
                    'container'=>'fixed (1170px)'
                ))
        ) );

//----------------------------Home section blog-------------------------------------------------------------------------------

//----------------------------Home blog title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'serenity_home_blog_title' , array(
            'default'     => __('Your personal Blog', 'serenity'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_blog_title',array(
                'label'=>__('Home page blog title','serenity'),
                'settings'=> 'serenity_home_blog_title',
                'section'=> 'serenity_home_settings',
                'priority'=>20,
               )
        ) );

//----------------------------Home section shop-------------------------------------------------------------------------------
//----------------------------Home shop section show-------------------------

        $wp_customize->add_setting( 'serenity_shop_show' , array(
            'default'     => 'display:none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'shop_show',array(
                'label'=>__('Shop section on home page show or hide','serenity'),
                'settings'=> 'serenity_shop_show',
                'section'=> 'serenity_home_settings',
                'type'=>'radio',
                'priority'=>30,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );

//----------------------------Home shop title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'serenity_home_shop_title' , array(
            'default'     => __('Our Store', 'serenity'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_shop_title',array(
                'label' => __('Home page shop section title','serenity'),
                'settings' => 'serenity_home_shop_title',
                'section' => 'serenity_home_settings',
                'priority' => 31,
               )
        ) );


//----------------------------Home shop section show products-------------------------

        $wp_customize->add_setting( 'serenity_products_show' , array(
            'default'     => '8',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'products_show',array(
                'label'=>__('Shop section show products','serenity'),
                'settings'=> 'serenity_products_show',
                'section'=> 'serenity_home_settings',
                'priority'=>33,
               )
        ) );

//----------------------------Home shop section products column-------------------------

        $wp_customize->add_setting( 'serenity_products_column' , array(
            'default'     => 'col-lg-3 col-md-3 col-sm-3',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'products_column',array(
                'label'=>__('Products column','serenity'),
                'settings'=> 'serenity_products_column',
                'section'=> 'serenity_home_settings',
                'type'=>'select',
                'priority'=>34,
                'choices'=>array(
                    'col-lg-6 col-md-6 col-sm-6'=>'2',
                    'col-lg-4 col-md-4 col-sm-4'=>'3',
                    'col-lg-3 col-md-3 col-sm-3'=>'4',
                    'col-lg-2 col-md-2 col-sm-2'=>'6',
                ))
        ) );
//----------------------------Home content section show-------------------------

        $wp_customize->add_setting( 'serenity_content_show' , array(
            'default'     => 'display:block',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'content_show',array(
                'label'=>__('Content section on home page show or hide','serenity'),
                'settings'=> 'serenity_content_show',
                'section'=> 'serenity_home_settings',
                'type'=>'radio',
                'priority'=>35,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );
//----------------------------Home any section show-------------------------

        $wp_customize->add_setting( 'serenity_any_section_show' , array(
            'default'     => 'display:none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_show',array(
                'label'=>__('Any section on home page show or hide','serenity'),
                'settings'=> 'serenity_any_section_show',
                'section'=> 'serenity_home_settings',
                'type'=>'radio',
                'priority'=>40,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );

//----------------------------Home any title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'serenity_any_section_title' , array(
            'default'     => __('Testimonial', 'serenity'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_title',array(
                'label'=>__('Home page any section title','serenity'),
                'settings'=> 'serenity_any_section_title',
                'section'=> 'serenity_home_settings',
                'priority'=>41,
               )
        ) );

//----------------------------Home any title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'serenity_any_shortcode' , array(
            'default'     => '[testimonial_sc  id="213" ]',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_shortcode',array(
                'label'=>__('Home page any section insert shortcode','serenity'),
                'settings'=> 'serenity_any_shortcode',
                'section'=> 'serenity_home_settings',
                'priority'=>43,
               )
        ) );

//***********************************Social icons**********************************************

    $wp_customize->add_section( 'serenity_social_settings',array(
        'title'=>__('Social Links','serenity'),
        'priority'=>30,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
         'description' => __('Sociasl Icons for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
      ) );

//----------------------------Social Icons Font Size-------------------------

        $wp_customize->add_setting( 'serenity_soc_size' , array(
            'default'     => '17',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'serenity_soc_size',array(
                   'label'=>__('Social icon size','serenity'),
                   'section'=> 'serenity_social_settings',
                   'settings'=> 'serenity_soc_size',
                   'priority'=>1
                   )
           ) );

//------------------------Socil Icons Color------------------------------------

        $wp_customize->add_setting( 'serenity_soc_color',array(
            'default'=>'#F7484E',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color',array(
                'label'=>__('Social Links Color','serenity'),
                'settings'=> 'serenity_soc_color',
                'section'=> 'serenity_social_settings',
                'priority'=>2
            )
      ) );

//-----------------------Social Icons Color Hover------------------------------

        $wp_customize->add_setting( 'serenity_soc_color_hover',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color_hover',array(
                'label'=>__('Social Links Color Hover','serenity'),
                'settings'=> 'serenity_soc_color_hover',
                'section'=> 'serenity_social_settings',
                'priority'=>3
            )
      ) );

//------------------Facebook-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_facebook',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_facebook',array(
                'label'=>__('Facebook','serenity'),
                'settings'=> 'serenity_soc_facebook',
                'section'=> 'serenity_social_settings',
                'priority'=>4
            )
      ) );

//------------------Twitter-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_twitter',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_twitter',array(
                'label'=>__('Twitter','serenity'),
                'settings'=> 'serenity_soc_twitter',
                'section'=> 'serenity_social_settings',
                'priority'=>5
            )
      ) );

//------------------Skype-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_skype',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_skype',array(
                'label'=>__('Skype','serenity'),
                'settings'=> 'serenity_soc_skype',
                'section'=> 'serenity_social_settings',
                'priority'=>6
            )
      ) );

//------------------Soundcloud-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_soundcloud',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_soundcloud',array(
                    'label'=>__('Soundcloud','serenity'),
                    'settings'=> 'serenity_soc_soundcloud',
                    'section'=> 'serenity_social_settings',
                    'priority'=>7
                )
          ) );

//------------------Dribbble-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_dribbble',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_dribbble',array(
                'label'=>__('Dribbble','serenity'),
                'settings'=> 'serenity_soc_dribbble',
                'section'=> 'serenity_social_settings',
                'priority'=>8
            )
      ) );

//-----------------Google-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_google',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_google',array(
                'label'=>__('Google','serenity'),
                'settings'=> 'serenity_soc_google',
                'section'=> 'serenity_social_settings',
                'priority'=>9
            )
      ) );

//-----------------Vimeo-----------------------------------------

        $wp_customize->add_setting('serenity_soc_vimeo',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_vimeo',array(
                    'label'=>__('Vimeo','serenity'),
                    'settings'=> 'serenity_soc_vimeo',
                    'section'=> 'serenity_social_settings',
                    'priority'=>10
                )
          ) );

//-----------------Flickr-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_flickr',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_flickr',array(
                'label'=>__('Flickr','serenity'),
                'settings'=> 'serenity_soc_flickr',
                'section'=> 'serenity_social_settings',
                'priority'=>11
            )
      ) );

//-----------------Youtube Play-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_youtube_play',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_youtube_play',array(
                    'label'=>__('Youtube','serenity'),
                    'settings'=> 'serenity_soc_youtube_play',
                    'section'=> 'serenity_social_settings',
                    'priority'=>12
                )
          ) );

//-----------------Instagram-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_instagram',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_instagram',array(
                    'label'=>__('Instagram','serenity'),
                    'settings'=> 'serenity_soc_instagram',
                    'section'=> 'serenity_social_settings',
                    'priority'=>13
                )
          ) );

//-----------------Linkedin-----------------------------------------

        $wp_customize->add_setting( 'serenity_soc_linkedin',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_linkedin',array(
                'label'=>__('Linkedin','serenity'),
                'settings'=> 'serenity_soc_linkedin',
                'section'=> 'serenity_social_settings',
                'priority'=>14
            )
      ) );

//*********************************************Typography************************************************

    $wp_customize->add_section( 'serenity_typography',array(
        'title'=>__('Typography','serenity'),
        'priority'=>40,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Typography settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
      ) );

//-------------------------------H1----------------------------------

        $wp_customize->add_setting( 'serenity_h1_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
              $wp_customize,'h1_font',array(
                'label'=>__( 'h1','serenity' ),
                'settings'=> 'serenity_h1_font',
                'priority'=>1,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('serenity_h1_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h1_color',array(
                 'label'=>__('h1 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h1_color',
                 'priority'=>2
                 )
         ) );

//-----------------------------H2----------------------------------------

        $wp_customize->add_setting( 'serenity_h2_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h2_font',array(
                'label'=>__( 'h2','serenity' ),
                'settings'=> 'serenity_h2_font',
                'priority'=>20,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('serenity_h2_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h2_color',array(
                 'label'=>__('h2 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h2_color',
                 'priority'=>21
                 )
         ) );

//---------------------------H3----------------------------------------

        $wp_customize->add_setting( 'serenity_h3_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h3_font',array(
                'label'=>__( 'h3','serenity' ),
                'settings'=> 'serenity_h3_font',
                'priority'=>30,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('serenity_h3_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h3_color',array(
                 'label'=>__('h3 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h3_color',
                 'priority'=>31
                 )
         ) );

//-----------------------------------H4----------------------------------

        $wp_customize->add_setting( 'serenity_h4_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h4_font',array(
                'label'=>__( 'h4','serenity' ),
                'settings'=> 'serenity_h4_font',
                'priority'=>40,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('serenity_h4_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h4_color',array(
                 'label'=>__('h4 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h4_color',
                 'priority'=>41
                 )
         ) );

//--------------------------------------H5------------------------------------------

        $wp_customize->add_setting( 'serenity_h5_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h5_font',array(
                'label'=>__( 'h5','serenity' ),
                'settings'=> 'serenity_h5_font',
                'priority'=>50,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('serenity_h5_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h5_color',array(
                 'label'=>__('h5 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h5_color',
                 'priority'=>51
                 )
         ) );

//------------------------------H6---------------------------------------

        $wp_customize->add_setting( 'serenity_h6_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h6_font',array(
                'label'=>__( 'h6','serenity' ),
                'settings'=> 'serenity_h6_font',
                'priority'=>60,
                'section'=> 'serenity_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('serenity_h6_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h6_color',array(
                 'label'=>__('h6 color','serenity'),
                 'section'=>'serenity_typography',
                 'settings'=>'serenity_h6_color',
                 'priority'=>61
                 )
         ) );

//*******************************************Menu Settings*********************************************************

         $wp_customize->add_section( 'serenity_menu_settings' , array(
            'title'      => __( 'Menu Settings','serenity' ),
            'priority'   =>1,
            'panel' => 'nav_menus',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Menu settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
        ) );

//-----------------------------------Menu  Font------------------------------
        $wp_customize->add_setting( 'serenity_menu_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'menu_font',array(
                    'label'=>__( 'Menu Font','serenity' ),
                    'settings'=> 'serenity_menu_font',
                    'priority'=>1,
                    'section'=> 'serenity_menu_settings',
                    'type'=>'select','choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Dancing Script,cursive"=>"Dancing Script",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                      "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"
                    ))
                )
            );

//--------------------------------Menu Font Size------------------------------------

        $wp_customize->add_setting( 'serenity_menu_font_size' , array(
            'default'     => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_font_size',array(
                 'label'=>__('Font size','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_menu_font_size',
                 'priority'=>20
                 )
         ) );



   //--------------------------------Menu Item margin------------------------------------

        $wp_customize->add_setting( 'serenity_menu_margin' , array(
            'default'     => '5',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_margin',array(
                 'label'=>__('Margin menu item ','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_menu_margin',
                 'priority'=>21
                 )
         ) );

//----------------------------Menu Font Color-----------------------------------

        $wp_customize->add_setting( 'serenity_menu_color',array(
            'default'=>'#333333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_color',array(
                 'label'=>__('Font Color','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_menu_color',
                 'priority'=>30
                 )
         ) );

//--------------------------Menu Font Color Hover-----------------------------

         $wp_customize->add_setting( 'serenity_menu_hover_color',array(
                'default'=>'#666',
                'sanitize_callback' => 'sanitize_hex_color',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_hover_color',array(
                 'label'=>__('Hover Color','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_menu_hover_color',
                 'priority'=>31
                 )
      ) );



//----------------------------SUB Menu Font Color-----------------------------------

        $wp_customize->add_setting( 'serenity_submenu_color',array(
            'default'=>'#444',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_color',array(
                 'label'=>__('Sub menu font Color','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_submenu_color',
                 'priority'=>32
                 )
         ) );

//--------------------------SUB Menu Font Color Hover-----------------------------

         $wp_customize->add_setting( 'serenity_submenu_hover_color',array(
            'default'=>'#0a0a0a',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_hover_color',array(
                 'label'=>__('Sub menu hover color','serenity'),
                 'section'=> 'serenity_menu_settings',
                 'settings'=> 'serenity_submenu_hover_color',
                 'priority'=>33
                 )
      ) );
//----------------------Menu link underline-----------------------------------

        $wp_customize->add_setting( 'serenity_menu_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline',array(
                'label'=>__('Menu link underline','serenity'),
                'settings'=> 'serenity_menu_underline',
                'section'=> 'serenity_menu_settings',
                'type'=>'radio',
                'priority'=>50,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
        ) );

//----------------------Menu Link underline hover-----------------------------

         $wp_customize->add_setting( 'serenity_menu_underline_hover',array(
            'default'=>'underline',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline_hover',array(
                'label'=>__('links underline hover','serenity'),
                'settings'=> 'serenity_menu_underline_hover',
                'section'=> 'serenity_menu_settings',
                'type'=>'radio',
                'priority'=>60,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
      ) );

//******************************************Footer Settings**********************************************

     $wp_customize->add_section( 'serenity_footer_settings' , array(
          'title'      => __( 'Footer Settings','serenity' ),
          'priority'   => 60,
          'type' => 'theme_mod',
          'capability' => 'edit_theme_options',
          'description' => __('Footer settings for <b style="color:#E9323B">"serenity"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'serenity'),
    ) );

//-------------------------------------Footer Background color-----------------------------

        $wp_customize->add_setting( 'serenity_footer_background',array(
            'default'=>'#222222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

      $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize, 'footer_background',array(
                'label'=>__('Footer background color','serenity'),
                'section'=> 'serenity_footer_settings',
                'settings'=> 'serenity_footer_background',
                'priority'=>1
            )
        ) );

//-------------------------------------Copyright text-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_text' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_text',array(
                   'label'=>__('Copyright text','serenity'),
                   'section'=>'serenity_footer_settings',
                   'settings'=>'serenity_copyright_text',
                   'priority'=>10
                   )
           ) );

//-------------------------------------Copyright link-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_link' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_link',array(
                   'label'=>__('Copyright link','serenity'),
                   'section'=> 'serenity_footer_settings',
                   'settings'=> 'serenity_copyright_link',
                   'priority'=>11
                   )
           ) );

//-------------------------------------Copyright font-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_font',array(
                'label'=>__( 'Copyright font','serenity' ),
                'settings'=> 'serenity_copyright_font',
                'priority'=>12,
                'section'=> 'serenity_footer_settings',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

//-------------------------------------Copyright font size-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_font_size' , array(
            'default'     => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'copyright_font_size',array(
                'label'=>__('Copyright font size','serenity'),
                'section'=> 'serenity_footer_settings',
                'settings'=> 'serenity_copyright_font_size',
                'priority'=>13
                )
        ) );

//-------------------------------------Copyright font color-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

      $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_color',array(
                'label'=>__('Copyright font color','serenity'),
                'section'=> 'serenity_footer_settings',
                'settings'=> 'serenity_copyright_color',
                'priority'=>14
            )
        ) );

//-------------------------------------Copyright font color hover-----------------------------

       $wp_customize->add_setting( 'serenity_copyright_hover_color',array(
            'default'=>'#12abff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_hover_color',array(
                'label'=>__('Copyright font color hover','serenity'),
                'section'=> 'serenity_footer_settings',
                'settings'=> 'serenity_copyright_hover_color',
                'priority'=>15
            )
        ) );

//-------------------------------------Copyright link Underline-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline',array(
                'label'=>__('Copyright link underline','serenity'),
                'settings'=> 'serenity_copyright_underline',
                'section'=> 'serenity_footer_settings',
                'type'=>'radio',
                'priority'=>16,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );

//-------------------------------------Copyright link Underline hover-----------------------------

        $wp_customize->add_setting( 'serenity_copyright_underline_hover',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline_hover',array(
                'label'=>__('Copyright link underline hover','serenity'),
                'settings'=> 'serenity_copyright_underline_hover',
                'section'=> 'serenity_footer_settings',
                'type'=>'radio',
                'priority'=>17,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );


}
add_action( 'customize_register', 'serenity_customize_register' );