<?php
 /**
   * The template for Content Aside page.
   *
   *
   * @package   cuisine WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * cuisine is distributed under the terms of the GNU GPL
   */
   ?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
<div id="post" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
<?php endif; ?>
    <article class="content-aside">
        <div class="entry-content">
            <?php if ( is_single() ) : ?>
                <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'cuisine' ) ); ?>
                <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'cuisine' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
            <?php else : ?>
                <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'cuisine' ) ); ?>
            <?php endif; // is_single() ?>
        </div><!-- .entry-content -->
        <footer class="entry-meta">
            <?php if ( is_single() ) : ?>
                <?php cuisine_entry_meta(); ?>
                <?php //cuisine_entry_date(); ?>
                <?php edit_post_link( __( 'Edit', 'cuisine' ), '<span class="edit-link">', '</span>' ); ?>
                    <?php if ( get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
                        <?php get_template_part( 'author-bio' ); ?>
                    <?php endif; ?>
            <?php else : ?>
                <?php cuisine_entry_date(); ?>
            <?php endif;
             if ( is_single() && comments_open() ) : ?>
                <span class="comments-link">
                <i class="fa fa-commenting-o"></i>
                    <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'cuisine' ) . '</span>', __( 'One comment so far', 'cuisine' ), __( 'View all % comments', 'cuisine' ) ); ?>
                </span><!-- .comments-link -->
            <?php endif; // comments_open() ?>
        </footer><!-- .entry-meta -->
    </article><!-- #post -->
</div>
