<?php
/**
    * Template Name: Team
    * The template for team page.
    *
    *
    * @package   cuisine WordPress Theme
    * @copyright Copyright (C) 2015, OrdaSoft
    * @license   http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
    * @author     AUTHOR <www.ordasoft.com>
    * cuisine is distributed under the terms of the GNU GPL
*/
  $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}


if ((get_theme_mod('cuisine_header_layout_other')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('cuisine_header_layout_other')) === 'header-main' ) :
    get_header('main');
else :
    get_header('main');
endif;
?>
<div id="main" class="site-main">
        <div id="content" class="site-content">
        <div id="team">
                <div class="row">
                <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
                <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <article id="sidebar">
                        <?php  dynamic_sidebar('sidebar_left'); ?>
                    </article>
                </div>
                <?php endif; ?>

                <div class="<?php if($sidebar_right && $sidebar_left){
                        echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        }
                        else if($sidebar_right || $sidebar_left){
                        echo ('col-lg-9 col-md-9 col-sm-9 col-xs-12');
                        }
                        else {
                        echo('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                        } ?>">
                     <?php the_title( '<h2 class="page-title">', '</h2>' ); ?>
                    <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                        $published_posts = wp_count_posts()->publish;
                    $args =  (array(
                            'post_status' => 'publish',
                            'post_type' => 'team',
                            'paged'=>$paged,
                            'posts_per_page'=>-1,
                        ));
                        $team = null;
                        $team = new WP_Query($args);
                         if( $team->have_posts() ) {
                        $col = 0;
                        while ($team->have_posts()) : $team->the_post();
                         if($col % 3 == 0) { ?>
                          <div class="row">
                          <?php } ?>
                            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="team-content">
                                <?php the_post_thumbnail(); ?>
                                <p><?php the_excerpt(); ?></p>
                                <h3 class="entry-title">
                                    <?php the_title(); ?>
                                </h3>
                            </div>
                            </div>
                            <?php $col++;
                              if($col != 0 && $col % 3 == 0) { ?>
                        </div><!--/.row-->
                        <?php } ?>
                          <?php endwhile; } ?>
                          <?php wp_reset_query();?>
                        </div>
                <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
                    <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <article id="sidebar">
                        <?php dynamic_sidebar('sidebar_right'); ?>
                    </article>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div><!-- #main -->
<?php get_footer(); ?>