<?php
/**
 * bpm128 functions and definitions
 * 
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 */

/**
 * bpm128 only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7-alpha', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

require_once get_parent_theme_file_path('/plg/class-tgm-plugin-activation.php');

add_action( 'tgmpa_register', 'bpm128_register_required_plugins' );


function bpm128_register_required_plugins() {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        // This is an example of how to include a plugin bundled with a theme.
        array(
            'name'               => 'Contact Form 7', // The plugin name.
            'slug'               => 'contact-form-7', // The plugin slug (typically the folder name).
            'source'             => get_theme_file_uri('/plg/plugins/contact-form-7.zip'), // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
            'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
            'external_url'       => '', // If set, overrides default API URL and points to an external URL.
            'is_callable'        => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
        ),

        array(
            'name'               => 'Display Widgets',
            'slug'               => 'display-widgets',
            'source'             => get_theme_file_uri('/plg/plugins/display-widgets.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'Newsletter widget',
            'slug'               => 'newsletter-widget',
            'source'             => get_theme_file_uri('/plg/plugins/newsletter-widget.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'Responsive Lightbox',
            'slug'               => 'responsive-lightbox',
            'source'             => get_theme_file_uri('/plg/plugins/responsive-lightbox.zip'), 
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'SyntaxHighlighter Evolved',
            'slug'               => 'syntaxhighlighter',
            'source'             => get_theme_file_uri('/plg/plugins/syntaxhighlighter.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),


        array(
            'name'               => 'WooCommerce',
            'slug'               => 'woocommerce',
            'source'             => get_theme_file_uri('/plg/plugins/woocommerce.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'Woocommerce products filter',
            'slug'               => 'woocommerce-products-filter',
            'source'             => get_theme_file_uri('/plg/plugins/woocommerce-products-filter.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'WP Google Maps',
            'slug'               => 'wp-google-maps',
            'source'             => get_theme_file_uri('/plg/plugins/wp-google-maps.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'Wordpress importer',
            'slug'               => 'wordpress-importer',
            'source'             => get_theme_file_uri('/plg/plugins/wordpress-importer.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),

        array(
            'name'               => 'Widget Importer & Exporter',
            'slug'               => 'widget-importer-exporter',
            'source'             => get_theme_file_uri('/plg/plugins/widget-importer-exporter.zip'),
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
            'is_callable'        => '',
        ),


    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
        'id'           => 'bpm128',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );
}



/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function bpm128_after_setup() {


	load_theme_textdomain( 'bpm128' );

	add_theme_support( 'automatic-feed-links' );

	add_theme_support( 'title-tag' );

	add_theme_support( 'post-thumbnails' );

	add_image_size( 'bpm128-featured-image', 2000, 1200, true );

	add_image_size( 'bpm128-thumbnail-avatar', 100, 100, true );

	add_theme_support( 'custom-background' );

	add_theme_support( 'woocommerce' );

	register_nav_menus( array(
		'main'    => __( 'Main Menu', 'bpm128' ),
		'social' => __( 'Social Links Menu', 'bpm128' ),
	) );

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		//'gallery',
		'caption',
	) );

	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
        'status',
        'chat',
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
	) );

	add_theme_support( 'starter-content', array(
	     'widgets' => array(
		   'footer-sidebar-1' => array(
		    'find_us_text' => array( 'text', array(
		     'title' => _x( 'Find Us', 'bpm128' ),
		     'text' => join( '', array(
		      '<p><strong>' . _x( 'Adress', 'bpm128' ) . '</strong><br />',
		      _x( '123 Main Street', 'bpm128' ) . '<br />' . _x( 'New York, NY 10001', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'Hours', 'bpm128' ) . '</strong><br />',
		      _x( 'Monday', 'bpm128' ) . '<br />' . _x( 'Saturday &amp; Sunday: 11:00AM&ndash;3:00PM', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'Email', 'bpm128' ) . '</strong><br />',
		      _x( 'bpm128@gmail.com', 'bpm128' ) . '<br />' . _x( 'bpm128os@gmail.com', 'bpm128' ) . '</p>'
		     ) ),
		    ) ),
		   ),

		   'footer-sidebar-2' => array(
		    'about_us_text' => array( 'text', array(
		     'title' => _x( 'About Us', 'bpm128' ),
		     'text' => join( '', array(
		      '<p><strong>' . _x( 'Color design', 'bpm128' ) . '</strong><br />',
		      _x( 'Lorem ipsum', 'bpm128' ) . '<br />' . _x( 'Dolor sit amet', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'Production speed', 'bpm128' ) . '</strong><br />',
		      _x( 'Ut enim ad minim', 'bpm128' ) . '<br />' . _x( 'Incididunt ut labore et dolore', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'New standard', 'bpm128' ) . '</strong><br />',
		      _x( 'Lorem ipsum', 'bpm128' ) . '<br />' . _x( 'Lorem ipsum dolor sit amet, consectetur', 'bpm128' ) . '</p>'
		     ) ),
		    ) ),
		   ),

		   'footer-sidebar-3' => array(
		    'text_company' => array( 'text', array(
		     'title' => _x( 'Company', 'bpm128' ),
		     'text' => join( '', array(
		      '<p><strong>' . _x( 'Directory', 'bpm128' ) . '</strong><br />',
		      _x( 'Lorem ipsum dolor', 'bpm128' ) . '<br />' . _x( 'Lorem ipsum dolor sit amet, consectetur adipiscin', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'Jobs', 'bpm128' ) . '</strong><br />',
		      _x( 'Duis aute irure', 'bpm128' ) . '<br />' . _x( 'Excepteur sint occaecat cupidatat', 'bpm128' ) . '</p>',
		      '<p><strong>' . _x( 'Support', 'bpm128' ) . '</strong><br />',
		      _x( 'Kharkov, Ukraine', 'bpm128' ) . '<br />' . _x( 'OSbpm128@gmail.com', 'bpm128' ) . '</p>'
		     ) ),
		    ) ),
		   ),

		   'footer-sidebar-4' => array(
		   	'search' => array( 'text', array(
		     'title' => _x( 'Search', 'bpm128' ),
		    ) ),
		   	'recent-posts' => array( 'text', array(
		     'title' => _x( 'Recent posts', 'bpm128' ),
		    ) ),
		   ),
		),
	    'attachments' => array(
			'image-home' => array(
				'file' => 'assets/images/home.jpg',
			),
			'image-blog' => array(
				'file' => 'assets/images/blog.jpg',
			),
			'image-services' => array(
				'file' => 'assets/images/services.jpg',
			),
			'image-store' => array(
				'file' => 'assets/images/store.jpg',
			),
			'image-gallery' => array(
				'file' => 'assets/images/gallery.jpg',
			),
			'image-about' => array(
				'file' => 'assets/images/about.jpg',
			),
			'image-find' => array(
				'file' => 'assets/images/find-us.jpg',
			),
		),
		'posts' => array(
			'home'=> array(
				'post_type' => 'page',
				'post_title' => _x( 'Home', 'bpm128' ),
				'post_content' => join( '', array(
					'<h3>' . _x( 'Welcome to new site!', 'bpm128' ) . '</h3>', 
					'<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.<p>',
				) ),
				'thumbnail' => '{{image-home}}',
			),
			'about-us' => array(
			    'post_type' => 'page',
			    'post_title' => _x( 'About Us', 'bpm128' ),
			    'post_content' => join( '', array(
			     	'<h3>' . _x( 'About us information', 'bpm128' ) . '</h3>', 
			     	'<p>Welcome to  responsive WordPress theme for your self-hosted WordPress websites. Discover our beautiful, functional theme with unique design, free support, demo installer and much more. We create amazing, feature-rich, and easy-to-use WordPress theme with Quickstart. Many widgets and demo content in just a few minutes and in final you get full WordPress website. Create amazing WordPress websites with us.<p>',
			    ) ),
			    'thumbnail' => '{{image-about}}',
			),

			'store' => array(
			  	'post_type' => 'page',
			  	'post_title' => _x( 'Store', 'bpm128' ),
			  	'post_content' => join( '', array(
			     	'<h3>' . _x( 'Your personal store', 'bpm128' ) . '</h3>', 
			     	'<p>This section is intended to display the store. Install all plugins that offers theme. Added multiple products or import xml file. Go to the appropriate section of the title page and delete the text. Click update.<p>',
			    ) ),
			    'thumbnail' => '{{image-store}}',
			),


			'gallery' => array(
			  	'post_type' => 'page',
			  	'post_title' => _x( 'Gallery', 'bpm128' ),
			  	'post_content' => join( '', array(
			     	'<h3>' . _x( 'Your gallery page', 'bpm128' ) . '</h3>', 
			     	'<p>This section is intended to display the gallery. Install all plugins that offers theme. Added your images or import xml file. Go to the appropriate section of the title page and delete the text. Click update.<p>',
			    ) ),
			    'thumbnail' => '{{image-gallery}}',
			),

			'find-us' => array(
			  	'post_type' => 'page',
			  	'post_title' => _x( 'Find Us', 'bpm128' ),
			  	'post_content' => join( '', array(
			     	'<h3>' . _x( 'Find us on map', 'bpm128' ) . '</h3>', 
			     	'<p>This section is intended to display the map. Install all plugins that offers theme. Added your information or import xml file. Go to the appropriate section of the title page and delete the text. Click update.<p>',
			    ) ),
			    'thumbnail' => '{{image-find}}',
			),
			'services' => array(
				'post_type' => 'page',
				'post_title' => _x( 'Our services', 'bpm128' ),
				'post_content' => join( '', array(
						'<h3>' . _x( 'We are creative services', 'bpm128' ) . '</h3>',
						'<div class="row">' . 
						'<div class="col-lg-4"><h4>' . _x( 'Responsive layout', 'bpm128' ) . '</h4><i class="fa fa-arrows-alt"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'<div class="col-lg-4"><h4>' . _x( 'High-tech development', 'bpm128' ) . '</h4><i class="fa fa-superpowers"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'<div class="col-lg-4"><h4>' . _x( 'New standart', 'bpm128' ) . '</h4><i class="fa fa-barcode"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'</div>',
						'<div class="row">',
						'<div class="col-lg-4"><h4>' . _x( 'Quality Control', 'bpm128' ) . '</h4><i class="fa fa-check-square-o"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'<div class="col-lg-4"><h4>' . _x( 'Instant', 'bpm128' ) . '</h4><i class="fa fa-bolt"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'<div class="col-lg-4"><h4>' . _x( 'Style Designer', 'bpm128' ) . '</h4><i class="fa fa-paint-brush"></i><p>Lorem ipsum dolor sit amet, ne vix affert volutpat.</p></div>',
						'</div>'
					) ),
				'thumbnail' => '{{image-services}}',
			),
			'blog' => array(
				'thumbnail' => '{{image-blog}}',
			),
		),

		'options' => array(
			'show_on_front' => 'page',
			'page_on_front' => '{{home}}',
			'page_for_posts' => '{{blog}}',
		),

		'theme_mods' => array(
			'panel_1' => '{{blog}}',
			'panel_2' => '{{servises}}',
			'panel_3' => '{{store}}',
			'panel_4' => '{{gallery}}',
			'panel_5' => '{{about-us}}',
			'panel_6' => '{{find-us}}',
		),

		'nav_menus' => array(
			'top' => array(
				'name' => __( 'Top Menu', 'bpm128' ),
				'items' => array(
					'link_home' => array(
						'type' => 'custom',
						'title' => _x( 'Home', 'bpm128' ),
						'url' => home_url(),
					),
					'page_blog' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{blog}}',
					),
					'page_servises' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{servises}}',
					),
					'page_shop' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{shop}}',
					),
				),
			),
			'social' => array(
				'name' => __( 'Social Links Menu', 'bpm128' ),
				'items' => array(
					'link_facebook' => array(
						'title' => _x( 'Facebook', 'bpm128' ),
						'url' => 'https://www.facebook.com',
					),
					'link_instagram' => array(
						'title' => _x( 'Instagram', 'bpm128' ),
						'url' => 'https://www.instagram.com',
					),
					'link_linkedin' => array(
						'title' => _x( 'LinkedIn', 'bpm128' ),
						'url' => 'https://www.linkedin.com',
					),
					'link_pinterest' => array(
						'title' => _x( 'Pinterest', 'bpm128' ),
						'url' => 'https://www.pinterest.com',
					),
					'link_twitter' => array(
						'title' => _x( 'Twitter', 'bpm128' ),
						'url' => 'https://twitter.com',
					),
					'link_youtube' => array(
						'title' => _x( 'YouTube', 'Theme starter content' ),
						'url' => 'https://www.youtube.com',
					),
				),
			),
		),


	));


}

add_action( 'after_setup_theme', 'bpm128_after_setup' );



 

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function bpm128_content_width() {

	$content_width = 700;

	if ( bpm128_is_frontpage() ) {
		$content_width = 1120;
	}

	/**
	 * Filter bpm128 content width of the theme.
	 *
	 * @since bpm128 1.0
	 *
	 * @param $content_width integer
	 */
	$GLOBALS['content_width'] = apply_filters( 'bpm128_content_width', $content_width );
}
add_action( 'after_setup_theme', 'bpm128_content_width', 0 );

/**
 * Register custom fonts.
 */
// function bpm128_fonts_url() {
// 	$fonts_url = '';

	
// 	$libre_franklin = _x( 'on', 'Nunito Sans font: on or off', 'bpm128' );

// 	if ( 'off' !== $libre_franklin ) {
// 		$font_families = array();

// 		$font_families[] = 'Nunito+Sans:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i';

// 		$query_args = array(
// 			'family' => urlencode( implode( '|', $font_families ) ),
// 			'subset' => urlencode( 'latin,latin-ext' ),
// 		);

// 		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
// 	}

// 	return esc_url_raw( $fonts_url );
// }


/**
 * Add preconnect for Google Fonts.
 *
 * @since bpm128 1.0
 *
 * @param array  $urls           URLs to print for resource hints.
 * @param string $relation_type  The relation type the URLs are printed.
 * @return array $urls           URLs to print for resource hints.
 */
function bpm128_resource_hints( $urls, $relation_type ) {
	if ( wp_style_is( 'bpm128-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
		$urls[] = array(
			'href' => 'https://fonts.gstatic.com',
			'crossorigin',
		);
	}

	return $urls;
}
add_filter( 'wp_resource_hints', 'bpm128_resource_hints', 10, 2 );

function bpm128_pagenavi($post_type ='',$posts_per_page = '') {

   $count_posts = wp_count_posts();


    $big = 999999999;
    $args = array(
        'igor' => str_replace( $big, '%#%', get_pagenum_link( $big, false ) )
        ,'fobsat' => ''
        ,'current' => max( 1, get_query_var('paged') )
        ,'total' => ceil($count_posts->publish/$posts_per_page  )

    );
    $result = paginate_links( $args );
    $result = str_replace( '/page/1"', '"', $result );

    echo $result;
}


/**
 * Register widget area.
 */
function bpm128_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'bpm128' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'bpm128' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'bpm128' ),
		'id'            => 'footer-sidebar-1',
		'description'   => __( 'Add widgets here to appear in your footer.', 'bpm128' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer 2', 'bpm128' ),
		'id'            => 'footer-sidebar-2',
		'description'   => __( 'Add widgets here to appear in your footer.', 'bpm128' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer 3', 'bpm128' ),
		'id'            => 'footer-sidebar-3',
		'description'   => __( 'Add widgets here to appear in your footer.', 'bpm128' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer 4', 'bpm128' ),
		'id'            => 'footer-sidebar-4',
		'description'   => __( 'Add widgets here to appear in your footer.', 'bpm128' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'bpm128_widgets_init' );

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... and
 * a 'Continue reading' link.
 *
 * @since bpm128 1.0
 *
 * @return string 'Continue reading' link prepended with an ellipsis.
 */
function bpm128_excerpt_more( $link ) {
	if ( is_admin() ) {
		return $link;
	}

	$link = sprintf( '<p class="link-more"><a href="%1$s" class="more-link">%2$s</a></p>',
		esc_url( get_permalink( get_the_ID() ) ),
		/* translators: %s: Name of current post */
		sprintf( __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'bpm128' ), get_the_title( get_the_ID() ) )
	);
	return ' &hellip; ' . $link;
}
add_filter( 'excerpt_more', 'bpm128_excerpt_more' );

/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 * @since bpm128 1.0
 */
function bpm128_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'bpm128_javascript_detection', 0 );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function bpm128_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
	}
}
add_action( 'wp_head', 'bpm128_pingback_header' );

/**
 * Display custom color CSS.
 */
function bpm128_colors_css_wrap() {
	if ( 'custom' !== get_theme_mod( 'colorscheme' ) && ! is_customize_preview() ) {
		return;
	}

	require_once( get_parent_theme_file_path( '/inc/color-patterns.php' ) );
	$hue = absint( get_theme_mod( 'colorscheme_hue', 250 ) );
?>
	<style type="text/css" id="custom-theme-colors" <?php if ( is_customize_preview() ) { echo 'data-hue="' . $hue . '"'; } ?>>
		<?php echo bpm128_custom_colors_css(); ?>
	</style>
<?php }
add_action( 'wp_head', 'bpm128_colors_css_wrap' );


//Enqueue scripts and styles admin 

function ospersonality_style_backend() {
   // wp_enqueue_script( 'customizer-pro', get_template_directory_uri() . '/js/customizer-pro.js', '1.0', 'jquery', true);
    wp_enqueue_style( 'admin-style', get_theme_file_uri( '/assets/css/admin-style.css' ), array(), '1.0' );
    wp_enqueue_style( 'font-awesome', get_theme_file_uri( '/assets/css/font-awesome.min.css' ), array(), '4.7.0' );

}
add_action( 'admin_enqueue_scripts', 'ospersonality_style_backend' );



/**
 * Enqueue scripts and styles.
 */
function bpm128_scripts() {
	
	// Theme stylesheet.
	wp_enqueue_style( 'bpm128-style', get_stylesheet_uri() );

	// Load bootstrap styles.
	wp_enqueue_style('style-bootstrap', get_theme_file_uri( '/bootstrap/css/bootstrap.css' ), array(), '3.3.4', 'all');

	// Load font-awesome icons.
	wp_enqueue_style( 'style-fontawesome', get_theme_file_uri( '/assets/css/font-awesome.min.css' ), array(), '4.7.0' );

	// Load the dark colorscheme.
	if ( 'dark' === get_theme_mod( 'colorscheme', 'light' ) || is_customize_preview() ) {
		wp_enqueue_style( 'bpm128-colors-dark', get_theme_file_uri( '/assets/css/colors-dark.css' ), array( 'bpm128-style' ), '1.0' );
	}

	// Load the html5 shiv.
	wp_enqueue_script( 'html5', get_theme_file_uri( '/assets/js/html5.js' ), array(), '3.7.3' );
	wp_script_add_data( 'html5', 'conditional', 'lt IE 9' );

	wp_enqueue_script( 'bpm128-skip-link-focus-fix', get_theme_file_uri( '/assets/js/skip-link-focus-fix.js' ), array(), '1.0', true );

	$bpm128_l10n = array(
		'quote'          => bpm128_get_svg( array( 'icon' => 'quote-right' ) ),
	);


	wp_enqueue_script( 'bpm128-global', get_theme_file_uri( '/assets/js/global.js' ), array( 'jquery' ), '1.0', true );
	
	wp_enqueue_script( 'bpm128-custom', get_theme_file_uri( '/assets/js/custom.js' ), array( 'jquery' ), '1.0', true );

	wp_enqueue_script( 'bpm128-navigation', get_theme_file_uri( '/assets/js/navigation.js' ), array( 'jquery' ), '1.0', true );

	wp_enqueue_script( 'jquery-scrollto', get_theme_file_uri( '/assets/js/jquery.scrollTo.js' ), array( 'jquery' ), '2.1.2', true );

	wp_localize_script( 'bpm128-skip-link-focus-fix', 'bpm128ScreenReaderText', $bpm128_l10n );

	// Load bootstrap script.
	wp_enqueue_script('bootstrap', get_theme_file_uri ( '/bootstrap/js/bootstrap.js'), array( ), true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'bpm128_scripts' );

/**
 * Enqueue Google Fonts using a function
 */
function bpm128_load_google_fonts() {
  	
  	// Setup font arguments
	$query_args = array(
		'family' => 'Athiti:200,300,400,500,600,700|Dosis:200,300,400,500,600,700,800|Droid+Sans:400,700|Exo+2:100,200,300,400,500,600,700,800,900|Josefin+Sans:100,300,400,600,700|Lato:100,300,400,700,900|Merriweather:300,400,700,900|Muli:200,300,400,600,700,800,900|Noto+Sans:400,700|Nunito+Sans:200,300,400,600,700,800,900|Open+Sans+Condensed:300,300i,700|Open+Sans:400,600,700,800|Oswald:300,400,700|PT+Sans:400,400i,700,700i|Rajdhani:300,400,500,600,700|Raleway:100,200,300,400,500,600,700,800,900|Roboto+Condensed:300,400,700|Roboto+Slab:100,300,400,700|Roboto:100,300,400,500,700,900|Source+Sans+Pro:200,300,400,600,700,900|Space+Mono:400,400i,700,700i|Taviraj:100,200,300,400,500,600,700,800,900|Titillium+Web:200,300,400,600,700,900|Ubuntu:300,400,500,700|Work+Sans:100,200,300,400,500,600,700,800,900' // Change this font to whatever font you'd like
	);
 
 	// A safe way to register a CSS style file for later use
	wp_register_style( 'google-fonts', add_query_arg( $query_args, "//fonts.googleapis.com/css" ), array(), null );
	
	// A safe way to add/enqueue a CSS style file to a WordPress generated page
	wp_enqueue_style( 'google-fonts' );
}
add_action( 'wp_enqueue_scripts', 'bpm128_load_google_fonts' );


/**
 * Add custom image sizes attribute to enhance responsive image functionality
 * for content images.
 *
 * @since bpm128 1.0
 *
 * @param string $sizes A source size value for use in a 'sizes' attribute.
 * @param array  $size  Image size. Accepts an array of width and height
 *                      values in pixels (in that order).
 * @return string A source size value for use in a content image 'sizes' attribute.
 */
function bpm128_content_image_sizes_attr( $sizes, $size ) {
	$width = $size[0];

	if ( 740 <= $width ) {
		$sizes = '(max-width: 706px) 89vw, (max-width: 767px) 82vw, 740px';
	}

	if ( is_active_sidebar( 'sidebar-1' ) || is_archive() || is_search() || is_home() || is_page() ) {
		if ( ! ( is_page() && 'one-column' === get_theme_mod( 'page_options' ) ) && 767 <= $width ) {
			 $sizes = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
		}
	}

	return $sizes;
}
add_filter( 'wp_calculate_image_sizes', 'bpm128_content_image_sizes_attr', 10, 2 );

//custom excerpt
function bpm128_excerpt($num) {
    $limit = $num+1;
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
    echo $excerpt;
}


/**
 * Filter the `sizes` value in the header image markup.
 *
 * @since bpm128 1.0
 *
 * @param string $html   The HTML image tag markup being filtered.
 * @param object $header The custom header object returned by 'get_custom_header()'.
 * @param array  $attr   Array of the attributes for the image tag.
 * @return string The filtered header image HTML.
 */
function bpm128_header_image_tag( $html, $header, $attr ) {
	if ( isset( $attr['sizes'] ) ) {
		$html = str_replace( $attr['sizes'], '100vw', $html );
	}
	return $html;
}
add_filter( 'get_header_image_tag', 'bpm128_header_image_tag', 10, 3 );

/**
 * Add custom image sizes attribute to enhance responsive image functionality
 * for post thumbnails.
 *
 * @since bpm128 1.0
 *
 * @param array $attr       Attributes for the image markup.
 * @param int   $attachment Image attachment ID.
 * @param array $size       Registered image size or flat array of height and width dimensions.
 * @return string A source size value for use in a post thumbnail 'sizes' attribute.
 */
function bpm128_post_thumbnail_sizes_attr( $attr, $attachment, $size ) {
	if ( is_archive() || is_search() || is_home() ) {
		$attr['sizes'] = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
	} else {
		$attr['sizes'] = '100vw';
	}

	return $attr;
}
add_filter( 'wp_get_attachment_image_attributes', 'bpm128_post_thumbnail_sizes_attr', 10, 3 );

/**
 * Use front-page.php when Front page displays is set to a static page.
 *
 * @since bpm128 1.0
 *
 * @param string $template front-page.php.
 *
 * @return string The template to be used: blank if is_home() is true (defaults to index.php), else $template.
 */
function bpm128_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template',  'bpm128_front_page_template' );

/**
 * Implement the Custom Header feature.
 */
require get_parent_theme_file_path( '/inc/custom-header.php' );

/**
 * Custom template tags for this theme.
 */
require get_parent_theme_file_path( '/inc/template-tags.php' );

/**
 * Additional features to allow styling of the templates.
 */
require get_parent_theme_file_path( '/inc/template-functions.php' );

/**
 * Customizer additions.
 */
require get_parent_theme_file_path( '/inc/customizer.php' );

/**
 * SVG icons functions and filters.
 */
require get_parent_theme_file_path( '/inc/icon-functions.php' );

/**
 * customize style
 */
require get_parent_theme_file_path( '/inc/tamplate-customize.php' );
