<?php
/**
 * bpm128: Customizer
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function bpm128_customize_register( $wp_customize ) {

	/*****************************Customize Control***************/
    class WP_Slider_Customize_Control extends WP_Customize_Control {
        public $type = 'range';

        public function render_content() { ?>

        <label>
            <?php if ( ! empty( $this->label ) ) : ?>
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
            <?php endif;
            if ( ! empty( $this->description ) ) : ?>
            <span class="description customize-control-description"><?php echo $this->description; ?></span>
            <?php endif; ?>
            <form onsubmit="return false" oninput="level.value = flevel.valueAsNumber">
              <input name="flevel" id="slider-range" type="range" min="0" max="100" step="1" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?> />
              <output for="slider-range" name="level"><?php echo esc_attr( $this->value() ); ?></output>px
            </form>
        </label>

        <?php
        }
    };

    $fonts_select = array(
    	"Athiti, sans-serif"              => "Athiti",
    	"Droid Sans, sans-serif"          => "Droid Sans",
    	"Dosis, sans-serif"               => "Dosis",
    	"Exo 2, sans-serif"               => "Exo 2",
    	"Josefin Sans, sans-serif"        => "Josefin Sans",
    	"Lato, sans-serif"                => "Lato",
    	"Merriweather, serif"             => "Merriweather",
    	"Muli, sans-serif"                => "Muli",
    	"Nunito Sans, sans-serif"         => "Nunito Sans" ,
    	"Open Sans, sans-serif" 		  => "Open Sans",
    	"Oswald, sans-serif"              => "Oswald",
    	"Open Sans Condensed, sans-serif" => "Open Sans Condensed",
    	"Rajdhani, sans-serif"            => "Rajdhani",
    	"Raleway, sans-serif"             => "Raleway",
    	"Roboto, sans-serif"              => "Roboto",
    	"Roboto Condensed, sans-serif"    => "Roboto Condensed",
    	"Roboto Slab, serif"              => "Roboto Slab",
		"Space Mono, monospace"           => "Space Mono",
    	"Source Sans Pro, sans-serif"     => "Source Sans Pro",
    	"Taviraj, serif"                  => "Taviraj",
    	"Titillium Web, sans-serif"       => "Titillium Web",
    	"Ubuntu, sans-serif"              => "Ubuntu",
    	"Work Sans, sans-serif"           => "Work Sans",
	);

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'bpm128_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'bpm128_customize_partial_blogdescription',
	) );


	/******Menu Settings*******************/

    $wp_customize->add_section( 'bpm128_menu_settings' , array(
        'title'       => __( 'Menu Settings','bpm128' ),
        'priority'    => 1,
        'panel'       => 'nav_menus',
        'type'        => 'theme_mod',
        'capability'  => 'edit_theme_options',
        'description' => __('Menu settings', 'bpm128'),
    ) );

    /*-------------Menu Font-family-----------------*/

        $wp_customize->add_setting( 'bpm128_menu_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_font',array(
                'label'    => __( 'Menu Font','bpm128' ),
                'settings' => 'bpm128_menu_font',
                'priority' => 10,
                'section'  => 'bpm128_menu_settings',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );


    /*----------Menu Font Size----------------*/

        $wp_customize->add_setting( 'bpm128_menu_font_size' , array(
            'default'           => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
            $wp_customize,'menu_font_size',array(
             	'label'    => __('Font size','bpm128'),
            	'section'  => 'bpm128_menu_settings',
                'settings' => 'bpm128_menu_font_size',
                'priority' => 20,
                )
        ) );

    /*----------Menu Font Color--------------*/

        $wp_customize->add_setting( 'bpm128_menu_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_color',array(
                'label'    => __('Font Color','bpm128'),
                'section'  => 'bpm128_menu_settings',
                'settings' => 'bpm128_menu_color',
                'priority' => 30,
                )
        ) );

    /*------------Menu Font Color Hover----------------*/

        $wp_customize->add_setting( 'bpm128_menu_hover_color',array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_hover_color',array(
                'label'    => __('Hover Color','bpm128'),
                'section'  => 'bpm128_menu_settings',
                'settings' => 'bpm128_menu_hover_color',
                'priority' => 31,
                )
        ) );

        /*--------------Menu link underline----------------*/

        $wp_customize->add_setting( 'bpm128_menu_underline',array(
            'default'           => 'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline',array(
                'label'    => __('Menu link underline','bpm128'),
                'settings' => 'bpm128_menu_underline',
                'section'  => 'bpm128_menu_settings',
                'type'     =>'radio',
                'priority' => 35,
                'choices'  => array(
                    'none'      => 'no',
                    'underline' => 'yes'))
        ) );

        /*-----------Menu Link underline hover----------------*/

         $wp_customize->add_setting( 'bpm128_menu_underline_hover',array(
            'default'           => 'underline',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline_hover',array(
                'label'    => __('links underline hover','bpm128'),
                'settings' => 'bpm128_menu_underline_hover',
                'section'  => 'bpm128_menu_settings',
                'type'     => 'radio',
                'priority' => 38,
                'choices'  => array(
                    'none'      => 'no',
                    'underline' => 'yes'))
        ) );



        /*-----------SUB Menu Font Color-----------*/

        $wp_customize->add_setting( 'bpm128_submenu_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_color',array(
                 'label'     => __('Sub menu font Color','bpm128'),
                 'section'   => 'bpm128_menu_settings',
                 'settings'  => 'bpm128_submenu_color',
                 'priority'  => 40,
                 )
        ) );

        /*---------------SUB Menu Font Color Hover----------------*/

        $wp_customize->add_setting( 'bpm128_submenu_hover_color',array(
            'default'           => '#888',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_hover_color',array(
                 'label'    => __('Sub menu hover color','bpm128'),
                 'section'  => 'bpm128_menu_settings',
                 'settings' => 'bpm128_submenu_hover_color',
                 'priority' => 45,
                 )
        ) ); 

        /*---------------soc icons color----------------*/

        $wp_customize->add_setting( 'bpm128_soc_icons_color',array(
            'default'           => '#888',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_icons_color',array(
                 'label'    => __('Soc icon color','bpm128'),
                 'section'  => 'bpm128_menu_settings',
                 'settings' => 'bpm128_soc_icons_color',
                 'priority' => 48,
                 )
        ) );
        
    
    /*------------------Typography---------------------------*/




    $wp_customize->add_section( 'bpm128_typography',array(
        'title'       => __('Typography','bpm128'),
        'priority'    => 60,
        'type'        => 'theme_mod',
        'capability'  => 'edit_theme_options',
        'description' => __('Typography settings', 'bpm128'),
    ) );

    /*----------------Body font------------------*/

        $wp_customize->add_setting( 'bpm128_body_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize, 'body_font',array(
                    'label'    => __( 'Body Font','bpm128' ),
                    'settings' => 'bpm128_body_font',
                    'priority' => 10,
                    'section'  => 'bpm128_typography',
                    'type'     => 'select',
                    'choices'  => $fonts_select,
                )
            )
        );

        /*----------------Body Font Size-----------------*/

        $wp_customize->add_setting( 'bpm128_font_size' , array(
            'default'           => '16',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize, 'font_size',array(
                 'label'    => __('Body font size','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_font_size',
                 'priority' => 11,
                 )
         ) );

        /*-----------------Body font color-----------------*/

        $wp_customize->add_setting('bpm128_font_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize, 'font_color',array(
                'label'    => __('Body font color','bpm128'),
                'section'  => 'bpm128_typography',
                'settings' => 'bpm128_font_color',
                'priority' => 12,
             )
         ) );


        /*-------------H1---------------------*/

        $wp_customize->add_setting( 'bpm128_h1_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
              $wp_customize,'h1_font',array(
                'label'    => __( 'h1','bpm128' ),
                'settings' => 'bpm128_h1_font',
                'priority' => 20,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h1_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h1_color',array(
                 'label'    => __('h1 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h1_color',
                 'priority' => 22,
                 )
         ) );

        /*---------H2---------------*/

        $wp_customize->add_setting( 'bpm128_h2_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h2_font',array(
                'label'    => __( 'h2','bpm128' ),
                'settings' => 'bpm128_h2_font',
                'priority' => 25,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h2_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h2_color',array(
                 'label'    => __('h2 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h2_color',
                 'priority' => 30,
                 )
        ) );

        /*------------H3-------------*/

        $wp_customize->add_setting( 'bpm128_h3_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h3_font',array(
                'label'    => __( 'h3','bpm128' ),
                'settings' => 'bpm128_h3_font',
                'priority' => 40,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h3_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h3_color',array(
                 'label'    => __('h3 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h3_color',
                 'priority' => 45,
                 )
        ) );

        /*----------------H4------------*/

        $wp_customize->add_setting( 'bpm128_h4_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h4_font',array(
                'label'    => __( 'h4','bpm128' ),
                'settings' => 'bpm128_h4_font',
                'priority' => 50,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h4_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h4_color',array(
                 'label'    => __('h4 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h4_color',
                 'priority' => 55,
                 )
        ) );

        /*-------------------H5----------------*/

        $wp_customize->add_setting( 'bpm128_h5_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h5_font',array(
                'label'    => __( 'h5','bpm128' ),
                'settings' => 'bpm128_h5_font',
                'priority' => 60,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h5_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h5_color',array(
                 'label'    => __('h5 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h5_color',
                 'priority' => 65,
                 )
        ) );

        /*-------------H6---------------*/

        $wp_customize->add_setting( 'bpm128_h6_font' , array(
            'default'           => 'Nunito Sans, sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h6_font',array(
                'label'    => __( 'h6','bpm128' ),
                'settings' => 'bpm128_h6_font',
                'priority' => 70,
                'section'  => 'bpm128_typography',
                'type'     => 'select',
                'choices'  => $fonts_select,
                )
            )
        );

        $wp_customize->add_setting('bpm128_h6_color',array(
            'default'           => '#333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h6_color',array(
                 'label'    => __('h6 color','bpm128'),
                 'section'  => 'bpm128_typography',
                 'settings' => 'bpm128_h6_color',
                 'priority' => 75,
                 )
        ) );






	/**
	 * Custom colors.
	 */
	$wp_customize->add_setting( 'colorscheme', array(
		'default'           => 'light',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'bpm128_sanitize_colorscheme',
	) );

	$wp_customize->add_setting( 'colorscheme_hue', array(
		'default'           => 250,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint', // The hue is stored as a positive integer.
	) );

	$wp_customize->add_control( 'colorscheme', array(
		'type'    => 'radio',
		'label'    => __( 'Color Scheme', 'bpm128' ),
		'choices'  => array(
			'light'  => __( 'Light', 'bpm128' ),
			'dark'   => __( 'Dark', 'bpm128' ),
			'custom' => __( 'Custom', 'bpm128' ),
		),
		'section'  => 'colors',
		'priority' => 5,
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'colorscheme_hue', array(
		'mode' => 'hue',
		'section'  => 'colors',
		'priority' => 6,
	) ) );

	/**
	 * Theme options.
	 */
	$wp_customize->add_section( 'theme_options', array(
		'title'    => __( 'Theme Options', 'bpm128' ),
		'priority' => 130, // Before Additional CSS.
	) );

	// $wp_customize->add_setting( 'page_layout', array(
	// 	'default'           => 'two-column',
	// 	'sanitize_callback' => 'bpm128_sanitize_page_layout',
	// 	'transport'         => 'postMessage',
	// ) );

	// $wp_customize->add_control( 'page_layout', array(
	// 	'label'       => __( 'Page Layout', 'bpm128' ),
	// 	'section'     => 'theme_options',
	// 	'type'        => 'radio',
	// 	'description' => __( 'When the two column layout is assigned, the page title is in one column and content is in the other.', 'bpm128' ),
	// 	'choices'     => array(
	// 		'one-column' => __( 'One Column', 'bpm128' ),
	// 		'two-column' => __( 'Two Column', 'bpm128' ),
	// 	),
	// 	'active_callback' => 'bpm128_is_view_with_layout_option',
	// ) );

	/**
	 * Filter number of front page sections in bpm128.
	 *
	 * @since bpm128 1.0
	 *
	 * @param $num_sections integer
	 */
	$num_sections = apply_filters( 'bpm128_front_page_sections', 6 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		$wp_customize->add_setting( 'panel_' . $i, array(
			'default'           => false,
			'sanitize_callback' => 'absint',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( 'panel_' . $i, array(
			/* translators: %d is the front page section number */
			'label'          => sprintf( __( 'Front Page Section %d Content', 'bpm128' ), $i ),
			'description'    => ( 1 !== $i ? '' : __( 'Select pages to feature in each area from the dropdowns. Add an image to a section by setting a featured image in the page editor. Empty sections will not be displayed.', 'bpm128' ) ),
			'section'        => 'theme_options',
			'type'           => 'dropdown-pages',
			'allow_addition' => true,
			'active_callback' => 'bpm128_is_static_front_page',
		) );

		$wp_customize->selective_refresh->add_partial( 'panel_' . $i, array(
			'selector'            => '#panel' . $i,
			'render_callback'     => 'bpm128_front_page_section',
			'container_inclusive' => true,
		) );
	}
}
add_action( 'customize_register', 'bpm128_customize_register' );

/**
 * Sanitize the page layout options.
 */
// function bpm128_sanitize_page_layout( $input ) {
// 	$valid = array(
// 		'one-column' => __( 'One Column', 'bpm128' ),
// 		'two-column' => __( 'Two Column', 'bpm128' ),
// 	);

// 	if ( array_key_exists( $input, $valid ) ) {
// 		return $input;
// 	}

// 	return '';
// }

/**
 * Sanitize the colorscheme.
 */
function bpm128_sanitize_colorscheme( $input ) {
	$valid = array( 'light', 'dark', 'custom' );

	if ( in_array( $input, $valid ) ) {
		return $input;
	}

	return 'light';
}

/**
 * Render the site title for the selective refresh partial.
 *
 * @since bpm128 1.0
 * @see bpm128_customize_register()
 *
 * @return void
 */
function bpm128_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since bpm128 1.0
 * @see bpm128_customize_register()
 *
 * @return void
 */
function bpm128_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Return whether we're previewing the front page and it's a static page.
 */
function bpm128_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

/**
 * Return whether we're on a view that supports a one or two column layout.
 */
function bpm128_is_view_with_layout_option() {
	// This option is available on all pages. It's also available on archives when there isn't a sidebar.
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

/**
 * Bind JS handlers to instantly live-preview changes.
 */
function bpm128_customize_preview_js() {
	wp_enqueue_script( 'bpm128-customize-preview', get_theme_file_uri( '/assets/js/customize-preview.js' ), array( 'customize-preview' ), '1.0', true );
}
add_action( 'customize_preview_init', 'bpm128_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function bpm128_panels_js() {
	wp_enqueue_script( 'bpm128-customize-controls', get_theme_file_uri( '/assets/js/customize-controls.js' ), array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'bpm128_panels_js' );
