<?php
/**
 * The front page template file
 *
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

		<?php // Show the selected frontpage content.
		if ( have_posts() ) :
			while ( have_posts() ) : the_post();
				get_template_part( 'template-parts/page/content', 'front-page' );
			endwhile;
		else : // I'm not sure it's possible to have no posts when this page is shown, but WTH.
			get_template_part( 'template-parts/post/content', 'none' );
		endif; ?>

		<?php
		// Get each of our panels and show the post data.
		if ( 0 !== bpm128_panel_count() || is_customize_preview() ) : // If we have pages to show.

			
			$num_sections = apply_filters( 'bpm128_front_page_sections', 6 );
			global $bpm128counter;

			// Create a setting and control for each of the sections available in the theme.
			for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
				$bpm128counter = $i;
				bpm128_front_page_section( null, $i );
			}

	endif; // The if ( 0 !== bpm128_panel_count() ) ends here. ?>

	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer();
