<?php
/**
 * Template part for displaying pages on front page
 *
 * @package WordPress
 * @subpackage bpm128
 * @since 1.0
 * @version 1.0
 */

global $bpm128counter;

?>

<article id="panel<?php echo $bpm128counter; ?>" <?php post_class( 'bpm128-panel ' ); ?> >

	<?php if ( has_post_thumbnail() ) :
		$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'bpm128-featured-image' );
		$ratio = $thumbnail[2] / $thumbnail[1] * 100;
		?>

	<div class="panel-content with-bg" style="background-image: url(<?php echo esc_url( $thumbnail[0] ); ?>);">
	<?php else: ?>
	<div class="panel-content">
	<?php endif; ?>

		<div class="wrap blog-home">
			<header class="entry-header">
				<?php the_title( '<h2 class="entry-title">', '</h2>' ); ?>

				<?php bpm128_edit_link( get_the_ID() ); ?>

			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php
					/* translators: %s: Name of current post */
					the_content( sprintf(
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'bpm128' ),
						get_the_title()
					) );
				?>
			</div><!-- .entry-content -->

			<?php
			if ( get_the_ID() === (int) get_option( 'page_for_posts' )  ) : ?>

				<?php // Show four most recent posts.
				$recent_posts = new WP_Query( array(
					'posts_per_page'      => 4,
					'post_status'         => 'publish',
					'ignore_sticky_posts' => true,
					'no_found_rows'       => true,
				) );
				?>

		 		<?php if ( $recent_posts->have_posts() ) : ?>

					<div class="recent-posts">

						<?php
						while ( $recent_posts->have_posts() ) : $recent_posts->the_post();
							get_template_part( 'template-parts/post/content', 'loop' );
						endwhile;
						wp_reset_postdata();
						?>
					</div><!-- .recent-posts -->
				<?php endif; ?>
			<?php endif; ?>

		</div><!-- .wrap -->
	</div><!-- .panel-content -->

</article><!-- #post-## -->
