<?php
/*
 * @package OS_Touch_Slider_Free
 * @subpackage  mod_medialibrary_os_touchslider_people_Free
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru); Sergey Bunyaev(sergey@bunyaev.ru); Sergey Solovyev(solovyev@solovyev.in.ua)
 * @Homepage: http://www.ordasoft.com
 * @version: 3.5 Free
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
require_once dirname(__FILE__).'/helpers/images.php';
require_once dirname(__FILE__).'/helpers/helper.php';

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;

if (!array_key_exists('medialibrary_configuration', $GLOBALS))
{
    require_once ($mosConfig_absolute_path 
            . "/administrator/components/com_medialibrary/admin.medialibrary.class.conf.php");
    $GLOBALS['medialibrary_configuration'] = $medialibrary_configuration;
} else
    global $medialibrary_configuration;


$database = JFactory::getDBO();
// load language
$languagelocale = "";
$query = "SELECT l.title, l.lang_code, l.sef ";
$query .= "FROM #__medialibrary_const_languages as cl ";
$query .= "LEFT JOIN #__medialibrary_languages AS l ON cl.fk_languagesid=l.id ";
$query .= "LEFT JOIN #__medialibrary_const AS c ON cl.fk_constid=c.id ";
$query .= "GROUP BY  l.title";
$database->setQuery($query);
$languages = $database->loadObjectList();

$lang = JFactory::getLanguage();
foreach ($lang->getLocale() as $locale) {
    foreach ($languages as $language) {
        if ($locale == $language->title || $locale == $language->lang_code || $locale == $language->sef) {
            $mosConfig_lang = $locale;
            $languagelocale = $language->lang_code;
            break;
        }
    }
}

if ($languagelocale == '') {
    $mosConfig_lang = $lang->getTag();
    $languagelocale = $lang->getTag();
}
 if ($languagelocale == '')
     $languagelocale = "en-GB";

global $langContent;
$langContent = substr($languagelocale, 0, 2);

$show_type =$params->get('type','horizontal');
JHtml::_('stylesheet',JURI::base()."/modules/mod_medialibrary_os_touchslider_people/assets/css/idangerous-swiper.css");
if($params->get('jquery-local',1) == "1" && $params->get('jquery',1) == "1") {
    JHtml::_('script',JURI::base()."/modules/mod_medialibrary_os_touchslider_people/assets/js/jquery-1.7.1.min.js");
} elseif ($params->get('jquery',1) == "1") {
    JHtml::_('script','//ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js');
}


if($params->get('no-conflict',0) == '1') {
    $doc =JFactory::getDocument();
    $doc->addScriptDeclaration("jQuery.noConflict();");
}

if($params->get('width')){
  $width = $params->get('width');
}else{
  $width = 100;
}

if($params->get('is_percentage') == 'percentage'){
  $format='%';
}else{
  $format='px';
}

if(!is_numeric($height = $params->get('height'))) $height = 180;

JHtml::_('script',JURI::base()."/modules/mod_medialibrary_os_touchslider_people/assets/js/idangerous-swiper.js");
$arrows = $params->get('arrows','1');
$respect_quite = $params->get('respect_quite','1');
$dots = $params->get('dots','1');
$autoplay = $params->get('autoplay','1');
$sufix = $params->get('sufix','');

require JModuleHelper::getLayoutPath('mod_medialibrary_os_touchslider_people', $params->get('layout', 'default'));
