<?php

defined('_JEXEC') or die;

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class com_os_cckInstallerScript {

    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent) {

        // $parent is the class calling this method
        $db = JFactory::getDBO();
        $params = new JRegistry;
        //$params->set("by_time","0");
        $params->set("rent_type","0");
        $params->set("crop_image","0");
        $params->set("save_database","1");
        $params->set("google_map_key","");
        $params->set("paypal_currency","USD=1;");
        $params->set("currency_position","1");
        $params->set("use_paypal","0");
        $params->set("use_2checkout","0");


        

        self::sqlInstall();

        $tables = $db->getTableList();
        $prefix = $db->getPrefix();
        $isEmpty = false;
        foreach($tables as $name){
            if($name == $prefix . 'os_cck_version'){
                $query = "SELECT * FROM `#__os_cck_version`";
                $db->setQuery($query);
                $isEmpty = $db->loadResult();
            }
        }
        
        

        if(!$isEmpty){

            $current_vers = (string)$parent->manifest->version;
            $query = "INSERT INTO `#__os_cck_version` VALUES (null,'".$current_vers."','no previous')";
            $db->setQuery($query);

            $db->execute();
        }else{
            self::updateVersion($parent);
        }
        
        $query = "UPDATE #__extensions SET params='".$params->toString()."' WHERE element='com_os_cck'";
        $db->setQuery($query);
        $db->execute();

        if(!file_exists(JPATH_SITE . '/images/os-cck')){
            mkdir(JPATH_SITE . '/images/os-cck', 0755, true);
        }

        
    }

    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent) {
        // $parent is the class calling this method
        require_once(JPATH_SITE . "/administrator/components/com_os_cck/uninstall.os_cck.php");
        com_uninstall();
    }

    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent) {
        // $parent is the class calling this method
        if(file_exists(JPATH_ADMINISTRATOR .'/components/com_os_cck/os_cck.xml')){
            self::updateVersion($parent);
        }else{
            self::install($parent);
        }
        // var_dump($parent);
        
        //self::updateContentTable();
//        var_dump($parent);
        
    }

    static function updateVersion($parent){

        $db = JFactory::getDBO();
        $xml = simplexml_load_file(JPATH_ADMINISTRATOR .'/components/com_os_cck/os_cck.xml');
        $current_vers = (string)$parent->manifest->version;
        $last_vers = (string)$xml->version;
        require_once(JPATH_SITE.'/components/com_os_cck/functions.php');
        
        if(!$last_vers || $last_vers == ''){
            $query = "SELECT current_vers FROM `#__os_cck_version`";
            $db->setQuery($query);
            $last_vers = $db->loadResult();
        }

        $query = "SELECT current_vers FROM `#__os_cck_version`";
        $db->setQuery($query);
        $version_result = $db->loadResult();
        if($version_result){
            $query = "SELECT last_vers FROM #__os_cck_version ";
            $db->setQuery($query);
            $last_versions = $db->loadResult();
            $last_versions = substr($last_versions." - ".$last_vers, -150);
            
        }else{
            $query = "INSERT INTO `#__os_cck_version` VALUES (null,'".$current_vers."','".$last_vers."')";
            $db->setQuery($query);
            $db->execute();
        }
        
        $query = "SELECT * FROM #__os_cck_entity_instance LIMIT 1";
        $db->setQuery($query);
        $result = $db->loadObjectList();
        
        $query_array[] = "ALTER TABLE `#__os_cck_entity_instance` ADD `access` VARCHAR(64) NOT NULL AFTER `featured_shows`";
        $query_array[] = "ALTER TABLE `#__os_cck_entity_instance` ADD `meta_title` VARCHAR(256) NOT NULL AFTER `access`";
        $query_array[] = "ALTER TABLE `#__os_cck_entity_instance` ADD `meta_description` VARCHAR(256) NOT NULL AFTER `meta_title`";
        $query_array[] = "ALTER TABLE `#__os_cck_entity_instance` ADD `meta_keywords` VARCHAR(256) NOT NULL AFTER `meta_description`";
        $query_array[] = "ALTER TABLE `#__os_cck_entity_instance` ADD `meta_robots` TINYINT(2) NOT NULL DEFAULT '0' AFTER `meta_keywords`";
        if(!isset($result[0]->access)){
            foreach($query_array as $query){
                $db->setQuery($query);
                try {
                    $result = $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
            }
        }elseif(!isset($result[0]->meta_title)){
            foreach($query_array as $key => $query){
                if($key>0){
                    $db->setQuery($query);
                    try {
                        $result = $db->execute();
                    } catch (Exception $ex) {
                        echo $ex->getMessage();
                    }
                }
            }
        }
        
        $query = "CREATE TABLE IF NOT EXISTS `#__os_cck_api` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `service` varchar(255) NOT NULL,
                  `key` text NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8";
        $db->setQuery($query);
        $db->execute();
        
        
        if (!version_compare($last_vers, "7.0.1", "ge")){
            $query = "SELECT fid, fk_eid, db_field_name, params FROM #__os_cck_entity_field WHERE field_type='text_select_list'";
            $db->setQuery($query);
            $tmp_fields = $db->loadObjectList();
            
            foreach($tmp_fields as $tmp_field){
                
                $new_params = new JRegistry;
                try {
                    $new_params->loadString($tmp_field->params);
                    
                    
                } catch (Exception $ex) {
                    continue;
                }
                

                $new_allowed_valued = $new_params->get('allowed_value');
                if(!$new_allowed_valued) continue;
                if (strpos($new_allowed_valued, '\sprt') !== false){
                    $new_allowed_valued = explode('\sprt', $new_allowed_valued);
                }
                foreach($new_allowed_valued as $tmp_key => $tmp_val){
                    $query = "SELECT ceid, $tmp_field->db_field_name as val FROM #__os_cck_content_entity_$tmp_field->fk_eid WHERE $tmp_field->db_field_name IS NOT NULL";
                    $db->setQuery($query);
                    $field_row = $db->loadObjectList();
                    
                    if(stripos($tmp_val, '|') !== false){
                        $pos = stripos($tmp_val, '|');
                        $tmp_val = substr($tmp_val, $pos + 1);
                        $new_allowed_valued[$tmp_key] = $tmp_val;

                    }
                    
                    foreach($field_row as $tmp){
                        $fld_val_arr = json_decode($tmp->val);
//                        var_dump($tmp_val);
//                        var_dump($fld_val_arr);
                        $change = false;
                        if(is_array($fld_val_arr)){
                            foreach ($fld_val_arr as $k => $fld_val){
                                if($fld_val == $tmp_val){
                                    $fld_val_arr[$k] = "$tmp_key";
                                    $change = true;
                                }
                            }
                        }
                        
                        $fld_val_arr = json_encode($fld_val_arr);
                        if($change){
                            $query = "UPDATE #__os_cck_content_entity_$tmp_field->fk_eid SET $tmp_field->db_field_name = '$fld_val_arr' WHERE ceid=$tmp->ceid";
                            $db->setQuery($query);
                            $db->execute();
                        }
//                        var_dump($fld_val);
                    }
                    
                    
                }
//                var_dump($new_allowed_valued);
                if(count($new_allowed_valued) > 1){
                    $str_param = '';
                    foreach ($new_allowed_valued as $key => $value) {
                      if(!empty($value) && $value != end($new_allowed_valued)){
                        $str_param .= $value.'\sprt';
                      }else{
                        $str_param .= $value;
                      }
                    }
                  }else{
                    $str_param = array_pop($new_allowed_valued);
                  }
//                $new_allowed_valued = implode('\sprt', $new_allowed_valued);
                $new_params->set('allowed_value', $str_param);
//                var_dump($new_params); exit;
                $new_params_str = $db->quote($new_params->toString());
//                $new_params = $db->quote($new_params->toString());
                
//                var_dump($new_params); exit;
                $query = "UPDATE #__os_cck_entity_field SET params = $new_params_str WHERE fid = $tmp_field->fid";
                $db->setQuery($query);
                $db->execute();
            }
            
            
        }
        if (!version_compare($last_vers, "7.1.1", "ge")){
            $query = "SELECT * FROM #__os_cck_entity_instance LIMIT 0, 1";
            $db->setQuery($query);
            $tmp_fields = $db->loadObjectList();
            
            if(isset($tmp_fields[0]) && !property_exists($tmp_fields[0], 'layout_type') && !property_exists($tmp_fields[0], 'layout')){
                $query = "ALTER TABLE `#__os_cck_entity_instance` ADD `layout_type` varchar(32) NOT NULL DEFAULT '' AFTER `fk_lid`";
                $db->setQuery($query);
                $db->execute();
            }
            if(isset($tmp_fields[0]) && property_exists($tmp_fields[0], 'layout')){
                $query = "ALTER TABLE `#__os_cck_entity_instance` CHANGE `layout` `layout_type` VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '';";
                $db->setQuery($query);
                $db->execute();    
            }
        }

        $updated_versions = array('1.0.0', '1.1.0', '2.0.0', '3.1.0', '3.2.0', '3.3.0', '4.0.0', '4.1.0', '4.2.0', '5.0.0', '5.5.0', '6.0.0', '6.1.0', '6.5.0', '6.7.0', '7.0.0', '7.1.0', '7.2.0', '7.3.0', '7.4.0', '7.5.0');
        
        foreach($updated_versions as $singl_ver){
            if (version_compare($last_vers, $singl_ver, "le")){
                // var_dump($singl_ver);
                self::sqlUpdate($singl_ver);
            }
        }
        // exit;
        $query = "SELECT eid FROM #__os_cck_entity";
        $db->setQuery($query);
        $enteties = $db->loadColumn();

        foreach($enteties as $entity){
            if(!file_exists(JPATH_SITE . '/components/com_os_cck/files/entity_files_'.$entity)){
                mkdir(JPATH_SITE . '/components/com_os_cck/files/entity_files_'.$entity, 0755, true);
                file_put_contents(JPATH_SITE . '/components/com_os_cck/files/entity_files_'.$entity . '/index.html', '');
              }
              if(!file_exists(JPATH_SITE . '/components/com_os_cck/files/entity_files_'.$entity.'/custom.css')){
                file_put_contents(JPATH_SITE . '/components/com_os_cck/files/entity_files_'.$entity . '/custom.css', '');
              }
        }
        $os_cck_folder = false;
        if(!file_exists(JPATH_SITE . '/images/os-cck')){
            mkdir(JPATH_SITE . '/images/os-cck', 0755, true);
            $os_cck_folder = true;
        }

        
        if($os_cck_folder && file_exists(JPATH_SITE . '/images/stories')){

            $files = scandir(JPATH_SITE . '/images/stories');

            if(!empty($files)){
                foreach($files as $file){
                    if($file == '.' || $file == '..') continue;
                    copy(JPATH_SITE . '/images/stories/'.$file, JPATH_SITE . '/images/os-cck/'.$file);
                    
                }
            }
            
            
        }

        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/add_instance/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/add_instance/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/all_categories/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/all_categories/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/all_instance/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/all_instance/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/calendar/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/calendar/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/cart/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/cart/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/category/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/category/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/instance/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/instance/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/parent_child/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/parent_child/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/show_search/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/show_search/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/user_instances/tmpl/default.xml')) unlink(JPATH_SITE.'/components/com_os_cck/views/user_instances/tmpl/default.xml');
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/hover_layout/')){
            recursiveRemoveDir(JPATH_SITE.'/components/com_os_cck/views/hover_layout');
        }
        if(file_exists(JPATH_SITE.'/components/com_os_cck/views/popup/')){
            recursiveRemoveDir(JPATH_SITE.'/components/com_os_cck/views/popup');
        }

        if($version_result){
            $query = "UPDATE #__os_cck_version SET current_vers = '".$current_vers."', last_vers='".$last_versions."'";
            $db->setQuery($query);
            $db->execute();
        }

    }


    
//    static function updateContentTable(){
//      //We use the Engine InnoDB for the os_cck_content_entity table to avoid an error with more than 64 keys.
//      $db = JFactory::getDBO();
//      $query_tables = "SHOW TABLE STATUS WHERE name LIKE '%os_cck_content_entity%' AND Engine='MyISAM'";
//      
//      $db->setQuery($query_tables);
//      $tables = $db->loadObjectList();
//      $sql = '';
//      if(!empty($tables)){
//          foreach ($tables as $table){
//              $sql = " ALTER TABLE " . $table->Name . " ENGINE=INNODB";
//              $db->setQuery($sql);
//              $db->execute();
//          }
//      }
//    }
    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        $db = JFactory::getDBO();
        $db->setQuery("DELETE FROM #__update_sites WHERE name = 'CCK`s Update'");
        $db->execute();
        
        if ( $type == 'update' ) {
            $component_path = JPath::clean(JPATH_SITE . '/administrator/components/com_os_cck/entities_conf');
            if (is_dir($component_path) && ($component_layouts = JFolder::files($component_path, '^[^-]*\.php$', false, true))) {
                foreach ($component_layouts as $i => $file) {
                    require_once($file);
                    $file_name = explode('.', $file);
                    $pos = strripos($file_name[1], '_');
                    $entity_id = substr($file_name[1], $pos+1);
                    $GLOBALS['cck_entity_configuration_old'][$entity_id] = ${"cck_entity_configuration_$entity_id"};
                }
            }
        }
        
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)
        global $cck_entity_configuration_old;
        if ( $type == 'install' || $type == 'update' ) {
            require_once (JPATH_SITE . '/administrator/components/com_os_cck/adminphp/admin.entity.php');
            require (JPATH_SITE . '/administrator/components/com_os_cck/entities_conf/admin.entity_setting_default.class.conf.php');
            $database = JFactory::getDBO();
            
            $query = "SHOW FIELDS FROM #__assets";
            $database->setQuery($query);
            $collumns = $database->loadObjectList();
            
            foreach($collumns as $coll){
                if($coll->Field == 'id'){
                    if($coll->Extra != 'auto_increment'){
                        $query = "ALTER TABLE #__assets CHANGE id id INT UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key', add PRIMARY KEY (id);";
                        $database->setQuery($query);
                        $database->execute();
                    }
                }
            }
            
            $table_prefix = $database->getPrefix();
            $tableList = $database->getTableList();
            
            $ccklibr = '';
            if (array_search($table_prefix . 'os_cck_entity', $tableList)) {
                $database->setQuery("SELECT * FROM #__os_cck_entity");
                $ccklibr = $database->loadResult();
            }
            
            if(!empty($ccklibr)){
                $database->setQuery("SELECT * FROM #__os_cck_entity");
                $enteties = $database->loadObjectList();
                //entities configurations
                if($type='update'){
                    foreach($enteties as $entity){
                        
                        if(isset($cck_entity_configuration_old[$entity->eid])){
                            $cck_entity_configuration = array_replace_recursive($cck_entity_configuration_default, $cck_entity_configuration_old[$entity->eid]);
                        }else{
                            $cck_entity_configuration = $cck_entity_configuration_default;
                        }
                        
                        AdminEntity::setEntitySettings($cck_entity_configuration, $entity);
                    }
                }
                //entities configurations
                
                return;
            }


            $extractPathFiles = JPATH_SITE.'/components/com_os_cck/files';
            $extractPathImages = JPATH_SITE.'/images';
            $extractPathGalleryZip = JPATH_SITE.'/components/com_os_cck/files/gallery.zip';
//            if(class_exists('ZipArchive')) {
//                $zip = new ZipArchive;
//
//                $extract = $zip->open(JPATH_SITE . "/administrator/components/com_os_cck/exports/sample_data.zip");
//
//                if ($extract === TRUE) {
//
//                    $zip->extractTo($extractPathFiles);
//
//                }
//
//                $extractZip = $zip->open($extractPathGalleryZip);
//                $numFiles = $zip->numFiles;
//                if ($extractZip === TRUE) {
//
//                    for ($i = 0; $i < $numFiles; $i++) {
//                        $gallery_folder_name = str_replace(DIRECTORY_SEPARATOR, '', $zip->statIndex($i)['name']);
//                    }
//
//                    $zip->extractTo($extractPathImages);
//
//                }
//            }
//            $sqlPath = JPATH_SITE.'/components/com_os_cck/files/sqlcck.sql';
//            $sqlContent = file_get_contents($sqlPath);
//            $sqlContent = $database->splitSql($sqlContent);

//            foreach($sqlContent as $query)
//            {
//                $database->setQuery($query);
//                $result = $database->execute();
//            }

//            if(file_exists($extractPathFiles.'/sqlcck.sql')) unlink($extractPathFiles.'/sqlcck.sql');
//            if(file_exists($extractPathFiles.'/gallery.zip')) unlink($extractPathFiles.'/gallery.zip');
//            if(!file_exists(JPATH_SITE . '/components/com_os_cck/files/entity_files_2')){
//                mkdir(JPATH_SITE . '/components/com_os_cck/files/entity_files_2', 0755, true);
//                file_put_contents(JPATH_SITE . '/components/com_os_cck/files/entity_files_2/index.html', '');
//              }
//              if(!file_exists(JPATH_SITE . '/components/com_os_cck/files/entity_files_2/custom.css')){
//                file_put_contents(JPATH_SITE . '/components/com_os_cck/files/entity_files_2/custom.css', '');
//              }
            $database->setQuery("SELECT * FROM #__os_cck_entity");
            $ccklibr = $database->loadObjectList();
            AdminEntity::setEntitySettings($cck_entity_configuration_default, $ccklibr[0]);
            //sample data
            
            

            // $parent is the class calling this method
            // $type is the type of change (install, update or discover_install)
            require_once(JPATH_SITE . "/administrator/components/com_os_cck/install.os_cck.php");
            com_install2();
        }
    }

    static function sqlUpdate($ver){
        $db = JFactory::getDBO();
        switch ($ver) {
            case '1.1.0':
                $query="DROP TABLE IF EXISTS #__os_cck_suggestion,#__os_cck_review,#__os_cck_rent_request,#__os_cck_buying_request";
                $db->setQuery($query);
                $db->execute();
                
                $query="ALTER TABLE #__os_cck_files_child_parent_connect RENAME #__os_cck_child_parent_connect";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_child_parent_connect` ADD `media_type` varchar(255) NOT NULL";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `ALTER TABLE `#__os_cck_layout` ADD `custom_fields`  MEDIUMBLOB NOT NULL";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `ALTER TABLE `#__os_cck_layout` ADD `mail` MEDIUMBLOB NOT NULL";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `ALTER TABLE `#__os_cck_layout` ADD `alias` varchar(255) NOT NULL";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                //
                // Table structure for table `#__os_cck_layout_html`
                //

                $query="CREATE TABLE IF NOT EXISTS #__os_cck_layout_html (
                  `id` int(11) unsigned NOT NULL auto_increment,
                  `fk_lid`int(11) DEFAULT NULL,
                  `layout_html` BLOB DEFAULT NULL,
                  `bootstrap` int(11) unsigned NOT NULL ,
                   FOREIGN KEY (`fk_lid`) REFERENCES #__os_cck_layout(`lid`),
                   PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
                $db->setQuery($query);
                $db->execute();
                
                //
                // Table structure for table `#__os_cck_video_source`
                //

                $query="CREATE TABLE IF NOT EXISTS #__os_cck_video_source (
                  `id` int(11) unsigned NOT NULL auto_increment,
                  `fk_eiid`int(11) DEFAULT NULL,
                  `fk_fid` int(11) DEFAULT NULL,
                  `src` varchar(255) DEFAULT NULL,
                  `type` varchar(255) DEFAULT NULL,
                  `media`varchar(255) DEFAULT NULL,
                  `youtube`varchar(255) DEFAULT NULL,
                   FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
                   PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
                $db->setQuery($query);
                $db->execute();

                //
                // Table structure for table `#__os_cck_track_source`
                //

                $query="CREATE TABLE IF NOT EXISTS #__os_cck_track_source (
                  `id` int(11) unsigned NOT NULL auto_increment,
                  `fk_eiid`int(11) DEFAULT NULL,
                  `sequence_number` int(11) DEFAULT NULL,
                  `src` varchar(255) DEFAULT NULL,
                  `kind` varchar(255) DEFAULT NULL,
                  `scrlang` varchar(255) DEFAULT NULL,
                  `label` varchar(255) DEFAULT NULL,
                   FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
                   PRIMARY KEY (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=1  COLLATE utf8_general_ci;";
                $db->setQuery($query);
                $db->execute();

                //
                // Table structure for table `#__os_cck_audio_source`
                //

                $query="CREATE TABLE IF NOT EXISTS #__os_cck_audio_source ( 
                  `id` int(11) unsigned NOT NULL auto_increment, 
                  `fk_eiid` int(11) DEFAULT NULL, 
                  `sequence_number` int(11) DEFAULT NULL, 
                  `src` varchar(255) DEFAULT NULL, 
                  `type`varchar(255) DEFAULT NULL, 
                   FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
                   PRIMARY KEY  (`id`) 
                ) ENGINE=MyISAM AUTO_INCREMENT=1  COLLATE utf8_general_ci;";
                $db->setQuery($query);
                $db->execute();

                //
                // Table structure for table `#__os_cck_mime_types`
                //

                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_mime_types` (
                  `mime_ext` varchar(255),
                  `mime_type` varchar(255),
                  UNIQUE `mime_ext` (`mime_ext`)
                ) ENGINE=MyISAM AUTO_INCREMENT=1 CHARACTER SET `utf8`;";
                $db->setQuery($query);
                $db->execute();

                $query="ALTER TABLE `#__os_cck_entity_instance` 
                ADD `fk_lid` INT(11) UNSIGNED NOT NULL 
                COMMENT 'The REFERENCES to #__os_cck_layout.lid.' AFTER `eiid`;";
                $db->setQuery($query);
                $db->execute();                

                break;
            
            case '2.0.0':
                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `instance_price` INT(11) NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `instance_currency` VARCHAR(255) NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `notreaded` int(1) NOT NULL DEFAULT '1';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `featured_clicks` int(100) NOT NULL DEFAULT '-1';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `featured_shows` int(100) NOT NULL DEFAULT '-1';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity_field` ADD `params` LONGBLOB DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity` DROP `module`, DROP `description`, DROP `help`, DROP `teid`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_field` DROP `global_settings`, DROP `required`, DROP `multiple`, DROP `db_storage`, DROP `module`, DROP `db_columns`, DROP `ordering`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity_field` ADD `show_in_instance_menu` BOOLEAN NOT NULL DEFAULT '0';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_field` ADD `db_field_name` varchar(255) NOT NULL DEFAULT '';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity_field` CHANGE `field_name` `field_name` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The machine-readable name of this field.';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                
                //
                // Table structure for table `#__os_cck_orders`
                //
                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `fk_user_id` int(11) DEFAULT NULL,
                  `fk_instance_id` int(11) DEFAULT NULL,
                  `fk_request_id` int(11) DEFAULT NULL,
                  `instance_type` varchar(255) NOT NULL DEFAULT '',
                  `instance_title` varchar(255) NOT NULL DEFAULT '',
                  `user_email` varchar(255) NOT NULL DEFAULT '',
                  `user_name` varchar(255) NOT NULL DEFAULT '',
                  `status` varchar(255) NOT NULL DEFAULT '',
                  `order_date` DATETIME,
                  `txn_type` varchar(255) NOT NULL DEFAULT '',
                  `txn_id` varchar(255) NOT NULL DEFAULT '',
                  `payer_id` varchar(255) NOT NULL DEFAULT '',
                  `payer_status` varchar(255) NOT NULL DEFAULT '',
                  `order_price` varchar(255) NOT NULL DEFAULT '',
                  `order_currency` varchar(255) NOT NULL DEFAULT '',
                  `paid_price` varchar(255) NOT NULL DEFAULT '',
                  `paid_currency` varchar(255) NOT NULL DEFAULT '',
                  `notreaded` int(1) NOT NULL DEFAULT '0',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                    
                //
                // Table structure for table `#__os_cck_orders_details`
                //
                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders_details` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `fk_order_id` int(11) DEFAULT NULL,
                  `fk_user_id` int(11) DEFAULT NULL,
                  `fk_instance_id` int(11) DEFAULT NULL,
                  `instance_title` varchar(255) NOT NULL DEFAULT '',
                  `user_email` varchar(255) NOT NULL DEFAULT '',
                  `user_name` varchar(255) NOT NULL DEFAULT '',
                  `status` varchar(255) NOT NULL DEFAULT '',
                  `order_date` DATETIME,
                  `txn_type` varchar(255) NOT NULL DEFAULT '',
                  `txn_id` varchar(255) NOT NULL DEFAULT '',
                  `payer_id` varchar(255) NOT NULL DEFAULT '',
                  `payer_status` varchar(255) NOT NULL DEFAULT '',
                  `order_price` int(11) DEFAULT NULL,
                  `order_currency` varchar(255) NOT NULL DEFAULT '',
                  `payment_details` text NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '3.3.0':
                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_version` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `current_vers` varchar(255) NOT NULL DEFAULT '',
                  `last_vers` varchar(255) NOT NULL DEFAULT '',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '4.0.0':
                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_version` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `current_vers` varchar(255) NOT NULL DEFAULT '',
                  `last_vers` varchar(255) NOT NULL DEFAULT '',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '4.1.0':
                $query="ALTER TABLE `#__os_cck_categories` ADD `fk_eid` INT(11) NOT NULL AFTER `image`;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '4.2.0':
                $query="ALTER TABLE `#__os_cck_rent` CHANGE `rent_from` `rent_from` TIMESTAMP NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_rent` CHANGE `rent_until` `rent_until` TIMESTAMP NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                break;

            case '5.0.0':
                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `quantity` INT NULL DEFAULT NULL AFTER `featured_shows`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_orders` ADD `quantity` INT NULL DEFAULT NULL AFTER `notreaded`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_orders_details` ADD `quantity` INT NULL DEFAULT NULL AFTER `payment_details`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_orders_details` ADD `comment` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER `quantity`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_video_source` CHANGE `sequence_number` `fk_fid` INT(11) NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `access` VARCHAR(64) NOT NULL AFTER `featured_shows`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `meta_title` VARCHAR(256) NOT NULL AFTER `access`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `meta_description` VARCHAR(256) NOT NULL AFTER `meta_title`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `meta_keywords` VARCHAR(256) NOT NULL AFTER `meta_description`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `meta_robots` TINYINT(2) NOT NULL DEFAULT '0' AFTER `meta_keywords`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_content_instances_price` (
                  `price_id` int(11) NOT NULL AUTO_INCREMENT,
                  `fk_eid` int(11) NOT NULL,
                  `fk_eiid` int(11) NOT NULL,
                  `fk_fid` int(11) NOT NULL,
                  `price_name` varchar(255) NOT NULL DEFAULT '',
                  `price_value` decimal(18,2) NOT NULL,
                  `quantity` int(11) NOT NULL,
                  `ordering` tinyint(4) NOT NULL,
                  PRIMARY KEY (`price_id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();

                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders_price` (
                  `fk_order_id` int(11) NOT NULL,
                  `fk_price_id` int(11) NOT NULL,
                  `fk_eid` int(11) NOT NULL,
                  `fk_eiid` int(11) NOT NULL,
                  `fk_fid` int(11) NOT NULL,
                  `price_name` varchar(255) NOT NULL DEFAULT '',
                  `price_value` decimal(18,2) NOT NULL,
                  `quantity` int(11) NOT NULL,
                  `price_type` varchar(16) NOT NULL DEFAULT '',
                  `price_ordering` tinyint(4) NOT NULL
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '5.5.0':
                $query="ALTER TABLE `#__os_cck_orders_price` ADD `сart_item` TINYINT(2) NOT NULL AFTER `price_ordering`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_orders_details` ADD `row_data` TEXT NOT NULL AFTER `comment`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_orders` ADD `number_of_downloads` INT NOT NULL DEFAULT '0' AFTER `quantity`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_coupons` (
                  `coup_id` int(11) NOT NULL AUTO_INCREMENT,
                  `name` varchar(255) NOT NULL,
                  `type` varchar(16) NOT NULL,
                  `creation_date` date NOT NULL,
                  `date_start` date NOT NULL,
                  `date_finish` date NOT NULL,
                  `value` int(11) NOT NULL,
                  `used_number` int(11) NOT NULL,
                  `max_uses` int(11) NOT NULL,
                  `entities` varchar(255) NOT NULL,
                  `user_group_ids` varchar(255) NOT NULL,
                  `category_ids` varchar(255) NOT NULL,
                  `published` tinyint(2) NOT NULL,
                  PRIMARY KEY (`coup_id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();
                
                break;

            case '6.1.0':
                $query="ALTER TABLE `#__os_cck_content_instances_price` ADD INDEX(`fk_eid`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_content_instances_price` ADD INDEX(`fk_eiid`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_content_instances_price` ADD INDEX(`fk_fid`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_child_parent_connect` ADD INDEX(`media_type`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_field` ADD INDEX(`published`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                break;

            case '6.5.0':
                $query="ALTER TABLE `#__os_cck_entity` ADD `type` VARCHAR(16) NOT NULL DEFAULT 'os_cck_entity' AFTER `name`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity` ADD `sql_select` TEXT NOT NULL AFTER `checked_out_time`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity` ADD `custom_fields` TEXT NOT NULL AFTER `sql_select`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="CREATE TABLE IF NOT EXISTS `#__os_cck_api` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `service` varchar(255) NOT NULL,
                  `key` text NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $db->setQuery($query);
                $db->execute();

                break;

            case '7.0.0':
                $query="ALTER TABLE `#__os_cck_layout` ADD `pdf_structure` BLOB NOT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_layout` ADD `associate_layout` VARCHAR(255) NULL DEFAULT NULL AFTER `pdf_structure`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_layout` ADD `language` VARCHAR(16) NULL DEFAULT '*' AFTER `associate_layout`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `language` VARCHAR(16) NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD `associate_instances` VARCHAR(255) NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD `language` VARCHAR(16) NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD `associate_category` VARCHAR(255) NULL DEFAULT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                break;

            case '7.1.0':
                $query="ALTER TABLE `#__os_cck_categories` CHANGE `checked_out_time` `checked_out_time` DATETIME NOT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity` CHANGE `created` `created` DATETIME NOT NULL COMMENT 'The Unix timestamp when the entity was created.';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_entity` CHANGE `changed` `changed` DATETIME NOT NULL COMMENT 'The Unix timestamp when the entity was most recently saved.';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity` CHANGE `checked_out_time` `checked_out_time` DATETIME NOT NULL COMMENT 'Time when checkout started .';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` CHANGE `created` `created` DATETIME NOT NULL COMMENT 'The Unix timestamp when the entity was created.';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` CHANGE `changed` `changed` DATETIME NOT NULL COMMENT 'The Unix timestamp when the entity was most recently saved.';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` CHANGE `checked_out_time` `checked_out_time` DATETIME NOT NULL COMMENT 'Time when checkout started .';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_rent` CHANGE `checked_out_time` `checked_out_time` DATETIME NOT NULL;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                break;


            case '7.2.0':
                $query="ALTER TABLE `#__os_cck_layout` ADD INDEX (`fk_eid`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_layout` ADD INDEX (`published`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_layout` ADD INDEX (`approved`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD INDEX (`access`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_instance` ADD INDEX (`language`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD INDEX `section` (`section`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD INDEX (`language`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD INDEX `parent_id_section_published` (`parent_id`, `section`, `published`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories_connect` ADD INDEX `fk_eiid_fk_cid` (`fk_eiid`, `fk_cid`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_entity_field` ADD INDEX `fk_eid_field_name` (`fk_eid`, `field_name`(20));";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_categories` ADD INDEX `section_ordering` (`section`, `ordering`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_rent` ADD INDEX `fk_eiid_rent_return` (`fk_eiid`, `rent_return`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                $query="ALTER TABLE `#__os_cck_layout` CHANGE `checked_out` `checked_out` INT(11) NOT NULL DEFAULT '0';";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                break;

            case '7.3.0':
                $query="ALTER TABLE `#__os_cck_audio_source` ADD `fk_fid` INT NOT NULL DEFAULT '0' AFTER `fk_eiid`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_track_source` ADD `fk_video_id` INT NOT NULL AFTER `fk_eiid`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                $query="ALTER TABLE `#__os_cck_video_source` ADD `fk_fid` INT NOT NULL DEFAULT '0' AFTER `fk_eiid`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }

                break;

            case '7.4.0':
                $query="ALTER TABLE `#__os_cck_orders_price` ADD `id` INT(11) NOT NULL AUTO_INCREMENT FIRST, ADD PRIMARY KEY (`id`);";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                break;

            case '7.5.0':
                $query="ALTER TABLE `#__os_cck_rent` ADD `request_id` INT(11) NULL AFTER `user_mailing`;";
                $db->setQuery($query);
                try {
                    $db->execute();
                } catch (Exception $ex) {
                    echo $ex->getMessage();
                }
                
                
                break;

            

        }
    }

    static function sqlInstall(){
        $db = JFactory::getDBO();

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_version` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `current_vers` varchar(255) NOT NULL DEFAULT '',
              `last_vers` varchar(255) NOT NULL DEFAULT '',
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }


        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_instance_id` int(11) DEFAULT NULL,
              `fk_request_id` int(11) DEFAULT NULL,
              `instance_type` varchar(255) NOT NULL DEFAULT '',
              `instance_title` varchar(255) NOT NULL DEFAULT '',
              `user_email` varchar(255) NOT NULL DEFAULT '',
              `user_name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_price` varchar(255) NOT NULL DEFAULT '',
              `order_currency` varchar(255) NOT NULL DEFAULT '',
              `paid_price` varchar(255) NOT NULL DEFAULT '',
              `paid_currency` varchar(255) NOT NULL DEFAULT '',
              `notreaded` int(1) NOT NULL DEFAULT '0',
              `quantity` int(11) DEFAULT NULL,
              `number_of_downloads` INT NOT NULL DEFAULT '0',
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders_details` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_order_id` int(11) DEFAULT NULL,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_instance_id` int(11) DEFAULT NULL,
              `instance_title` varchar(255) NOT NULL DEFAULT '',
              `user_email` varchar(255) NOT NULL DEFAULT '',
              `user_name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_price` int(11) DEFAULT NULL,
              `order_currency` varchar(255) NOT NULL DEFAULT '',
              `payment_details` text NOT NULL,
              `quantity` int(11) DEFAULT NULL,
              `comment` TEXT NOT NULL,
              `row_data` TEXT NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS #__os_cck_layout_html (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_lid`int(11) DEFAULT NULL,
              `layout_html` LONGBLOB DEFAULT NULL,
              `bootstrap` int(11) unsigned NOT NULL ,
               FOREIGN KEY (`fk_lid`) REFERENCES #__os_cck_layout(`lid`),
               PRIMARY KEY (`id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_access` (
              `aid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The unique key.',
              `fk_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'The entity or other.id this record affects.',
              `access_type` varchar(64) NOT NULL DEFAULT '' COMMENT 'for what entity, or instance entety, or field or other.',
              `gid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row’s privileges on the entity. Not use now - Reserved to future',
              `realm` varchar(255) NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Each entity access entity can define one or more realms. Not use now - Reserved to future',
              `grant_view` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this entity. Not use now - Reserved to future',
              `grant_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this entity. Not use now - Reserved to future',
              `grant_delete` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this entity.Not use now - Reserved to future',
              PRIMARY KEY (`aid`),
              KEY `aid` (`aid`,`access_type`,`gid`,`realm`),
              KEY `fk_id` (`fk_id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Identifies which realm/grant pairs a user must possess in...' AUTO_INCREMENT=1 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_categories` (
              `cid` int(11) NOT NULL AUTO_INCREMENT,
              `parent_id` int(11) NOT NULL DEFAULT '0',
              `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
              `title` varchar(255) NOT NULL DEFAULT '',
              `name` varchar(255) NOT NULL DEFAULT '',
              `alias` varchar(255) NOT NULL DEFAULT '',
              `image` varchar(255) NOT NULL DEFAULT '',
              `fk_eid` INT(11) NOT NULL DEFAULT '0',
              `section` varchar(50) NOT NULL DEFAULT '',
              `image_position` varchar(30) NOT NULL DEFAULT '',
              `description` text NOT NULL,
              `published` tinyint(1) NOT NULL DEFAULT '0',
              `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
              `checked_out_time` datetime NOT NULL,
              `editor` varchar(50) DEFAULT NULL,
              `ordering` int(11) NOT NULL DEFAULT '0',
              `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
              `count` int(11) NOT NULL DEFAULT '0',
              `params` text NOT NULL,
              `params2` text NOT NULL,
              `rent_request` tinyint(1) DEFAULT '0',
              `buy_request` tinyint(1) DEFAULT '0',
              `show_search` tinyint(1) DEFAULT '0',
              `language` VARCHAR(16) NULL,
              `associate_category` VARCHAR(255) NULL DEFAULT NULL,
              PRIMARY KEY (`cid`),
              KEY `cat_idx` (`section`,`published`,`access`),
              KEY `idx_access` (`access`),
              KEY `idx_checkout` (`checked_out`),
              KEY `published` (`published`),
              KEY `section` (`section`),
              KEY `language` (`language`),
              KEY `cat_idx2` (`published`, `section`, `language`),
              KEY `parent_id_section_published` (`published`, `section`, `language`),
              KEY `section_ordering` (`published`, `section`, `language`)

            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_categories_connect` (
              `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
              `fk_eiid` int(11) NOT NULL DEFAULT '0' COMMENT 'The eiid from table __os_cck_entity_instance.',
              `fk_cid` int(11) DEFAULT NULL COMMENT 'The cid from table __os_cck_categories.',
              PRIMARY KEY (`id`),
              KEY `fk_eiid` (`fk_eiid`),
              KEY `fk_cid` (`fk_cid`),
              KEY `fk_eiid_fk_cid` (`fk_eiid`, `fk_cid`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_entity` (
              `eid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a entity.',
              `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
              `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The name of this type.',
              `type` VARCHAR(16) NOT NULL DEFAULT 'os_cck_entity',
              `fk_userid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.id that owns this entity; initially, this is the user that created it.',
              `published` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the entity is published (visible to non-administrators).',
              `approved` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the entity is approved by administartor (visible to non-administrators).',
              `created` datetime NOT NULL COMMENT 'The Unix timestamp when the entity was created.',
              `changed` datetime NOT NULL COMMENT 'The Unix timestamp when the entity was most recently saved.',
              `checked_out` int(11) NOT NULL DEFAULT '0' COMMENT 'If some user edit this record. There are that userID .',
              `checked_out_time` datetime NOT NULL COMMENT 'Time when checkout started .',
              `sql_select` TEXT NOT NULL,
              `custom_fields` TEXT NOT NULL,
              PRIMARY KEY (`eid`),
              UNIQUE KEY `entity_name` (`name`),
              KEY `entity_changed` (`changed`),
              KEY `entity_created` (`created`),
              KEY `fk_userid` (`fk_userid`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='The base table for entitys.' AUTO_INCREMENT=2 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }


        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_entity_field` (
              `fid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The field id.',
              `fk_eid` int(11) unsigned NOT NULL COMMENT 'The REFERENCES to __os_cck_entity.eid.',
              `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
              `field_name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The machine-readable name of this field.',
              `field_type` varchar(64) NOT NULL DEFAULT '',
              `module` varchar(127) NOT NULL DEFAULT '' COMMENT 'What module/componet/plugin connected with this field',
              `published` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the field is published for edit (visible to non-administrators).',
              `show_in_instance_menu` BOOLEAN NOT NULL DEFAULT '0',
              `db_field_name` varchar(255) NOT NULL DEFAULT '',
              `params` LONGBLOB DEFAULT NULL,
              PRIMARY KEY (`fid`),
              UNIQUE KEY `entity_status_type` (`fid`,`fk_eid`),
              KEY `field_name` (`field_name`),
              KEY `field_type` (`field_type`),
              KEY `fk_eid` (`fk_eid`),
              KEY `published` (`published`),
              KEY `fk_eid_field_name` (`fk_eid`, `field_name`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_entity_instance` (
              `eiid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a entity.',
              `fk_lid` int(11) unsigned NOT NULL COMMENT 'The REFERENCES to #__os_cck_layout.lid.',
              `layout_type` VARCHAR(32) NOT NULL,
              `fk_eid` int(11) unsigned NOT NULL COMMENT 'The REFERENCES to #__os_cck_entity.eid.',
              `title` varchar(255) NOT NULL COMMENT 'The module defining this entity instance title.',
              `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
              `fk_userid` int(11) NOT NULL DEFAULT '0' COMMENT 'The __users.id that owns this entity; initially, this is the user that created it.',
              `published` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the entity is published (visible to non-administrators).',
              `approved` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the entity is approved by administartor (visible to non-administrators).',
              `created` datetime NOT NULL COMMENT 'The Unix timestamp when the entity was created.',
              `changed` datetime NOT NULL COMMENT 'The Unix timestamp when the entity was most recently saved.',
              `checked_out` int(11) NOT NULL DEFAULT '0' COMMENT 'If some user edit this record. There are that userID .',
              `checked_out_time` datetime NOT NULL COMMENT 'Time when checkout started .',
              `teid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'The translation set id for this entity, which equals the entity id of the source post in each set.',
              `hits` int(11) NOT NULL DEFAULT '0' COMMENT 'how much times it was showed',
              `instance_price` int(11) NULL DEFAULT NULL,
              `instance_currency` varchar(255) NULL DEFAULT NULL,
              `notreaded` int(1) NOT NULL DEFAULT '1',
              `featured_clicks` int(100) NOT NULL DEFAULT '-1',
              `featured_shows` int(100) NOT NULL DEFAULT '-1',
              `access` VARCHAR(64) NOT NULL DEFAULT '1',
              `meta_title` VARCHAR(256) NOT NULL,
              `meta_description` VARCHAR(256) NOT NULL,
              `meta_keywords` VARCHAR(256) NOT NULL,
              `meta_robots` TINYINT(2) NOT NULL DEFAULT '0',
              `language` VARCHAR(16) NOT NULL,
              `associate_instances` VARCHAR(255) NOT NULL,
              PRIMARY KEY (`eiid`),
              KEY `fk_eid` (`fk_eid`),
              KEY `fk_lid` (`fk_lid`),
              KEY `fk_userid` (`fk_userid`),
              KEY `entity_title` (`title`),
              KEY `entity_changed` (`changed`),
              KEY `entity_created` (`created`),
              KEY `teid` (`teid`),
              KEY `access` (`access`),
              KEY `language` (`language`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='The table for instances entitys.' AUTO_INCREMENT=6 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_files` (
              `fid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID',
              `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
              `filepath` varchar(255) NOT NULL DEFAULT '' COMMENT 'Path to file',
              `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
              `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
              `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than OS_CCK_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
              `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
              PRIMARY KEY (`fid`),
              KEY `status` (`status`),
              KEY `timestamp` (`timestamp`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_child_parent_connect` (
              `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
              `fid_parent` int(11) unsigned NOT NULL COMMENT 'File ID from table os_cck_files',
              `fid_child` int(11) unsigned NOT NULL COMMENT 'File ID from table os_cck_files, for file image what was created from parent image e.g. for thumbnails ',
              `media_type` varchar(255) NOT NULL,
              PRIMARY KEY (`id`),
              KEY `fid_parent` (`fid_parent`),
              KEY `fid_child` (`fid_child`),
              KEY `media_type` (`media_type`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_layout` (
              `lid` int(11) NOT NULL AUTO_INCREMENT,
              `title` varchar(255) NOT NULL,
              `alias` varchar(255) NOT NULL,
              `fk_eid` int(11) NOT NULL,
              `type` text NOT NULL,
              `params` LONGBLOB NOT NULL,
              `checked_out_time` datetime NOT NULL,
              `checked_out` int(11) NOT NULL DEFAULT '0',
              `published` tinyint(1) NOT NULL DEFAULT '1',
              `approved` tinyint(1) NOT NULL DEFAULT '1',
              `created` datetime NOT NULL,
              `changed` datetime NOT NULL,
              `custom_fields` MEDIUMBLOB NOT NULL,
              `mail` MEDIUMBLOB NOT NULL,
              `pdf_structure` BLOB NOT NULL,
              `associate_layout` VARCHAR(255) NULL DEFAULT NULL,
              `language` VARCHAR(16) NULL DEFAULT '*',
              PRIMARY KEY (`lid`),
              KEY `fk_eid` (`fk_eid`),
              KEY `published` (`published`),
              KEY `approved` (`approved`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_rent` (
              `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
              `fk_eiid` int(11) NOT NULL DEFAULT '0' COMMENT 'The eiid from table __os_cck_entity_instance.',
              `fk_userid` int(11) unsigned DEFAULT NULL,
              `rent_from` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
              `rent_until` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
              `rent_return` date DEFAULT NULL,
              `checked_out` int(11) NOT NULL DEFAULT '0',
              `checked_out_time` datetime NOT NULL,
              `user_name` varchar(150) DEFAULT NULL,
              `user_email` varchar(100) DEFAULT NULL,
              `user_mailing` text,
               `request_id` INT(11) NULL,
              PRIMARY KEY (`id`),
              KEY `fk_eiid` (`fk_eiid`),
              KEY `fk_eiid_rent_return` (`fk_eiid`, `rent_return`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS #__os_cck_video_source (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_eiid`int(11) DEFAULT NULL,
              `fk_fid` int(11) DEFAULT NULL,
              `src` varchar(255) DEFAULT NULL,
              `type` varchar(255) DEFAULT NULL,
              `media`varchar(255) DEFAULT NULL,
              `youtube`varchar(255) DEFAULT NULL,
               FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
               PRIMARY KEY (`id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS #__os_cck_track_source (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_eiid`int(11) DEFAULT NULL,
              `fk_video_id` INT NOT NULL,
              `sequence_number` int(11) DEFAULT NULL,
              `src` varchar(255) DEFAULT NULL,
              `kind` varchar(255) DEFAULT NULL,
              `scrlang` varchar(255) DEFAULT NULL,
              `label` varchar(255) DEFAULT NULL,
               FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
               PRIMARY KEY (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=1  COLLATE utf8_general_ci;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS #__os_cck_audio_source (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_eiid` int(11) DEFAULT NULL,
              `fk_fid` INT NOT NULL DEFAULT '0',
              `sequence_number` int(11) DEFAULT NULL,
              `src` varchar(255) DEFAULT NULL,
              `type`varchar(255) DEFAULT NULL,
               FOREIGN KEY (`fk_eiid`) REFERENCES #__os_cck_entity_instance(`eiid`),
               PRIMARY KEY  (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=1  COLLATE utf8_general_ci;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="DROP TABLE IF EXISTS `#__os_cck_mime_types`;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_mime_types` (
              `mime_ext` varchar(255),
              `mime_type` varchar(255)
            ) ENGINE=MyISAM AUTO_INCREMENT=1 CHARACTER SET `utf8`;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="INSERT INTO `#__os_cck_mime_types` VALUES
              ('atom', 'application/atom+xml'),
                ('atomcat', 'application/atomcat+xml'),
                ('atomsvc', 'application/atomsvc+xml'),
                ('ccxml', 'application/ccxml+xml'),
                ('epub', 'application/epub+zip'),
                ('jar', 'application/java-archive'),
                ('js', 'application/javascript'),
                ('json', 'application/json'),
                ('jsonml', 'application/jsonml+json'),
                ('mads', 'application/mads+xml'),
                ('mathml', 'application/mathml+xml'),
                ('mbox', 'application/mbox'),
                ('mscml', 'application/mediaservercontrol+xml'),
                ('metalink', 'application/metalink+xml'),
                ('meta4', 'application/metalink4+xml'),
                ('mods', 'application/mods+xml'),
                ('doc', 'application/msword'),
                ('dot', 'application/msword'),
                ('bin', 'application/octet-stream'),
                ('so', 'application/octet-stream'),
                ('pkg', 'application/octet-stream'),
                ('dump', 'application/octet-stream'),
                ('elc', 'application/octet-stream'),
                ('deploy', 'application/octet-stream'),
                ('oxps', 'application/oxps'),
                ('pdf', 'application/pdf'),
                ('asc', 'application/pgp-signature'),
                ('sig', 'application/pgp-signature'),
                ('prf', 'application/pics-rules'),
                ('cer', 'application/pkix-cert'),
                ('crl', 'application/pkix-crl'),
                ('ai', 'application/postscript'),
                ('eps', 'application/postscript'),
                ('ps', 'application/postscript'),
                ('rdf', 'application/rdf+xml'),
                ('rs', 'application/rls-services+xml'),
                ('rsd', 'application/rsd+xml'),
                ('rss', 'application/rss+xml'),
                ('rtf', 'application/rtf'),
                ('fxp', 'application/vnd.adobe.fxp'),
                ('fxpl', 'application/vnd.adobe.fxp'),
                ('xdp', 'application/vnd.adobe.xdp+xml'),
                ('xfdf', 'application/vnd.adobe.xfdf'),
                ('ahead', 'application/vnd.ahead.space'),
                ('azf', 'application/vnd.airzip.filesecure.azf'),
                ('azs', 'application/vnd.airzip.filesecure.azs'),
                ('azw', 'application/vnd.amazon.ebook'),
                ('mpkg', 'application/vnd.apple.installer+xml'),
                ('m3u8', 'application/vnd.apple.mpegurl'),
                ('sc', 'application/vnd.ibm.secure-container'),
                ('org', 'application/vnd.lotus-organizer'),
                ('scm', 'application/vnd.lotus-screencam'),
                ('flo', 'application/vnd.micrografx.flo'),
                ('igx', 'application/vnd.micrografx.igx'),
                ('xul', 'application/vnd.mozilla.xul+xml'),
                ('cab', 'application/vnd.ms-cab-compressed'),
                ('xls', 'application/vnd.ms-excel'),
                ('xlm', 'application/vnd.ms-excel'),
                ('xla', 'application/vnd.ms-excel'),
                ('xlc', 'application/vnd.ms-excel'),
                ('xlt', 'application/vnd.ms-excel'),
                ('xlw', 'application/vnd.ms-excel'),
                ('chm', 'application/vnd.ms-htmlhelp'),
                ('thmx', 'application/vnd.ms-officetheme'),
                ('cat', 'application/vnd.ms-pki.seccat'),
                ('ppt', 'application/vnd.ms-powerpoint'),
                ('pps', 'application/vnd.ms-powerpoint'),
                ('pot', 'application/vnd.ms-powerpoint'),
                ('mpp', 'application/vnd.ms-project'),
                ('mpt', 'application/vnd.ms-project'),
                ('docm', 'application/vnd.ms-word.document.macroenabled.12'),
                ('dotm', 'application/vnd.ms-word.template.macroenabled.12'),
                ('wps', 'application/vnd.ms-works'),
                ('wks', 'application/vnd.ms-works'),
                ('wcm', 'application/vnd.ms-works'),
                ('wdb', 'application/vnd.ms-works'),
                ('wpl', 'application/vnd.ms-wpl'),
                ('xps', 'application/vnd.ms-xpsdocument'),
                ('edm', 'application/vnd.novadigm.edm'),
                ('edx', 'application/vnd.novadigm.edx'),
                ('ext', 'application/vnd.novadigm.ext'),
                ('odc', 'application/vnd.oasis.opendocument.chart'),
                ('otc', 'application/vnd.oasis.opendocument.chart-template'),
                ('odb', 'application/vnd.oasis.opendocument.database'),
                ('odf', 'application/vnd.oasis.opendocument.formula'),
                ('odft', 'application/vnd.oasis.opendocument.formula-template'),
                ('odg', 'application/vnd.oasis.opendocument.graphics'),
                ('otg', 'application/vnd.oasis.opendocument.graphics-template'),
                ('odi', 'application/vnd.oasis.opendocument.image'),
                ('oti', 'application/vnd.oasis.opendocument.image-template'),
                ('odp', 'application/vnd.oasis.opendocument.presentation'),
                ('otp', 'application/vnd.oasis.opendocument.presentation-template'),
                ('ods', 'application/vnd.oasis.opendocument.spreadsheet'),
                ('ots', 'application/vnd.oasis.opendocument.spreadsheet-template'),
                ('odt', 'application/vnd.oasis.opendocument.text'),
                ('odm', 'application/vnd.oasis.opendocument.text-master'),
                ('ott', 'application/vnd.oasis.opendocument.text-template'),
                ('oth', 'application/vnd.oasis.opendocument.text-web'),
                ('oxt', 'application/vnd.openofficeorg.extension'),
                ('pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation'),
                ('sldx', 'application/vnd.openxmlformats-officedocument.presentationml.slide'),
                ('ppsx', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow'),
                ('potx', 'application/vnd.openxmlformats-officedocument.presentationml.template'),
                ('xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'),
                ('xltx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'),
                ('docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
                ('dotx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'),
                ('mgp', 'application/vnd.osgeo.mapguide.package'),
                ('vcx', 'application/vnd.vcx'),
                ('vsd', 'application/vnd.visio'),
                ('vst', 'application/vnd.visio'),
                ('vss', 'application/vnd.visio'),
                ('vsw', 'application/vnd.visio'),
                ('vsf', 'application/vnd.vsf'),
                ('wbxml', 'application/vnd.wap.wbxml'),
                ('xar', 'application/vnd.xara'),
                ('vxml', 'application/voicexml+xml'),
                ('wgt', 'application/widget'),
                ('hlp', 'application/winhlp'),
                ('wsdl', 'application/wsdl+xml'),
                ('7z', 'application/x-7z-compressed'),
                ('abw', 'application/x-abiword'),
                ('ace', 'application/x-ace-compressed'),
                ('bz', 'application/x-bzip'),
                ('bz2', 'application/x-bzip2'),
                ('boz', 'application/x-bzip2'),
                ('vcd', 'application/x-cdlink'),
                ('cfs', 'application/x-cfs-compressed'),
                ('chat', 'application/x-chat'),
                ('pgn', 'application/x-chess-pgn'),
                ('nsc', 'application/x-conference'),
                ('cpio', 'application/x-cpio'),
                ('csh', 'application/x-csh'),
                ('deb', 'application/x-debian-package'),
                ('udeb', 'application/x-debian-package'),
                ('dgc', 'application/x-dgc-compressed'),
                ('ncx', 'application/x-dtbncx+xml'),
                ('dtb', 'application/x-dtbook+xml'),
                ('res', 'application/x-dtbresource+xml'),
                ('dvi', 'application/x-dvi'),
                ('gsf', 'application/x-font-ghostscript'),
                ('psf', 'application/x-font-linux-psf'),
                ('otf', 'application/x-font-otf'),
                ('pcf', 'application/x-font-pcf'),
                ('snf', 'application/x-font-snf'),
                ('ttf', 'application/x-font-ttf'),
                ('ttc', 'application/x-font-ttf'),
                ('woff', 'application/x-font-woff'),
                ('arc', 'application/x-freearc'),
                ('gca', 'application/x-gca-compressed'),
                ('ulx', 'application/x-glulx'),
                ('gnumeric', 'application/x-gnumeric'),
                ('gramps', 'application/x-gramps-xml'),
                ('gtar', 'application/x-gtar'),
                ('hdf', 'application/x-hdf'),
                ('install', 'application/x-install-instructions'),
                ('iso', 'application/x-iso9660-image'),
                ('jnlp', 'application/x-java-jnlp-file'),
                ('latex', 'application/x-latex'),
                ('lzh', 'application/x-lzh-compressed'),
                ('lha', 'application/x-lzh-compressed'),
                ('prc', 'application/x-mobipocket-ebook'),
                ('mobi', 'application/x-mobipocket-ebook'),
                ('application', 'application/x-ms-application'),
                ('crd', 'application/x-mscardfile'),
                ('clp', 'application/x-msclip'),
                ('exe', 'application/x-msdownload'),
                ('dll', 'application/x-msdownload'),
                ('com', 'application/x-msdownload'),
                ('bat', 'application/x-msdownload'),
                ('msi', 'application/x-msdownload'),
                ('pub', 'application/x-mspublisher'),
                ('rar', 'application/x-rar-compressed'),
                ('sh', 'application/x-sh'),
                ('shar', 'application/x-shar'),
                ('swf', 'application/x-shockwave-flash'),
                ('sql', 'application/x-sql'),
                ('srt', 'application/x-subrip'),
                ('t3', 'application/x-t3vm-image'),
                ('tar', 'application/x-tar'),
                ('tcl', 'application/x-tcl'),
                ('tex', 'application/x-tex'),
                ('texinfo', 'application/x-texinfo'),
                ('texi', 'application/x-texinfo'),
                ('obj', 'application/x-tgif'),
                ('src', 'application/x-wais-source'),
                ('der', 'application/x-x509-ca-cert'),
                ('crt', 'application/x-x509-ca-cert'),
                ('xpi', 'application/x-xpinstall'),
                ('xz', 'application/x-xz'),
                ('xaml', 'application/xaml+xml'),
                ('xdf', 'application/xcap-diff+xml'),
                ('xht', 'application/xhtml+xml'),
                ('xml', 'application/xml'),
                ('xsl', 'application/xml'),
                ('dtd', 'application/xml-dtd'),
                ('xop', 'application/xop+xml'),
                ('xpl', 'application/xproc+xml'),
                ('xslt', 'application/xslt+xml'),
                ('xspf', 'application/xspf+xml'),
                ('zip', 'application/zip'),
                ('zip', 'application/x-zip'),
                ('zip', 'application/x-zip-compressed'),
                ('adp', 'audio/adpcm'),
                ('au', 'audio/basic'),
                ('snd', 'audio/basic'),
                ('mid', 'audio/midi'),
                ('midi', 'audio/midi'),
                ('kar', 'audio/midi'),
                ('rmi', 'audio/midi'),
                ('mp4a', 'audio/mp4'),
                ('mpga', 'audio/mpeg'),
                ('mp2', 'audio/mpeg'),
                ('mp2a', 'audio/mpeg'),
                ('mp3', 'audio/mpeg'),
                ('m2a', 'audio/mpeg'),
                ('m3a', 'audio/mpeg'),
                ('oga', 'audio/ogg'),
                ('ogg', 'audio/ogg'),
                ('spx', 'audio/ogg'),
                ('s3m', 'audio/s3m'),
                ('sil', 'audio/silk'),
                ('uva', 'audio/vnd.dece.audio'),
                ('uvva', 'audio/vnd.dece.audio'),
                ('eol', 'audio/vnd.digital-winds'),
                ('dra', 'audio/vnd.dra'),
                ('dts', 'audio/vnd.dts'),
                ('dtshd', 'audio/vnd.dts.hd'),
                ('lvp', 'audio/vnd.lucent.voice'),
                ('pya', 'audio/vnd.ms-playready.media.pya'),
                ('rip', 'audio/vnd.rip'),
                ('weba', 'audio/webm'),
                ('aac', 'audio/x-aac'),
                ('aif', 'audio/x-aiff'),
                ('aiff', 'audio/x-aiff'),
                ('aifc', 'audio/x-aiff'),
                ('caf', 'audio/x-caf'),
                ('flac', 'audio/x-flac'),
                ('mka', 'audio/x-matroska'),
                ('m3u', 'audio/x-mpegurl'),
                ('wax', 'audio/x-ms-wax'),
                ('wma', 'audio/x-ms-wma'),
                ('ram', 'audio/x-pn-realaudio'),
                ('ra', 'audio/x-pn-realaudio'),
                ('rmp', 'audio/x-pn-realaudio-plugin'),
                ('wav', 'audio/x-wav'),
                ('xm', 'audio/xm'),
                ('cdx', 'chemical/x-cdx'),
                ('cif', 'chemical/x-cif'),
                ('cmdf', 'chemical/x-cmdf'),
                ('cml', 'chemical/x-cml'),
                ('csml', 'chemical/x-csml'),
                ('xyz', 'chemical/x-xyz'),
                ('bmp', 'image/bmp'),
                ('cgm', 'image/cgm'),
                ('g3', 'image/g3fax'),
                ('gif', 'image/gif'),
                ('ief', 'image/ief'),
                ('jpeg', 'image/jpeg'),
                ('jpg', 'image/jpeg'),
                ('jpe', 'image/jpeg'),
                ('ktx', 'image/ktx'),
                ('png', 'image/png'),
                ('btif', 'image/prs.btif'),
                ('sgi', 'image/sgi'),
                ('svg', 'image/svg+xml'),
                ('svgz', 'image/svg+xml'),
                ('tiff', 'image/tiff'),
                ('tif', 'image/tiff'),
                ('psd', 'image/vnd.adobe.photoshop'),
                ('uvi', 'image/vnd.dece.graphic'),
                ('uvvi', 'image/vnd.dece.graphic'),
                ('uvg', 'image/vnd.dece.graphic'),
                ('uvvg', 'image/vnd.dece.graphic'),
                ('sub', 'text/vnd.dvb.subtitle'),
                ('djvu', 'image/vnd.djvu'),
                ('djv', 'image/vnd.djvu'),
                ('dwg', 'image/vnd.dwg'),
                ('dxf', 'image/vnd.dxf'),
                ('fbs', 'image/vnd.fastbidsheet'),
                ('fpx', 'image/vnd.fpx'),
                ('fst', 'image/vnd.fst'),
                ('mmr', 'image/vnd.fujixerox.edmics-mmr'),
                ('rlc', 'image/vnd.fujixerox.edmics-rlc'),
                ('mdi', 'image/vnd.ms-modi'),
                ('wdp', 'image/vnd.ms-photo'),
                ('npx', 'image/vnd.net-fpx'),
                ('wbmp', 'image/vnd.wap.wbmp'),
                ('xif', 'image/vnd.xiff'),
                ('webp', 'image/webp'),
                ('3ds', 'image/x-3ds'),
                ('ras', 'image/x-cmu-raster'),
                ('cmx', 'image/x-cmx'),
                ('fh', 'image/x-freehand'),
                ('fhc', 'image/x-freehand'),
                ('fh4', 'image/x-freehand'),
                ('fh5', 'image/x-freehand'),
                ('fh7', 'image/x-freehand'),
                ('ico', 'image/x-icon'),
                ('sid', 'image/x-mrsid-image'),
                ('pcx', 'image/x-pcx'),
                ('pic', 'image/x-pict'),
                ('pct', 'image/x-pict'),
                ('pnm', 'image/x-portable-anymap'),
                ('pbm', 'image/x-portable-bitmap'),
                ('pgm', 'image/x-portable-graymap'),
                ('ppm', 'image/x-portable-pixmap'),
                ('rgb', 'image/x-rgb'),
                ('tga', 'image/x-tga'),
                ('xbm', 'image/x-xbitmap'),
                ('xpm', 'image/x-xpixmap'),
                ('xwd', 'image/x-xwindowdump'),
                ('eml', 'message/rfc822'),
                ('mime', 'message/rfc822'),
                ('igs', 'model/iges'),
                ('iges', 'model/iges'),
                ('msh', 'model/mesh'),
                ('mesh', 'model/mesh'),
                ('ics', 'text/calendar'),
                ('ifb', 'text/calendar'),
                ('css', 'text/css'),
                ('csv', 'text/csv'),
                ('html', 'text/html'),
                ('htm', 'text/html'),
                ('txt', 'text/plain'),
                ('text', 'text/plain'),
                ('conf', 'text/plain'),
                ('def', 'text/plain'),
                ('list', 'text/plain'),
                ('log', 'text/plain'),
                ('sgml', 'text/sgml'),
                ('sgm', 'text/sgml'),
                ('man', 'text/troff'),
                ('ttl', 'text/turtle'),
                ('uri', 'text/uri-list'),
                ('uris', 'text/uri-list'),
                ('urls', 'text/uri-list'),
                ('vcard', 'text/vcard'),
                ('curl', 'text/vnd.curl'),
                ('dcurl', 'text/vnd.curl.dcurl'),
                ('scurl', 'text/vnd.curl.scurl'),
                ('mcurl', 'text/vnd.curl.mcurl'),
                ('fly', 'text/vnd.fly'),
                ('flx', 'text/vnd.fmi.flexstor'),
                ('gv', 'text/vnd.graphviz'),
                ('3dml', 'text/vnd.in3d.3dml'),
                ('spot', 'text/vnd.in3d.spot'),
                ('jad', 'text/vnd.sun.j2me.app-descriptor'),
                ('wml', 'text/vnd.wap.wml'),
                ('wmls', 'text/vnd.wap.wmlscript'),
                ('s', 'text/x-asm'),
                ('asm', 'text/x-asm'),
                ('c', 'text/x-c'),
                ('cc', 'text/x-c'),
                ('cxx', 'text/x-c'),
                ('cpp', 'text/x-c'),
                ('h', 'text/x-c'),
                ('hh', 'text/x-c'),
                ('dic', 'text/x-c'),
                ('f', 'text/x-fortran'),
                ('for', 'text/x-fortran'),
                ('f77', 'text/x-fortran'),
                ('f90', 'text/x-fortran'),
                ('java', 'text/x-java-source'),
                ('opml', 'text/x-opml'),
                ('p', 'text/x-pascal'),
                ('pas', 'text/x-pascal'),
                ('nfo', 'text/x-nfo'),
                ('etx', 'text/x-setext'),
                ('sfv', 'text/x-sfv'),
                ('uu', 'text/x-uuencode'),
                ('vcs', 'text/x-vcalendar'),
                ('vcf', 'text/x-vcard'),
                ('3gp', 'video/3gpp'),
                ('3g2', 'video/3gpp2'),
                ('h261', 'video/h261'),
                ('h263', 'video/h263'),
                ('h264', 'video/h264'),
                ('jpgv', 'video/jpeg'),
                ('jpm', 'video/jpm'),
                ('jpgm', 'video/jpm'),
                ('mj2', 'video/mj2'),
                ('mjp2', 'video/mj2'),
                ('mp4', 'video/mp4'),
                ('mp4v', 'video/mp4'),
                ('mpg4', 'video/mp4'),
                ('mpeg', 'video/mpeg'),
                ('mpg', 'video/mpeg'),
                ('mpe', 'video/mpeg'),
                ('m1v', 'video/mpeg'),
                ('m2v', 'video/mpeg'),
                ('ogv', 'video/ogg'),
                ('qt', 'video/quicktime'),
                ('mov', 'video/quicktime'),
                ('uvh', 'video/vnd.dece.hd'),
                ('uvvh', 'video/vnd.dece.hd'),
                ('uvm', 'video/vnd.dece.mobile'),
                ('uvvm', 'video/vnd.dece.mobile'),
                ('uvp', 'video/vnd.dece.pd'),
                ('uvvp', 'video/vnd.dece.pd'),
                ('uvs', 'video/vnd.dece.sd'),
                ('uvvs', 'video/vnd.dece.sd'),
                ('uvv', 'video/vnd.dece.video'),
                ('uvvv', 'video/vnd.dece.video'),
                ('dvb', 'video/vnd.dvb.file'),
                ('fvt', 'video/vnd.fvt'),
                ('mxu', 'video/vnd.mpegurl'),
                ('m4u', 'video/vnd.mpegurl'),
                ('pyv', 'video/vnd.ms-playready.media.pyv'),
                ('uvu', 'video/vnd.uvvu.mp4'),
                ('uvvu', 'video/vnd.uvvu.mp4'),
                ('viv', 'video/vnd.vivo'),
                ('webm', 'video/webm'),
                ('f4v', 'video/x-f4v'),
                ('fli', 'video/x-fli'),
                ('flv', 'video/x-flv'),
                ('m4v', 'video/x-m4v'),
                ('mkv', 'video/x-matroska'),
                ('mk3d', 'video/x-matroska'),
                ('mks', 'video/x-matroska'),
                ('mng', 'video/x-mng'),
                ('asf', 'video/x-ms-asf'),
                ('asx', 'video/x-ms-asf'),
                ('vob', 'video/x-ms-vob'),
                ('wm', 'video/x-ms-wm'),
                ('wmv', 'video/x-ms-wmv'),
                ('wmx', 'video/x-ms-wmx'),
                ('wvx', 'video/x-ms-wvx'),
                ('avi', 'video/x-msvideo'),
                ('movie', 'video/x-sgi-movie'),
                ('smv', 'video/x-smv'),
                ('ice', 'x-conference/x-cooltalk');";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_content_instances_price` (
              `price_id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_eid` int(11) NOT NULL,
              `fk_eiid` int(11) NOT NULL,
              `fk_fid` int(11) NOT NULL,
              `price_name` varchar(255) NOT NULL DEFAULT '',
              `price_value` decimal(18,2) NOT NULL,
              `quantity` int(11) NOT NULL,
              `ordering` tinyint(4) NOT NULL,
              PRIMARY KEY (`price_id`),
              KEY `fk_eid` (`fk_eid`),
              KEY `fk_eiid` (`fk_eiid`),
              KEY `fk_fid` (`fk_fid`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_orders_price` (
              `id` INT(11) NOT NULL AUTO_INCREMENT,
              `fk_order_id` int(11) NOT NULL,
              `fk_price_id` int(11) NOT NULL,
              `fk_eid` int(11) NOT NULL,
              `fk_eiid` int(11) NOT NULL,
              `fk_fid` int(11) NOT NULL,
              `price_name` varchar(255) NOT NULL DEFAULT '',
              `price_value` decimal(18,2) NOT NULL,
              `quantity` int(11) NOT NULL,
              `price_type` varchar(16) NOT NULL DEFAULT '',
              `price_ordering` tinyint(4) NOT NULL,
              `сart_item` tinyint(2) NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_coupons` (
              `coup_id` int(11) NOT NULL AUTO_INCREMENT,
              `name` varchar(255) NOT NULL,
              `type` varchar(16) NOT NULL,
              `creation_date` date NOT NULL,
              `date_start` date NOT NULL,
              `date_finish` date NOT NULL,
              `value` int(11) NOT NULL,
              `used_number` int(11) NOT NULL,
              `max_uses` int(11) NOT NULL,
              `entities` varchar(255) NOT NULL,
              `user_group_ids` varchar(255) NOT NULL,
              `category_ids` varchar(255) NOT NULL,
              `published` tinyint(2) NOT NULL,
              PRIMARY KEY (`coup_id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

        $query="CREATE TABLE IF NOT EXISTS `#__os_cck_api` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `service` varchar(255) NOT NULL,
              `key` text NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        try {
            $db->execute();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }

    }


    
    

}
