<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

$fName = $field->db_field_name;

$fld_published = (isset($fields_from_params[$fName.'_published']) && $fields_from_params[$fName.'_published'] == 1) ? 'checked="true"' : '';
$fld_published = (!isset($fields_from_params[$fName.'_published'])) ? 'checked="true"' : $fld_published;

$fld_alias = (isset($fields_from_params[$fName.'_alias'])) ? $fields_from_params[$fName.'_alias'] : $fName;
$calculation_order = (isset($fields_from_params[$fName.'_calculation_order'])) ? $fields_from_params[$fName.'_calculation_order'] : 1;
$description_show = (isset($fields_from_params['description_'.$fName])) ? 'checked="true"' : '';
$field_tooltip = (isset($fields_from_params[$fName.'_tooltip'])) ? $fields_from_params[$fName.'_tooltip'] : '';
$field_prefix = (isset($fields_from_params[$fName.'_prefix'])) ? $fields_from_params[$fName.'_prefix'] : '';
$field_suffix = (isset($fields_from_params[$fName.'_suffix'])) ? $fields_from_params[$fName.'_suffix'] : '';
$field_digits_points = (isset($fields_from_params[$fName.'_digits_points'])) ? $fields_from_params[$fName.'_digits_points'] : 0;
$field_decimal_separator = (isset($fields_from_params[$fName.'_decimal_separator'])) ? $fields_from_params[$fName.'_decimal_separator'] : '.';
$field_thousands_separator = (isset($fields_from_params[$fName.'_thousands_separator'])) ? $fields_from_params[$fName.'_thousands_separator'] : '';

$icon_alias_prefix = (isset($fields_from_params[$fName.'_add_icon_alias_prefix'])) ? $fields_from_params[$fName.'_add_icon_alias_prefix'] : '';
$icon_alias_suffix = (isset($fields_from_params[$fName.'_add_icon_alias_suffix'])) ? $fields_from_params[$fName.'_add_icon_alias_suffix'] : '';
$icon_prefix_prefix = (isset($fields_from_params[$fName.'_add_icon_prefix_prefix'])) ? $fields_from_params[$fName.'_add_icon_prefix_prefix'] : '';
$icon_prefix_suffix = (isset($fields_from_params[$fName.'_add_icon_prefix_suffix'])) ? $fields_from_params[$fName.'_add_icon_prefix_suffix'] : '';
$icon_suffix_prefix = (isset($fields_from_params[$fName.'_add_icon_suffix_prefix'])) ? $fields_from_params[$fName.'_add_icon_suffix_prefix'] : '';
$icon_suffix_suffix = (isset($fields_from_params[$fName.'_add_icon_suffix_suffix'])) ? $fields_from_params[$fName.'_add_icon_suffix_suffix'] : '';

$label_tag_selected = (isset($fields_from_params['label_tag_'.$fName])) ? $fields_from_params['label_tag_'.$fName] : "div";
$tags = array();
$tags[]  = JHTML::_('select.option','span','span');
$tags[]  = JHTML::_('select.option','div','div');
$tags[]  = JHTML::_('select.option','h1','h1');
$tags[]  = JHTML::_('select.option','h2','h2');
$tags[]  = JHTML::_('select.option','h3','h3');
$tags[]  = JHTML::_('select.option','h4','h4');
$tags[]  = JHTML::_('select.option','h5','h5');
$tags[]  = JHTML::_('select.option','label','label');

$field_php_show = (isset($fields_from_params[$fName.'_php_show'])) ? $fields_from_params[$fName.'_php_show'] : '';

$gtree = get_group_children_tree_cck($layout->type);
$access_selected = (isset($fields_from_params['access_'.$fName])) ? $fields_from_params['access_'.$fName] : '1';

$calculation_order_option = array();
$calculation_order_option[] = JHTML::_('select.option',0,0,'value', 'text', $disable=true);
for($k = 0; $k<50; $k++){
    $calculation_order_option[] = JHTML::_('select.option',$k+1,$k+1,'value', 'text');
}
?>
<div id="options-field-<?php echo $fName?>">

    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" 
        <?php echo $fld_name_show?> value="0">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_NAME")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" <?php echo $fld_name_show?>>
    </div>

    <div class="label_alias_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_ALIAS")?></label>
        <div class="fa <?php echo $icon_alias_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_prefix" value="<?php echo $icon_alias_prefix; ?>">
        <input type="text" size="4" style="float: right;" name="fi_<?php echo $fName?>_alias"  value="<?php echo $fld_alias?>" >
        <div class="fa <?php echo $icon_alias_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_suffix" value="<?php echo $icon_alias_suffix; ?>">
    </div>

    <div>
        <label><?php echo JText::_("COM_OS_CCK_CALCULATION_ORDER")?> </label>
        <?php echo JHTML::_('select.genericlist', $calculation_order_option,  'fi_'. $fName .'_calculation_order', '','value', 'text',$calculation_order)?>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_DESCRIPTION")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_description_<?php echo $fName?>" <?php echo $description_show?>>
    </div>

    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TOOLTIP")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_tooltip"  value="<?php echo $field_tooltip?>" >
    </div>
    <div class="prefix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PREFIX")?></label>
        <div class="fa <?php echo $icon_prefix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_prefix" value="<?php echo $icon_prefix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_prefix"  value="<?php echo $field_prefix?>" >
        <div class="fa <?php echo $icon_prefix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_suffix" value="<?php echo $icon_prefix_suffix; ?>">
    </div>
    <div class="suffix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SUFFIX")?></label>
        <div class="fa <?php echo $icon_suffix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_prefix" value="<?php echo $icon_suffix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_suffix"  value="<?php echo $field_suffix?>" >
        <div class="fa <?php echo $icon_suffix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_suffix" value="<?php echo $icon_suffix_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_DIGITS_POINT")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_DIGITS_POINT_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_digits_points"  value="<?php echo $field_digits_points?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_DECIMAL_SEPARATOR")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_DECIMAL_SEPARATOR_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_decimal_separator"  value="<?php echo $field_decimal_separator?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_THOUSANDS_SEPARATOR")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_THOUSANDS_SEPARATOR_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_thousands_separator"  value="<?php echo $field_thousands_separator?>" >
    </div>
    <input name="<?php echo $cck_calculated_price->db_field_name; ?>[<?php echo $key; ?>]" type="hidden" value="{}">
    <div class="php_show">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    <?php if(isset($cck_entity_configuration[$layout->fk_eid]['check_access_fields']) && $cck_entity_configuration[$layout->fk_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
</div>
